/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.capability;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public interface IDye {
    @Nonnull
    public float[] getDyeColorComponentValues(ItemStack var1);

    public int getDyeColorRGB(ItemStack var1);

    default public boolean isMinecraftDyeColor() {
        return false;
    }

    default public int getDyeColor(ItemStack dye) {
        return this.getDyeColorRGB(dye);
    }

    @Nullable
    default public ResourceLocation getRecipeDyeColor(ItemStack dye) {
        return null;
    }

    public static Optional<IDye> get(ItemStack stack) {
        if (stack != null && !stack.func_190926_b()) {
            if (stack.func_77973_b() instanceof IDye) {
                return Optional.of((IDye)stack.func_77973_b());
            }
            if (stack.func_77973_b() instanceof DyeItem) {
                return Optional.of(DyeItemWrapper.INSTANCE);
            }
        }
        return Optional.empty();
    }

    public static final class DyeItemWrapper
    implements IDye {
        public static final IDye INSTANCE = new DyeItemWrapper();

        @Override
        public float[] getDyeColorComponentValues(ItemStack d) {
            return ((DyeItem)d.func_77973_b()).func_195962_g().func_193349_f();
        }

        @Override
        public int getDyeColorRGB(ItemStack d) {
            return ((DyeItem)d.func_77973_b()).func_195962_g().getColorValue();
        }

        @Override
        public boolean isMinecraftDyeColor() {
            return true;
        }

        @Override
        public int getDyeColor(ItemStack d) {
            return ((DyeItem)d.func_77973_b()).func_195962_g().func_196059_a();
        }

        @Override
        public ResourceLocation getRecipeDyeColor(ItemStack d) {
            return new ResourceLocation("forge:dyes/" + ((DyeItem)d.func_77973_b()).func_195962_g().func_176762_d());
        }

        DyeItemWrapper() {
        }
    }
}

