/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.capability;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.Instructions;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.Strings;
import org.jwaresoftware.mcmods.lib.Tooltips;

@ParametersAreNonnullByDefault
public interface ITemperatureChangeable {
    public static final String NBT_CREATE_HOT = LibInfo.rstring("Heated");
    public static final String NBT_CREATE_COLD = LibInfo.rstring("Cooled");
    public static final String PROPERTY_TEMPERATURE = "temperature";
    public static final String PROPERTY_HEATED = "heated";
    public static final String PROPERTY_COOLED = "cooled";
    public static final String NBT_BONUS_TEMP_TIMELEFT = "BonusTempDuration";
    public static final String NBT_HEATED_FLAG = "Heated";
    public static final String NBT_COOLED_FLAG = "Cooled";
    public static final int DEFAULT_HEATING_DURATION_SECS = 480;
    public static final int DEFAULT_COOLING_DURATION_SECS = 240;
    public static final int DEFAULT_ONGOING_DURATION_SECS = 60;
    public static final int DEFAULT_TEMPERATURE_UPDATE_MODULO = SharedGlue.SECS_TO_TICKS_DURATION_MULTIPLIER();

    public Category getTemperatureDelivery();

    default public int getTemperatureModifier(ItemStack stack) {
        return 0;
    }

    default public boolean canPlayerHeat(ItemStack stack) {
        return false;
    }

    default public boolean canPlayerChill(ItemStack stack) {
        return false;
    }

    default public int getHeatDuration(ItemStack stack) {
        return 480;
    }

    default public int getCoolDuration(ItemStack stack) {
        return 240;
    }

    default public int getBonusTemperatureTimeLeft(ItemStack stack) {
        int ticks = -1;
        if (Instructions.present(stack)) {
            ticks = Instructions.getInteger(stack, NBT_BONUS_TEMP_TIMELEFT, -1);
        }
        return ticks;
    }

    default public int getBonusTemperatureTimeLeftForApply(ItemStack stack, int min) {
        if (min <= 0) {
            min = 60;
        }
        return Math.max(min, this.getBonusTemperatureTimeLeft(stack));
    }

    default public boolean hasBonusTemperature(ItemStack stack) {
        return this.getBonusTemperatureTimeLeft(stack) > 0;
    }

    default public boolean isHeated(ItemStack stack) {
        return Instructions.getFlag(stack, NBT_HEATED_FLAG) && this.hasBonusTemperature(stack);
    }

    default public boolean shouldBeHeated(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n(NBT_CREATE_HOT);
    }

    default public boolean isCooled(ItemStack stack) {
        return Instructions.getFlag(stack, NBT_COOLED_FLAG) && this.hasBonusTemperature(stack);
    }

    default public boolean shouldBeCooled(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n(NBT_CREATE_COLD);
    }

    default public void clearBonusTemperature(ItemStack stack) {
        CompoundNBT instr = Instructions.get(stack);
        if (instr != null) {
            instr.func_82580_o(NBT_BONUS_TEMP_TIMELEFT);
            instr.func_82580_o(NBT_COOLED_FLAG);
            instr.func_82580_o(NBT_HEATED_FLAG);
            if (instr.isEmpty()) {
                Instructions.remove(stack);
            }
        }
    }

    default public int getPercentageBonusTemperatureLeft(ItemStack stack) {
        int percent_left = -1;
        int n = this.getBonusTemperatureTimeLeft(stack);
        if (n > 0) {
            boolean heated = Instructions.getFlag(stack, NBT_HEATED_FLAG);
            float f = (float)n / (heated ? (float)this.getHeatDuration(stack) : (float)this.getCoolDuration(stack));
            percent_left = MathHelper.func_76123_f((float)(f * 100.0f));
        }
        return percent_left;
    }

    default public boolean setHeated(ItemStack stack) {
        boolean changed = false;
        if (stack.func_77973_b() == this) {
            CompoundNBT instr = Instructions.createshell(stack);
            instr.func_82580_o(NBT_COOLED_FLAG);
            instr.func_74768_a(NBT_BONUS_TEMP_TIMELEFT, this.getHeatDuration(stack));
            instr.func_74757_a(NBT_HEATED_FLAG, true);
            changed = true;
        }
        return changed;
    }

    default public boolean setCooled(ItemStack stack) {
        boolean changed = false;
        if (stack.func_77973_b() == this) {
            CompoundNBT instr = Instructions.createshell(stack);
            instr.func_82580_o(NBT_HEATED_FLAG);
            instr.func_74768_a(NBT_BONUS_TEMP_TIMELEFT, this.getCoolDuration(stack));
            instr.func_74757_a(NBT_COOLED_FLAG, true);
            changed = true;
        }
        return changed;
    }

    default public ItemStack asOutput(UsedEffect effect, ItemStack original) {
        ItemStack output = ItemStacks.copy1(original);
        if (!UsedEffect.UNCHANGED.equals((Object)effect)) {
            CompoundNBT data = ItemStacks.getOrCreateData(output);
            data.func_74757_a(UsedEffect.COOLED.equals((Object)effect) ? NBT_CREATE_COLD : NBT_CREATE_HOT, true);
        }
        return output;
    }

    default public boolean tickDownBonusTemperature(ItemStack stack, int decrement) {
        boolean changed = false;
        if (stack.func_77973_b() == this && this.hasBonusTemperature(stack)) {
            CompoundNBT instr = Instructions.get(stack);
            int bonusLeft = instr.func_74762_e(NBT_BONUS_TEMP_TIMELEFT) - decrement;
            if (bonusLeft > 0) {
                instr.func_74768_a(NBT_BONUS_TEMP_TIMELEFT, bonusLeft);
            } else {
                this.clearBonusTemperature(stack);
            }
            changed = true;
        }
        return changed;
    }

    default public boolean onUpdateTickBonusTemperature(ItemStack stack, World world, Entity holder, int slotindex, boolean selected) {
        boolean flipped = false;
        if (SharedGlue.isaServerWorld((IWorldReader)world) && SharedGlue.isaPlayer(holder) && Instructions.present(stack)) {
            PlayerEntity player = (PlayerEntity)holder;
            if (selected && player.func_184587_cr() && player.func_184605_cv() > 0) {
                return false;
            }
            if ((selected || slotindex < 0 || SharedGlue.isAffectingPlayer(stack, player, slotindex)) && player.field_70173_aa % DEFAULT_TEMPERATURE_UPDATE_MODULO == 0 && this.tickDownBonusTemperature(stack, 1) && !this.hasBonusTemperature(stack)) {
                SharedGlue.refreshPlayerHUD(player);
                flipped = true;
            }
        }
        return flipped;
    }

    default public void addBonusTemperatureInformation(ItemStack stack, World world, List<ITextComponent> tooltips) {
        if (this.hasBonusTemperature(stack)) {
            int percent_left = this.getPercentageBonusTemperatureLeft(stack);
            int sec = this.getBonusTemperatureTimeLeft(stack);
            String timeLeft = " < " + Tooltips.getTimeLeftSuffixFromSecs(sec);
            boolean heated = Instructions.getFlag(stack, NBT_HEATED_FLAG);
            TranslationTextComponent tip = new TranslationTextComponent(Strings.tooltipKey("itemsuffix." + (heated ? PROPERTY_HEATED : PROPERTY_COOLED)));
            if (percent_left > 10) {
                tip.func_240701_a_(new TextFormatting[]{TextFormatting.BOLD, heated ? TextFormatting.DARK_RED : TextFormatting.AQUA});
            } else {
                tip.func_240701_a_(new TextFormatting[]{TextFormatting.BOLD, TextFormatting.BLUE});
            }
            IFormattableTextComponent end = new StringTextComponent(timeLeft).func_240699_a_(TextFormatting.DARK_GRAY);
            end.func_150256_b().func_240713_a_(Boolean.valueOf(false));
            tip.func_230529_a_((ITextComponent)end);
            tooltips.add((ITextComponent)tip);
        } else if (stack.func_77942_o()) {
            TextFormatting emphasis = null;
            boolean heated = false;
            CompoundNBT data = stack.func_77978_p();
            if (data.func_74764_b(NBT_CREATE_HOT)) {
                emphasis = TextFormatting.DARK_RED;
                heated = true;
            } else if (data.func_74764_b(NBT_CREATE_COLD)) {
                emphasis = TextFormatting.AQUA;
            }
            if (emphasis != null) {
                TranslationTextComponent tip = new TranslationTextComponent(Strings.tooltipKey("itemsuffix." + (heated ? PROPERTY_HEATED : PROPERTY_COOLED)));
                tip.func_240701_a_(new TextFormatting[]{TextFormatting.BOLD, emphasis});
                tooltips.add((ITextComponent)tip);
            }
        }
    }

    default public UsedEffect onCreateCheckBonusTemperature(ItemStack stack) {
        UsedEffect how = UsedEffect.UNCHANGED;
        if (ItemStacks.hasNonEmptyData(stack)) {
            CompoundNBT data = ItemStacks.getData(stack);
            if (data.func_74764_b(NBT_CREATE_HOT)) {
                if (data.func_74767_n(NBT_CREATE_HOT)) {
                    how = UsedEffect.HEATED;
                }
                data.func_82580_o(NBT_CREATE_HOT);
            }
            if (data.func_74764_b(NBT_CREATE_COLD)) {
                if (how == UsedEffect.UNCHANGED && data.func_74767_n(NBT_CREATE_COLD)) {
                    how = UsedEffect.COOLED;
                }
                data.func_82580_o(NBT_CREATE_COLD);
            }
            ItemStacks.normalizeData(stack);
        }
        return how;
    }

    public static final class TemperaturePropertyGetter {
        @OnlyIn(value=Dist.CLIENT)
        public static final IItemPropertyGetter forEither = new Impl(SupportedEffect.BOTH);
        @OnlyIn(value=Dist.CLIENT)
        public static final IItemPropertyGetter forHeatable = new Impl(SupportedEffect.HEATING);
        @OnlyIn(value=Dist.CLIENT)
        public static final IItemPropertyGetter forCoolable = new Impl(SupportedEffect.COOLING);

        @OnlyIn(value=Dist.CLIENT)
        public static final void forEither(@Nonnull Item item) {
            ItemModelsProperties.func_239418_a_((Item)item, (ResourceLocation)new ResourceLocation(ITemperatureChangeable.PROPERTY_TEMPERATURE), (IItemPropertyGetter)forEither);
        }

        @OnlyIn(value=Dist.CLIENT)
        public static final void forHeatable(@Nonnull Item item) {
            ItemModelsProperties.func_239418_a_((Item)item, (ResourceLocation)new ResourceLocation(ITemperatureChangeable.PROPERTY_TEMPERATURE), (IItemPropertyGetter)forHeatable);
        }

        @OnlyIn(value=Dist.CLIENT)
        public static final void forCoolable(@Nonnull Item item) {
            ItemModelsProperties.func_239418_a_((Item)item, (ResourceLocation)new ResourceLocation(ITemperatureChangeable.PROPERTY_TEMPERATURE), (IItemPropertyGetter)forCoolable);
        }

        @OnlyIn(value=Dist.CLIENT)
        private static final class Impl
        implements IItemPropertyGetter {
            private final SupportedEffect _whatCheck;

            Impl(@Nonnull SupportedEffect support) {
                Validate.notNull((Object)((Object)support));
                this._whatCheck = support;
            }

            public float call(ItemStack stack, ClientWorld world, LivingEntity unused) {
                if (SupportedEffect.BOTH == this._whatCheck) {
                    return this._applyIfEither(stack);
                }
                ITemperatureChangeable cap = (ITemperatureChangeable)stack.func_77973_b();
                return SupportedEffect.HEATING == this._whatCheck ? (cap.isHeated(stack) || cap.shouldBeHeated(stack) ? 1.0f : 0.0f) : (cap.isCooled(stack) || cap.shouldBeCooled(stack) ? 1.0f : 0.0f);
            }

            private final float _applyIfEither(ItemStack stack) {
                float out = 0.0f;
                if (ItemStacks.hasData(stack)) {
                    ITemperatureChangeable cap = (ITemperatureChangeable)stack.func_77973_b();
                    if (cap.shouldBeHeated(stack)) {
                        out = 1.0f;
                    } else if (cap.shouldBeCooled(stack)) {
                        out = 2.0f;
                    } else if (cap.isHeated(stack)) {
                        out = 1.0f;
                    } else if (cap.isCooled(stack)) {
                        out = 2.0f;
                    }
                }
                return out;
            }
        }
    }

    public static enum Category {
        CONSUMED,
        WORN,
        CARRIED;

    }

    public static enum UsedEffect {
        UNCHANGED,
        HEATED,
        COOLED;


        @Nonnull
        public static final UsedEffect fromString(@Nullable String s) {
            if (HEATED.name().equals(s)) {
                return HEATED;
            }
            if (COOLED.name().equals(s)) {
                return COOLED;
            }
            return UNCHANGED;
        }
    }

    public static enum SupportedEffect {
        HEATING,
        COOLING,
        BOTH;

    }
}

