/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.capability;

import java.util.Locale;
import java.util.Random;
import java.util.function.DoubleSupplier;
import java.util.function.IntSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.tags.ITag;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.capability.IGradeable;

public enum QualityGrade implements IStringSerializable,
DoubleSupplier,
IntSupplier
{
    UNKNOWN(null, TextFormatting.BLACK, 0.0f, null, null, new String[0]),
    VERYPOOR(null, TextFormatting.DARK_GRAY, 0.05f, "minecraft:stripped_oak_wood", "minecraft:logs", "0", "reject", "forager", "wood", "nickel", "tin", "zinc"),
    POOR(Rarity.COMMON, TextFormatting.DARK_GRAY, 0.1f, "minecraft:stone_bricks", "minecraft:stone_bricks", "1", "miner", "stone", "brass"),
    BASE(Rarity.COMMON, TextFormatting.GRAY, 0.2f, "minecraft:book", "forge:bookshelves", "2", "player", "builder", "paper", "quartz", "copper", "bronze"),
    GOOD(Rarity.UNCOMMON, TextFormatting.WHITE, 0.4f, "minecraft:iron_ingot", "forge:ingots/iron", "3", "tinkerer", "iron", "silver", "invar"),
    VERYGOOD(Rarity.UNCOMMON, TextFormatting.GOLD, 0.5f, "minecraft:gold_ingot", "forge:ingots/gold", "4", "farmer", "gold", "electrum", "steel"),
    EXCELLENT(Rarity.RARE, TextFormatting.AQUA, 0.7f, "minecraft:diamond", "forge:gems/diamond", "5", "merchant", "diamond", "obsidian", "platinum"),
    GREAT(Rarity.RARE, TextFormatting.DARK_GREEN, 0.8f, "minecraft:emerald", "forge:gems/emerald", "6", "librarian", "emerald", "titanium"),
    EPIC(Rarity.EPIC, TextFormatting.DARK_AQUA, 0.9f, "minecraft:nether_star", "forge:nether_stars", "8", "cartographer", "emerald2", "amethyst"),
    LEGENDARY(Rarity.EPIC, TextFormatting.DARK_PURPLE, 1.0f, "minecraft:netherite_ingot", null, "10", "archivist", "netherite", "emerald3");

    public static final QualityGrade WOOD;
    public static final QualityGrade STONE;
    public static final QualityGrade PAPER;
    public static final QualityGrade COPPER;
    public static final QualityGrade IRON;
    public static final QualityGrade GOLD;
    public static final QualityGrade DIAMOND;
    public static final QualityGrade EMERALD;
    public static final QualityGrade NETHERSTAR;
    public static final QualityGrade NETHERITE;
    public static final EnumProperty<QualityGrade> ENUM_STATE_PROPERTY;
    public static final IntegerProperty INT_STATE_PROPERTY;
    private static final QualityGrade[] _VALUES_CACHE;
    public static final QualityGrade LOWEST;
    public static final QualityGrade HIGHEST;
    private final String _name_lc;
    private final float _value;
    @Nullable
    private final Rarity _rarity;
    private final TextFormatting _color;
    @Nullable
    private final ResourceLocation _barter_given;
    @Nullable
    private final String _barter_group;
    @Nullable
    private final String[] _synonyms;

    private QualityGrade(Rarity r, TextFormatting c, float f, String given, String group, String ... synonyms) {
        this._color = c;
        this._value = f;
        this._name_lc = this.name().toLowerCase(Locale.US);
        this._rarity = r;
        this._barter_given = given == null ? null : new ResourceLocation(given);
        this._barter_group = group;
        this._synonyms = synonyms != null && synonyms.length > 0 ? synonyms : null;
    }

    public float value() {
        return this._value;
    }

    public final int propertyValue() {
        return this.ordinal();
    }

    @Nonnull
    public String func_176610_l() {
        return this._name_lc;
    }

    public String toString() {
        return this._name_lc;
    }

    @Nonnull
    public String suffix() {
        return this == UNKNOWN ? "" : "_" + this._name_lc;
    }

    @Nonnull
    public IFormattableTextComponent getDisplayName() {
        return new TranslationTextComponent(LibInfo.lstring("qualitygrade." + this.func_176610_l()));
    }

    @Nonnull
    public TextFormatting getTipColor() {
        return this._color;
    }

    @Nullable
    public Rarity rarityOrNull() {
        return this._rarity;
    }

    @Nonnull
    public Item defaultBarterItem() {
        return this == UNKNOWN || this._barter_given == null ? Items.field_190931_a : (Item)ForgeRegistries.ITEMS.getValue(this._barter_given);
    }

    @Nullable
    public ITag<Item> defaultBarterGroup() {
        return this._barter_group != null ? RID.getTag(this._barter_group) : null;
    }

    public final boolean isKnown() {
        return this != UNKNOWN;
    }

    public static final boolean isKnown(@Nullable QualityGrade qgrade) {
        return qgrade != null && qgrade.isKnown();
    }

    public static final boolean isUnknown(@Nullable QualityGrade qgrade) {
        return qgrade == null || qgrade == UNKNOWN;
    }

    private final boolean matches(String s) {
        if (this._name_lc.equals(s)) {
            return true;
        }
        if (this._synonyms != null) {
            for (String altname : this._synonyms) {
                if (!altname.equals(s)) continue;
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public static final QualityGrade sameOrUnknown(@Nullable QualityGrade g) {
        return g == null ? UNKNOWN : g;
    }

    @Nullable
    public static final QualityGrade findOrDefault(@Nullable String s, @Nullable QualityGrade valueIfMissing) {
        if ((s = StringUtils.trimToNull((String)s)) != null) {
            s = s.toLowerCase(Locale.ROOT);
            for (QualityGrade g : _VALUES_CACHE) {
                if (!g.matches(s)) continue;
                return g;
            }
        }
        return valueIfMissing;
    }

    @Nonnull
    public static final QualityGrade findOrUnknown(@Nullable String s) {
        return QualityGrade.findOrDefault(s, UNKNOWN);
    }

    public static final boolean isDefined(ItemStack stack) {
        return IGradeable.QualityGradePropertyGetter.has(stack);
    }

    @Nonnull
    public static final QualityGrade getOrUnknown(ItemStack from) {
        return IGradeable.QualityGradePropertyGetter.getFrom(from);
    }

    @Nullable
    public static final QualityGrade getOrNull(ItemStack from) {
        QualityGrade g = IGradeable.QualityGradePropertyGetter.getFrom(from);
        return g.isKnown() ? g : null;
    }

    public static final ItemStack set(ItemStack stack, QualityGrade with) {
        if (with != null) {
            IGradeable.QualityGradePropertyGetter.setToTag(stack, with);
        }
        return stack;
    }

    public final boolean isEqualOrBetter(@Nonnull QualityGrade other) {
        return this.ordinal() >= other.ordinal();
    }

    public final boolean isBetter(@Nonnull QualityGrade other) {
        return this.ordinal() > other.ordinal();
    }

    public final boolean isWorse(@Nonnull QualityGrade other) {
        return this == UNKNOWN && other != UNKNOWN || this.ordinal() < other.ordinal();
    }

    public final int multiplierTier(@Nonnull QualityGrade other) {
        int d = this.ordinal() - other.ordinal();
        return d < 0 ? 0 : 1 + d;
    }

    public final int multiplierTierFrom(@Nonnull QualityGrade other) {
        int d = this.multiplierTier(other);
        return d > 1 ? d - 1 : 0;
    }

    @Nonnull
    public final QualityGrade oneUp() {
        return this == UNKNOWN || this.ordinal() == _VALUES_CACHE.length - 1 ? this : _VALUES_CACHE[this.ordinal() + 1];
    }

    @Nonnull
    public final QualityGrade oneDown() {
        return this == UNKNOWN || this == VERYPOOR ? this : _VALUES_CACHE[this.ordinal() - 1];
    }

    public final void apply(ItemStack to) {
        if (!to.func_190926_b()) {
            QualityGrade.set(to, this);
        }
    }

    public static final boolean isEqualOrBetter(ItemStack item, @Nonnull QualityGrade minimum) {
        return minimum != null && !item.func_190926_b() && QualityGrade.getOrUnknown(item).isEqualOrBetter(minimum);
    }

    public static final boolean isBaseOrBetter(ItemStack item) {
        return !item.func_190926_b() && QualityGrade.getOrUnknown(item).isEqualOrBetter(BASE);
    }

    public static final boolean isGoldOrBetter(ItemStack item) {
        return !item.func_190926_b() && QualityGrade.getOrUnknown(item).isEqualOrBetter(GOLD);
    }

    public static final boolean isDiamondOrBetter(ItemStack item) {
        return !item.func_190926_b() && QualityGrade.getOrUnknown(item).isEqualOrBetter(DIAMOND);
    }

    public static final boolean isEpicOrBetter(ItemStack item) {
        return !item.func_190926_b() && QualityGrade.getOrUnknown(item).isEqualOrBetter(EPIC);
    }

    public static final boolean isAsOrRarer(QualityGrade qgrade, Rarity base) {
        if (qgrade == null) {
            return false;
        }
        Rarity r = qgrade.rarityOrNull();
        if (r == null) {
            return base == null;
        }
        if (base == null) {
            return true;
        }
        return r.ordinal() >= base.ordinal();
    }

    @Override
    public final int getAsInt() {
        return (int)(this.value() * 100.0f);
    }

    @Override
    public final double getAsDouble() {
        return this.value();
    }

    public static final ITextComponent enrichLabel(QualityGrade qgrade, ITextComponent cur_label, char poor_symbol) {
        ITextComponent new_label = cur_label;
        if (QualityGrade.isKnown(qgrade)) {
            int count = 0;
            String symbol = null;
            if (qgrade.isEqualOrBetter(BASE)) {
                count = Math.min(6, qgrade.multiplierTier(BASE));
                symbol = StringUtils.repeat((char)'\u2726', (int)count);
            } else if (poor_symbol != '\u0000') {
                count = qgrade == POOR ? 2 : 1;
                symbol = StringUtils.repeat((char)poor_symbol, (int)count);
            }
            if (symbol != null) {
                new_label = new TranslationTextComponent("tooltip.itemsuffix.qgrade", new Object[]{cur_label, new StringTextComponent(symbol).func_240699_a_(qgrade.getTipColor())});
            }
        }
        return new_label;
    }

    static final QualityGrade[] VALUES_CACHE() {
        return _VALUES_CACHE;
    }

    static {
        WOOD = VERYPOOR;
        STONE = POOR;
        PAPER = BASE;
        COPPER = BASE;
        IRON = GOOD;
        GOLD = VERYGOOD;
        DIAMOND = EXCELLENT;
        EMERALD = GREAT;
        NETHERSTAR = EPIC;
        NETHERITE = LEGENDARY;
        ENUM_STATE_PROPERTY = EnumProperty.func_177709_a((String)"qgrade", QualityGrade.class);
        INT_STATE_PROPERTY = IntegerProperty.func_177719_a((String)"qgrade", (int)UNKNOWN.ordinal(), (int)LEGENDARY.ordinal());
        _VALUES_CACHE = QualityGrade.values();
        LOWEST = _VALUES_CACHE[1];
        HIGHEST = _VALUES_CACHE[_VALUES_CACHE.length - 1];
    }

    public static class Chance
    implements Generator {
        public final float threshold;
        @Nullable
        public final QualityGrade grade;

        public Chance(float chance, @Nullable QualityGrade qgrade) {
            this.threshold = chance;
            this.grade = qgrade;
        }

        @Override
        @Nullable
        public QualityGrade generate(Random rng, @Nullable QualityGrade valueIfMiss) {
            QualityGrade qgrade_out = valueIfMiss;
            if (rng.nextFloat() < this.threshold) {
                qgrade_out = this.grade;
            }
            return qgrade_out;
        }

        @Nonnull
        public static QualityGrade generateFromRange(Random rng, @Nonnull QualityGrade topgrade, float threshold) {
            if (QualityGrade.isUnknown(topgrade)) {
                return UNKNOWN;
            }
            if (threshold > 0.0f && rng.nextFloat() < threshold) {
                return topgrade;
            }
            int i = rng.nextInt(topgrade.ordinal() + 1);
            return QualityGrade.VALUES_CACHE()[i];
        }

        @Nonnull
        public static QualityGrade generateFromRange(Random rng, @Nonnull QualityGrade topgrade) {
            return Chance.generateFromRange(rng, topgrade, -1.0f);
        }

        public CompoundNBT write(CompoundNBT into) {
            if (into == null) {
                into = new CompoundNBT();
            }
            into.func_74778_a("id", this.grade == null ? "-" : this.grade.func_176610_l());
            into.func_74776_a("chance", this.threshold);
            return into;
        }

        @Nullable
        public static final Chance read(CompoundNBT from) {
            Chance chance = null;
            if (from.func_150297_b("id", 8)) {
                String idstring = from.func_74779_i("id");
                QualityGrade qgrade = idstring.isEmpty() || "-".equals(idstring) ? null : QualityGrade.findOrUnknown(idstring);
                chance = new Chance(from.func_74760_g("chance"), qgrade);
            }
            return chance;
        }

        public String toString() {
            return "grade: " + this.grade + ", threshold: " + this.threshold;
        }
    }

    public static interface Generator {
        @Nullable
        public QualityGrade generate(@Nonnull Random var1, @Nullable QualityGrade var2);
    }
}

