/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.AxeItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.PickaxeItem;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import org.jwaresoftware.mcmods.lib.Armory;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.ICursed;
import org.jwaresoftware.mcmods.lib.api.combat.IMeleeWeapon;
import org.jwaresoftware.mcmods.lib.api.combat.IPiercingWeapon;

public class AttributeSupport {
    private static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create(Attribute.class, (String)"carrots");
    public static final RegistryObject<Attribute> REACH_DISTANCE_ATTRIB = ForgeMod.REACH_DISTANCE;
    public static final UUID REACH_MODIFIER = UUID.fromString("066E3865-16A8-437F-9CAE-576C7C8A9203");
    public static final UUID ARMOR_MODIFIER = UUID.fromString("7254f89c-0704-4386-86ff-eac15075b01e");
    public static final UUID ARMOR_TOUGHNESS_MODIFIER = UUID.fromString("cdc4f9e9-43cf-4cd2-8266-d36ce6e8ab4b");
    public static final UUID ARMOR_SPEED_MODIFIER = UUID.fromString("5b0e6a43-362f-482e-b737-33eaac5dfbbc");
    public static final RegistryObject<Attribute> DURABILITY_ATTRIB = ATTRIBUTES.register("material_durability", () -> new RangedAttribute(AttributeSupport.a("materialDurability"), 0.0, 0.0, 19999.0));
    public static final UUID DURABILITY_MODIFIER = UUID.fromString("26694011-378A-4DB1-8B06-E9DA711CA288");
    public static final RegistryObject<Attribute> REINFORCEMENT_ATTRIB = ATTRIBUTES.register("material_reinforcement", () -> new RangedAttribute(AttributeSupport.a("materialReinforcement"), 0.0, 0.0, 8.0));
    public static final UUID REINFORCEMENT_MODIFIER = UUID.fromString("0E856DB9-A1A6-4A88-B5BE-41115A13D6F6");
    public static final RegistryObject<Attribute> PRECISION_ATTRIB = ATTRIBUTES.register("material_precision", () -> new RangedAttribute(AttributeSupport.a("materialPrecision"), 0.0, 0.0, 2.0));
    public static final UUID PRECISION_MODIFIER = UUID.fromString("CA92A209-CD65-4A68-BD0E-DB67C1C3F4A4");
    public static final RegistryObject<Attribute> CHARM_ATTRIB = ATTRIBUTES.register("material_charm", () -> new RangedAttribute(AttributeSupport.a("materialCharm"), 0.0, 0.0, 10.0));
    public static final RegistryObject<Attribute> PLAYER_CHARM_ATTRIB = ATTRIBUTES.register("charm", () -> new RangedAttribute(AttributeSupport.a("playerCharm"), 0.0, 0.0, 10.0).func_233753_a_(true));
    public static final UUID CHARM_MODIFIER = UUID.fromString("C049E051-E145-4FCD-A3B7-475494CEA60C");
    public static final RegistryObject<Attribute> VITALITY_ATTRIB = ATTRIBUTES.register("material_vitality", () -> new RangedAttribute(AttributeSupport.a("materialVitality"), 0.0, 0.0, 10.0));
    public static final RegistryObject<Attribute> PLAYER_VITALITY_ATTRIB = ATTRIBUTES.register("vitality", () -> new RangedAttribute(AttributeSupport.a("playerVitality"), 0.0, 0.0, 10.0).func_233753_a_(true));
    public static final UUID VITALITY_MODIFIER = UUID.fromString("F3F8E9CA-92CF-4E21-8CA0-59BE1334755E");
    public static final RegistryObject<Attribute> PIERCING_ATTRIB = ATTRIBUTES.register("material_piercing", () -> new RangedAttribute(AttributeSupport.a("materialPiercing"), 0.0, 0.0, 0.5));
    public static final RegistryObject<Attribute> VOID_PIERCING_ATTRIB = ATTRIBUTES.register("material_voidpiercing", () -> new RangedAttribute(AttributeSupport.a("materialVoidPiercing"), 0.0, 0.0, 0.5));
    public static final UUID PIERCING_MODIFIER = UUID.fromString("BE2F9B18-9748-45B1-B934-C5160B394659");
    public static final UUID VOID_PIERCING_MODIFIER = UUID.fromString("D2093007-3621-4BE0-8797-A6AAB25AB7FC");
    public static Attribute KNOCKBACK = null;
    public static final RegistryObject<Attribute> KNOCKBACK_ATTRIB = ATTRIBUTES.register("material_knockback", () -> {
        KNOCKBACK = new RangedAttribute(AttributeSupport.a("materialKnockback"), 0.0, 0.0, 8.0);
        return KNOCKBACK;
    });
    public static final UUID KNOCKBACK_MODIFIER = UUID.fromString("6E83511A-44C1-4688-A93C-E5A85119353E");
    public static final RegistryObject<Attribute> SCAVENGE_MENDING_ATTRIB = ATTRIBUTES.register("material_scavenge_mend", () -> new RangedAttribute(AttributeSupport.a("materialScavengeMending"), 0.0, 0.0, 0.1));
    public static final UUID SCAVENGE_MENDING_MODIFIER = UUID.fromString("A91CF64F-7829-43DF-B369-F686B66E7799");
    public static final RegistryObject<Attribute> PARASITIC_MENDING_ATTRIB = ATTRIBUTES.register("material_parasitic_mend", () -> new RangedAttribute(AttributeSupport.a("materialParasiticMending"), 0.0, 0.0, 0.1));
    public static final UUID PARASITIC_MENDING_MODIFIER = UUID.fromString("0043251C-424C-444E-BF95-C3FF0B13B97A");
    public static final RegistryObject<Attribute> ANIMUS_ATTRIB = ATTRIBUTES.register("material_animus", () -> new RangedAttribute(AttributeSupport.a("materialInnateAnimus"), 0.0, 0.0, 1.0).func_233753_a_(true));
    public static final UUID ANIMUS_MODIFIER = UUID.fromString("D43A1E3B-E9B8-4E5A-9D11-7B1609C02185");
    public static final double MAX_EXTENDED_REACH = 3.5;

    private static final String a(String name) {
        return "carrots.attribute." + name;
    }

    public static final boolean isaPaxel(@Nullable ItemStack tool) {
        boolean is = false;
        if (!ItemStacks.isEmpty(tool)) {
            Item item = tool.func_77973_b();
            is = RID.Tags.PAXELS.func_230235_a_((Object)item) || item.getHarvestLevel(tool, SharedGlue.PAXEL, null, null) >= 0;
        }
        return is;
    }

    public static final boolean isaAxe(@Nullable ItemStack tool, boolean confirm) {
        Item item;
        boolean is = AttributeSupport.isaPaxel(tool);
        if (!is && !ItemStacks.isEmpty(tool) && (item = tool.func_77973_b()) instanceof ToolItem) {
            is = item.getHarvestLevel(tool, SharedGlue.AXE, null, confirm ? Blocks.field_196617_K.func_176223_P() : null) >= 0;
        }
        return is;
    }

    public static final boolean isaPickaxe(@Nullable ItemStack tool, boolean confirm) {
        Item item;
        boolean is = AttributeSupport.isaPaxel(tool);
        if (!is && !ItemStacks.isEmpty(tool) && (item = tool.func_77973_b()) instanceof ToolItem) {
            is = item.getHarvestLevel(tool, SharedGlue.PICKAXE, null, confirm ? Blocks.field_150348_b.func_176223_P() : null) >= 0;
        }
        return is;
    }

    public static final boolean isaShovel(@Nullable ItemStack tool, boolean confirm) {
        Item item;
        boolean is = AttributeSupport.isaPaxel(tool);
        if (!is && !ItemStacks.isEmpty(tool) && (item = tool.func_77973_b()) instanceof ToolItem) {
            is = item.getHarvestLevel(tool, SharedGlue.SHOVEL, null, confirm ? Blocks.field_150354_m.func_176223_P() : null) >= 0;
        }
        return is;
    }

    public static final boolean isaSimpleMeleeWeapon(@Nullable ItemStack stack, boolean strict) {
        boolean is;
        boolean bl = is = ModIntegration.MINECRAFT.belongsTo(stack) || ModIntegration.fromSimpleWeaponMod(stack);
        if (is) {
            Item item = stack.func_77973_b();
            boolean bl2 = is = item instanceof SwordItem || item instanceof AxeItem;
            if (!is && !strict) {
                is = item instanceof PickaxeItem || item instanceof HoeItem;
            }
        }
        return is;
    }

    public static final boolean supportsExtendedAttackReach(ItemStack weapon, boolean strict) {
        Item item = weapon.func_77973_b();
        return Armory.Tags.MELEE_WEAPONS.func_230235_a_((Object)item) || item instanceof IMeleeWeapon || AttributeSupport.isaSimpleMeleeWeapon(weapon, strict);
    }

    public static final boolean supportsPiercingAttack(ItemStack weapon) {
        return weapon.func_77973_b() instanceof IPiercingWeapon || AttributeSupport.isaSimpleMeleeWeapon(weapon, true);
    }

    private static Collection<AttributeModifier> getModifiersFor(Collection<AttributeModifier> modifiers, AttributeModifier.Operation operation) {
        ArrayList<AttributeModifier> l = null;
        for (AttributeModifier am : modifiers) {
            if (am.func_220375_c() != operation) continue;
            if (l == null) {
                l = new ArrayList<AttributeModifier>();
            }
            l.add(am);
        }
        return l == null ? Collections.EMPTY_LIST : l;
    }

    private static double computeAttrValue(double default_base, Collection<AttributeModifier> modifiers) {
        double adjusted_base = default_base;
        for (AttributeModifier am : AttributeSupport.getModifiersFor(modifiers, AttributeModifier.Operation.ADDITION)) {
            adjusted_base += am.func_111164_d();
        }
        double value = adjusted_base;
        for (AttributeModifier am : AttributeSupport.getModifiersFor(modifiers, AttributeModifier.Operation.MULTIPLY_BASE)) {
            value += adjusted_base * am.func_111164_d();
        }
        for (AttributeModifier am : AttributeSupport.getModifiersFor(modifiers, AttributeModifier.Operation.MULTIPLY_TOTAL)) {
            value *= 1.0 + am.func_111164_d();
        }
        if (value < -1024.0 || value > 9999.0) {
            value = 0.0;
        }
        return value;
    }

    public static final float getAttrValue(Multimap<Attribute, AttributeModifier> modifiers, float default_base, Attribute attr) {
        double value = AttributeSupport.computeAttrValue(default_base, modifiers.get((Object)attr));
        return (float)value;
    }

    public static final double getAttrValue(double default_base, @Nonnull Collection<AttributeModifier> modifiers) {
        return AttributeSupport.computeAttrValue(default_base, modifiers);
    }

    public static final float getReinforcedModifier(ItemStack toolOrWeapon) {
        Multimap current = toolOrWeapon.func_111283_C(EquipmentSlotType.MAINHAND);
        double r = AttributeSupport.computeAttrValue(1.0, current.get((Object)REINFORCEMENT_ATTRIB.get()));
        return (float)(r - 1.0);
    }

    public static final float getCharmModifier(ItemStack toolOrWeapon) {
        Multimap current = toolOrWeapon.func_111283_C(EquipmentSlotType.MAINHAND);
        double k = AttributeSupport.computeAttrValue(1.0, current.get((Object)CHARM_ATTRIB.get()));
        return (float)(k - 1.0);
    }

    public static final float getPrecisionModifier(ItemStack toolOrWeapon) {
        Multimap current = toolOrWeapon.func_111283_C(EquipmentSlotType.MAINHAND);
        double p = AttributeSupport.computeAttrValue(1.0, current.get((Object)PRECISION_ATTRIB.get()));
        return (float)(p - 1.0);
    }

    public static final float getPiercingModifier(ItemStack weapon) {
        Multimap current = weapon.func_111283_C(EquipmentSlotType.MAINHAND);
        double p = AttributeSupport.computeAttrValue(1.0, current.get((Object)PIERCING_ATTRIB.get()));
        return (float)MathHelper.func_151237_a((double)(p - 1.0), (double)0.0, (double)0.5);
    }

    public static final float getKnockbackModifier(ItemStack toolOrWeapon) {
        Multimap current = toolOrWeapon.func_111283_C(EquipmentSlotType.MAINHAND);
        double k = AttributeSupport.computeAttrValue(1.0, current.get((Object)KNOCKBACK_ATTRIB.get()));
        return (float)(k - 1.0);
    }

    public static final float getVitalityModifier(ItemStack toolOrWeapon) {
        Multimap current = toolOrWeapon.func_111283_C(EquipmentSlotType.MAINHAND);
        double k = AttributeSupport.computeAttrValue(1.0, current.get((Object)VITALITY_ATTRIB.get()));
        return (float)(k - 1.0);
    }

    public static final float getScavengeMendingModifier(ItemStack toolOrWeaponOrArmor) {
        Multimap current = toolOrWeaponOrArmor.func_111283_C(EquipmentSlotType.MAINHAND);
        double m = AttributeSupport.computeAttrValue(1.0, current.get((Object)SCAVENGE_MENDING_ATTRIB.get()));
        m -= 1.0;
        m = MathHelper.func_151237_a((double)m, (double)0.0, (double)0.1);
        return (float)m;
    }

    public static final float getParasiticMendingModifier(ItemStack toolOrWeaponOrArmor) {
        Multimap current = toolOrWeaponOrArmor.func_111283_C(EquipmentSlotType.MAINHAND);
        double m = AttributeSupport.computeAttrValue(1.0, current.get((Object)PARASITIC_MENDING_ATTRIB.get()));
        m -= 1.0;
        double max = toolOrWeaponOrArmor.func_77973_b() instanceof ICursed ? 0.2 : 0.1;
        m = MathHelper.func_151237_a((double)m, (double)0.0, (double)max);
        return (float)m;
    }

    public static final float getAnimusModifier(ItemStack toolOrWeapon) {
        Multimap current = toolOrWeapon.func_111283_C(EquipmentSlotType.MAINHAND);
        double p = AttributeSupport.computeAttrValue(1.0, current.get((Object)ANIMUS_ATTRIB.get()));
        double max = toolOrWeapon.func_77973_b() instanceof ICursed ? 0.7 : 0.5;
        return (float)MathHelper.func_151237_a((double)(p - 1.0), (double)0.0, (double)max);
    }

    private static float getExtendedAttackReachModifier(ItemStack toolOrWeapon, boolean unlimited) {
        double m = 0.0;
        if (unlimited || AttributeSupport.supportsExtendedAttackReach(toolOrWeapon, true)) {
            Multimap current = toolOrWeapon.func_111283_C(EquipmentSlotType.MAINHAND);
            m = AttributeSupport.computeAttrValue(1.0, current.get((Object)REACH_DISTANCE_ATTRIB.get()));
            m -= 1.0;
            m = MathHelper.func_151237_a((double)m, (double)0.0, (double)3.5);
        }
        return (float)m;
    }

    private static double getExtendedAttackReach(PlayerEntity player, float modifier) {
        double reach_sqr = 0.0;
        if (!SharedGlue.isZeroishAbsolute(modifier)) {
            reach_sqr = player.func_110148_a((Attribute)REACH_DISTANCE_ATTRIB.get()).func_111126_e() + 1.0;
        }
        return reach_sqr;
    }

    public static final float getExtendedAttackReachFor(@Nonnull PlayerEntity player, @Nonnull ItemStack held) {
        float modifier = AttributeSupport.getExtendedAttackReachModifier(held, false);
        return (float)AttributeSupport.getExtendedAttackReach(player, modifier);
    }

    public static final float getExtendedAttackReachSquaredFor(@Nonnull PlayerEntity player, @Nonnull ItemStack held) {
        float modifier = AttributeSupport.getExtendedAttackReachModifier(held, false);
        double reach = AttributeSupport.getExtendedAttackReach(player, modifier);
        return (float)(reach * reach);
    }

    public static final boolean checkExtendedAttackReachOverride(@Nonnull ItemStack toolOrWeapon, float value) {
        boolean modified = false;
        if (Armory.hasModifiedAttributes(toolOrWeapon)) {
            float current_value = AttributeSupport.getExtendedAttackReachModifier(toolOrWeapon, false);
            if ((double)current_value < 3.5 && current_value < value) {
                String modifier_attrname = Armory.getWeaponOrToolModifierName(toolOrWeapon);
                toolOrWeapon.func_185129_a((Attribute)REACH_DISTANCE_ATTRIB.get(), new AttributeModifier(UUID.randomUUID(), modifier_attrname, (double)value, AttributeModifier.Operation.ADDITION), EquipmentSlotType.MAINHAND);
            }
            modified = true;
        }
        return modified;
    }

    public static final int getReinforcedDurability(ItemStack toolOrWeapon, int baseline_amount) {
        float f;
        int __ENUF_ALREADY = 1000000000;
        int amount = baseline_amount;
        float f2 = f = amount > 0 ? AttributeSupport.getReinforcedModifier(toolOrWeapon) : 0.0f;
        if (f != 0.0f && !SharedGlue.isZeroishAbsolute(f)) {
            int modifier;
            if ((amount += (modifier = MathHelper.func_76141_d((float)(f * (float)amount)))) < 0) {
                amount = 0;
            } else if (amount > 1000000000) {
                amount = 1000000000;
            }
        }
        return amount;
    }

    public static final void alterTravelingSpeed(@Nonnull Entity traveler, @Nullable BlockPos on, double by) {
        World world = traveler.func_130014_f_();
        Vector3d motion = traveler.func_213322_ci();
        double a = Math.atan2(motion.func_82615_a(), motion.func_82616_c());
        float slipperiness = on == null ? 1.0f : world.func_180495_p(on).getSlipperiness((IWorldReader)world, on, traveler);
        motion = motion.func_72441_c(Math.sin(a) * by * (double)slipperiness, 0.0, Math.cos(a) * by * (double)slipperiness);
        traveler.func_213317_d(motion);
    }

    public static final void initAttributeSupport() {
        ATTRIBUTES.register(FMLJavaModLoadingContext.get().getModEventBus());
        LibInfo.LOG.debug("carrots/lib supporting attributes registered");
    }
}

