/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl;

import java.util.Objects;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import org.jwaresoftware.mcmods.lib.impl.ClampedEnchantment;

public class RestrictedEnchantment
extends ClampedEnchantment {
    protected final Profile _p;

    public RestrictedEnchantment(Enchantment.Rarity r, EnchantmentType t, int max, Profile p, EquipmentSlotType[] slots) {
        super(r, t, max, slots);
        this._p = Objects.requireNonNull(p);
    }

    protected RestrictedEnchantment(Enchantment.Rarity r, EnchantmentType t, EquipmentSlotType[] slots) {
        super(r, t, slots);
        this._p = Profile.locked();
    }

    public RestrictedEnchantment(Enchantment.Rarity r, EnchantmentType t, int max, EquipmentSlotType[] slots) {
        this(r, t, max, Profile.locked(), slots);
    }

    public RestrictedEnchantment(EnchantmentType t, int max, EquipmentSlotType[] slots) {
        this(Enchantment.Rarity.VERY_RARE, t, max, Profile.locked(), slots);
    }

    public boolean func_185261_e() {
        return this._p.treasure;
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack to) {
        return this._p.through_table && super.canApplyAtEnchantingTable(to);
    }

    @Override
    public boolean canApplyAtRepairingAnvil(ItemStack to) {
        return this._p.through_anvil && super.canApplyAtRepairingAnvil(to);
    }

    @Override
    public boolean func_230309_h_() {
        return this._p.tradeable && super.func_230309_h_();
    }

    @Override
    public boolean func_230310_i_() {
        return this._p.lootable && super.func_230310_i_();
    }

    public boolean isAllowedOnBooks() {
        return this._p.bookable;
    }

    public static final class Profile {
        public boolean treasure = true;
        public boolean tradeable;
        public boolean lootable;
        public boolean through_table;
        public boolean bookable;
        public boolean through_anvil;

        public Profile treasure() {
            this.treasure = true;
            return this;
        }

        public Profile common() {
            this.treasure = false;
            return this;
        }

        public Profile trade() {
            this.tradeable = true;
            return this;
        }

        public Profile notrade() {
            this.tradeable = false;
            return this;
        }

        public Profile loot() {
            this.lootable = true;
            return this;
        }

        public Profile bookform() {
            this.bookable = true;
            return this;
        }

        public Profile anvil() {
            this.through_anvil = true;
            return this;
        }

        public Profile table() {
            this.through_table = true;
            return this;
        }

        public static final Profile locked() {
            return new Profile();
        }

        public static final Profile unlocked() {
            return new Profile().loot().bookform().anvil().table();
        }

        public static final Profile lootable() {
            return new Profile().loot().bookform().anvil();
        }
    }
}

