/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.block;

import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.IAirPlaceable;
import org.jwaresoftware.mcmods.lib.api.IModBlock;
import org.jwaresoftware.mcmods.lib.impl.ItemSupport;
import org.jwaresoftware.mcmods.lib.impl.block.AirGrabbingItemBlock;
import org.jwaresoftware.mcmods.lib.impl.block.BlockSupport;
import org.jwaresoftware.mcmods.lib.impl.block.ItemBlockBase;

public class BlockBase
extends Block
implements IModBlock {
    @Nonnull
    protected final String _oid;
    protected boolean _hidden;
    protected boolean _debugFlag;
    @Nonnull
    protected String _i18n = "";

    public static final AbstractBlock.Properties baseproperties(@Nullable Material material, @Nullable MaterialColor mapcolor) {
        return BlockSupport.blockproperties(material, mapcolor);
    }

    public BlockBase(@Nonnull String oid, @Nullable AbstractBlock.Properties p, boolean hidden) {
        super(p != null ? p : BlockBase.baseproperties(SharedGlue.Material_rock, null));
        this._oid = Objects.requireNonNull(oid, "Non-null oid required");
        this._hidden = hidden;
    }

    public BlockBase(@Nonnull String oid, @Nullable Material material, @Nullable MaterialColor mapcolor, boolean hidden) {
        this(oid, BlockBase.baseproperties(material, mapcolor), hidden);
    }

    public BlockBase(@Nonnull String oid, @Nullable Material material, boolean hidden) {
        this(oid, material, null, hidden);
    }

    public BlockBase(@Nonnull String oid, @Nullable Material material) {
        this(oid, material, null, false);
    }

    public BlockBase(@Nonnull String oid, @Nonnull Block likeBlock, boolean hidden) {
        this(oid, AbstractBlock.Properties.func_200950_a((AbstractBlock)likeBlock), hidden);
    }

    @Override
    @Nonnull
    public final String oid() {
        return this._oid;
    }

    public final Random getRNG() {
        return this.RANDOM;
    }

    @Override
    public String getTranslationKey(ItemStack stack) {
        if (this._i18n.isEmpty()) {
            this._i18n = ItemSupport.defaultTranslationKey(this);
        }
        return this._i18n;
    }

    public final String func_149739_a() {
        return this.getTranslationKey(ItemStack.field_190927_a);
    }

    @Override
    public BlockItem makeItemBlock(@Nonnull Block thisblock, @Nullable Item.Properties ip) {
        return this instanceof IAirPlaceable ? new AirGrabbingItemBlock(thisblock, ip) : new ItemBlockBase(thisblock, ip);
    }

    @Override
    public boolean isHiddenByDefault() {
        return this._hidden;
    }

    @Override
    public void setHiddenByDefault(boolean flag) {
        this._hidden = flag;
    }

    public void func_149666_a(ItemGroup tab, NonNullList<ItemStack> list) {
        if (!this.isHiddenByDefault() || tab == SharedGlue.CreativeTabs_search) {
            list.add((Object)this.createInstance(this.func_176223_P()));
        }
    }

    public static final boolean canCheckNeighborsLight(World world, BlockPos center) {
        return world.isAreaLoaded(center, 3);
    }

    protected static final boolean isRealPlayerHarvesting(@Nonnull LootContext lootcontext) {
        return SharedGlue.isaRealPlayer((Entity)lootcontext.func_216031_c(LootParameters.field_216281_a));
    }

    protected void checkHarvestAdvancements(World world, PlayerEntity player, BlockPos pos, BlockState state, ItemStack with) {
    }

    public void func_180657_a(World world, PlayerEntity harvester, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack with) {
        if (SharedGlue.isaRealPlayer((Entity)harvester)) {
            this.checkHarvestAdvancements(world, harvester, pos, state, with);
        }
        super.func_180657_a(world, harvester, pos, state, te, with);
    }

    protected void checkPlacementAdvancements(World world, PlayerEntity placer, BlockPos pos, BlockState state, ItemStack held) {
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack held) {
        if (SharedGlue.isaRealPlayer((Entity)placer)) {
            this.checkPlacementAdvancements(world, SharedGlue.getPlayerOrNull((Entity)placer), pos, state, held);
        }
        super.func_180633_a(world, pos, state, placer, held);
    }
}

