/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.impl.ItemSupport;

public final class BlocksetPiece {
    public String id;
    @Nullable
    public String material;
    public String blockset;
    @Nullable
    public String blueprint;

    public BlocksetPiece() {
    }

    public BlocksetPiece(String iid, String imaterial, String iblockset) {
        Validate.notBlank((CharSequence)iid, (String)"A non-blank primary piece id like 'fence' or 'slab' is required", (Object[])new Object[0]);
        this.set(iid, imaterial, iblockset, null);
    }

    public final void set(String iid, String imaterial, String iblockset, String iblueprint) {
        this.id = iid;
        this.material = imaterial;
        this.blockset = iblockset;
        this.blueprint = iblueprint;
    }

    public final void set(String iid, String iblockset) {
        this.set(iid, "generic", iblockset, null);
    }

    public final String getTranslationKey(Block block) {
        Validate.validState((this.id != null ? 1 : 0) != 0);
        return ItemSupport.derivativeTranslationKey(block, this.material, this.id);
    }

    public final ITextComponent getDisplayString(ItemStack blockitem) {
        Validate.validState((this.blockset != null ? 1 : 0) != 0);
        Block block = Block.func_149634_a((Item)blockitem.func_77973_b());
        TranslationTextComponent out = this.blueprint == null ? new TranslationTextComponent(this.getTranslationKey(block), new Object[]{new TranslationTextComponent(this.blockset)}) : new TranslationTextComponent(this.getTranslationKey(block), new Object[]{new TranslationTextComponent(this.blockset), new TranslationTextComponent(this.blockset)});
        return out;
    }
}

