/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.block;

import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FallingBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.IAirPlaceable;
import org.jwaresoftware.mcmods.lib.api.IModBlock;
import org.jwaresoftware.mcmods.lib.impl.ItemSupport;
import org.jwaresoftware.mcmods.lib.impl.block.AirGrabbingItemBlock;
import org.jwaresoftware.mcmods.lib.impl.block.ItemBlockBase;

public class FallingBlockBase
extends FallingBlock
implements IModBlock {
    @Nonnull
    protected final String _oid;
    protected boolean _hidden;
    @Nonnull
    protected String _i18n = "";
    protected int _dustColor = -8356741;

    public FallingBlockBase(@Nonnull String oid, @Nullable AbstractBlock.Properties p, boolean hidden) {
        super(p != null ? p : AbstractBlock.Properties.func_200949_a((Material)SharedGlue.Material_sand, (MaterialColor)SharedGlue.Material_rock.func_151565_r()).func_200947_a(SharedGlue.Block_soundType_Gravel));
        this._oid = Objects.requireNonNull(oid, "Non-null oid required");
        this._hidden = hidden;
    }

    public FallingBlockBase(@Nonnull String oid, @Nonnull Block likeBlock, boolean hidden) {
        this(oid, AbstractBlock.Properties.func_200950_a((AbstractBlock)likeBlock), hidden);
    }

    @Override
    @Nonnull
    public final String oid() {
        return this._oid;
    }

    public final Random getRNG() {
        return this.RANDOM;
    }

    @Override
    public String getTranslationKey(ItemStack stack) {
        if (this._i18n.isEmpty()) {
            this._i18n = ItemSupport.defaultTranslationKey((Block)this);
        }
        return this._i18n;
    }

    public final String func_149739_a() {
        return this.getTranslationKey(ItemStack.field_190927_a);
    }

    @Override
    public BlockItem makeItemBlock(@Nonnull Block thisblock, @Nullable Item.Properties ip) {
        return this instanceof IAirPlaceable ? new AirGrabbingItemBlock(thisblock, ip) : new ItemBlockBase(thisblock, ip);
    }

    @Override
    public boolean isHiddenByDefault() {
        return this._hidden;
    }

    @Override
    public void setHiddenByDefault(boolean flag) {
        this._hidden = flag;
    }

    public void func_149666_a(ItemGroup tab, NonNullList<ItemStack> list) {
        if (!this.isHiddenByDefault() || tab == ItemGroup.field_78027_g) {
            super.func_149666_a(tab, list);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_189876_x(BlockState state, IBlockReader reader, BlockPos pos) {
        return this._dustColor;
    }

    protected final void baseCheckIsFallable(World world, BlockPos pos) {
        BlockPos below_pos;
        if (SharedGlue.isaServerWorld((IWorldReader)world) && (world.func_175623_d(below_pos = pos.func_177977_b()) || pos.func_177956_o() >= 0 && FallingBlockBase.func_185759_i((BlockState)world.func_180495_p(below_pos)))) {
            FallingBlockEntity falling = new FallingBlockEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, world.func_180495_p(pos));
            this.func_149829_a(falling);
            world.func_217376_c((Entity)falling);
        }
    }
}

