/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.client;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.Strings;
import org.jwaresoftware.mcmods.lib.Tooltips;
import org.jwaresoftware.mcmods.lib.api.ICraftedStorage;

@OnlyIn(value=Dist.CLIENT)
public class CraftedStorageTooltip {
    static final TextFormatting _BLUE = TextFormatting.BLUE;
    static final TextFormatting _GRAY = TextFormatting.GRAY;

    public void onItemTooltip(ItemTooltipEvent event) {
        ITextComponent tooltip;
        Block block;
        ICraftedStorage spi = null;
        ItemStack stack = event.getItemStack();
        Item item = stack.func_77973_b();
        if (item instanceof ICraftedStorage) {
            spi = (ICraftedStorage)item;
        } else if (item instanceof BlockItem && (block = ((BlockItem)item).func_179223_d()) instanceof ICraftedStorage) {
            spi = (ICraftedStorage)block;
        }
        if (spi != null && (tooltip = this.storedTip(stack, spi, event.getPlayer(), true, spi.storedType())) != null) {
            this.addTip(event, tooltip);
        }
    }

    @Nullable
    public ITextComponent storedTip(ItemStack stack, ICraftedStorage from, @Nullable PlayerEntity player, boolean onlyIfPresent, ICraftedStorage.Type type) {
        int n = from.quantityStored(stack, player);
        if (n < 0) {
            return null;
        }
        if (n == 0 && onlyIfPresent) {
            return null;
        }
        if (type == null) {
            type = ICraftedStorage.Type.GENERAL;
        }
        IFormattableTextComponent displayString = new StringTextComponent(_BLUE.toString()).func_230529_a_((ITextComponent)new TranslationTextComponent(Strings.tooltipKey("storage.label"))).func_230529_a_((ITextComponent)new StringTextComponent(_GRAY.toString())).func_230529_a_((ITextComponent)new TranslationTextComponent(type.getTranslateKey(), new Object[]{n}));
        if (ItemStacks.getSize(stack) > 1) {
            displayString.func_230529_a_((ITextComponent)new TranslationTextComponent("tooltip.itemsuffix.total"));
        }
        return displayString;
    }

    private void addTip(ItemTooltipEvent event, ITextComponent tip) {
        List tips = event.getToolTip();
        if (tips.size() > 1) {
            tips.add(Tooltips.NL());
        }
        tips.add(tip);
    }
}

