/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.fluid;

import java.util.function.BiFunction;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;

public class ContainerFluidAttributes
extends FluidAttributes {
    private final int _flatColor;
    private final boolean _biomeTint;

    public ContainerFluidAttributes(FluidAttributes.Builder b, Fluid f) {
        super(b, f);
        this._flatColor = ((Builder)b).flatColor();
        this._biomeTint = ((Builder)b).biomeTinted();
    }

    public int getFlatColor(FluidStack fluid) {
        return this._flatColor;
    }

    public int getColor(IBlockDisplayReader worldr, BlockPos at) {
        return this._biomeTint ? BiomeColors.func_228363_c_((IBlockDisplayReader)worldr, (BlockPos)at) | 0xFF000000 : super.getColor(worldr, at);
    }

    public static Builder builder(ResourceLocation stillTexture, ResourceLocation flowingTexture) {
        return new Builder(stillTexture, flowingTexture, ContainerFluidAttributes::new);
    }

    public static class Builder
    extends FluidAttributes.Builder {
        protected boolean _biomeTint = false;
        protected int _flatColor = -1;

        public Builder(ResourceLocation stillTexture, ResourceLocation flowingTexture, BiFunction<FluidAttributes.Builder, Fluid, FluidAttributes> ctor) {
            super(stillTexture, flowingTexture, ctor);
            this.sound(SoundEvents.field_187630_M, SoundEvents.field_187624_K);
        }

        public final Builder flatColor(int color) {
            this._flatColor = color;
            return this;
        }

        public final int flatColor() {
            return this._flatColor;
        }

        public final Builder biomeTint() {
            this._biomeTint = true;
            return this;
        }

        public final boolean biomeTinted() {
            return this._biomeTint;
        }
    }
}

