/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.fluid;

import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.jwaresoftware.mcmods.lib.BlockXyz;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.SharedGlue;

@ParametersAreNonnullByDefault
public class FlowingFluidEffectBlock
extends FlowingFluidBlock {
    private BlockXyz.BiConsumer<Entity> _entity_collision = (xyz, e) -> {};

    public FlowingFluidEffectBlock(Supplier<? extends FlowingFluid> fluid_supplier, AbstractBlock.Properties bp, BlockXyz.BiConsumer<Entity> collision) {
        super(fluid_supplier, bp);
        this._entity_collision = Objects.requireNonNull(collision);
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        super.func_196262_a(state, world, pos, entity);
        this._entity_collision.accept((Entity)new BlockXyz((IWorldReader)world, state, pos), entity);
    }

    public static boolean addPotionEffect(LivingEntity entity, Effect effect, int secs, boolean hide) {
        boolean applied = false;
        EffectInstance ieffect = entity.func_70660_b(effect);
        int duration = SharedGlue.ticksFromSeconds(secs);
        if (ieffect == null) {
            Potions.addPotionEffect(entity, effect, secs, 0, false, !hide);
            applied = true;
        } else if (ieffect.func_76459_b() < Math.round((float)duration * 0.6f)) {
            Potions.addPotionEffect(entity, effect, secs, 0, false, !hide);
            applied = true;
        }
        if (applied && effect == SharedGlue.Potion_blindness) {
            Potions.addPotionEffect(entity, SharedGlue.Potion_nausea, secs, 0, false, !hide);
        }
        return applied;
    }

    public static boolean addPotionEffect(LivingEntity entity, Effect effect, int secs) {
        return FlowingFluidEffectBlock.addPotionEffect(entity, effect, secs, true);
    }

    public static boolean slowMovementEffect(Entity entity) {
        boolean applied = false;
        double dv = Math.abs(entity.func_213322_ci().field_72448_b);
        if (dv < 0.1 && !SharedGlue.isEntitySneaking(entity)) {
            double dh = 0.4 + dv * 0.2;
            entity.func_213317_d(entity.func_213322_ci().func_216372_d(dh, 1.0, dh));
            applied = true;
        }
        return applied;
    }
}

