/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.fluid;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.thirdparty.silentchaos512.utils.Color;
import org.apache.commons.lang3.StringUtils;
import org.jwaresoftware.mcmods.lib.BlockXyz;
import org.jwaresoftware.mcmods.lib.Fluids;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.IBucketful;
import org.jwaresoftware.mcmods.lib.api.IItemPropertyExtender;
import org.jwaresoftware.mcmods.lib.impl.ItemSupport;
import org.jwaresoftware.mcmods.lib.impl.fluid.BreakPredicate;
import org.jwaresoftware.mcmods.lib.impl.fluid.BucketProperties;
import org.jwaresoftware.mcmods.lib.impl.fluid.ContainerFluidAttributes;
import org.jwaresoftware.mcmods.lib.impl.fluid.UniversalBucketFluidHandler;
import org.jwaresoftware.mcmods.lib.impl.fluid.UniversalFluids;
import org.jwaresoftware.mcmods.lib.impl.fluid.UniversalHolderOfFluids;
import org.jwaresoftware.mcmods.lib.integration.FluidsHelper;

public class UniversalBucketItem
extends UniversalHolderOfFluids
implements IBucketful,
IItemPropertyExtender {
    static final ConcurrentHashMap<String, Integer> _FLUID_FLATCOLOR_MAP = new ConcurrentHashMap(23, 0.85f);
    protected final int _capacity_mB;
    protected final int _capacity_buckets;
    @Nonnull
    protected final Predicate<FluidStack> _allowFluid;
    protected final BreakPredicate _breakTest;
    private Supplier<Item> _fliptBucket;
    private Supplier<ItemStack> _emptyBucket;
    private final boolean _setWLMProperty;

    protected static final int bucketfuls(FluidStack f) {
        return f.isEmpty() ? 0 : f.getAmount() / 1000;
    }

    public UniversalBucketItem(String oid, boolean hidden, @Nonnull BucketProperties bp) {
        super(oid, hidden, bp);
        this._capacity_buckets = bp._capacity_buckets;
        this._capacity_mB = 1000 * this._capacity_buckets;
        this._allowFluid = Objects.requireNonNull(bp._allowFluid);
        this._fliptBucket = Objects.requireNonNull(bp._fliptBucket);
        this._emptyBucket = Objects.requireNonNull(bp._emptyBucket);
        this._breakTest = bp.getBreakTest();
        this._setWLMProperty = bp.wantWLMProperty();
    }

    @Nonnull
    public static final Fluid getFluidHeld(ItemStack stack) {
        UniversalBucketItem ub;
        Fluid f = Fluids.NO_FLUID;
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof UniversalBucketItem && !(ub = (UniversalBucketItem)stack.func_77973_b()).isEmpty()) {
            f = ub.getFluid(stack).getFluid();
        }
        return f;
    }

    @Override
    @Nonnull
    public FluidStack getFluid(@Nonnull ItemStack bucket) {
        return ItemStacks.isEmpty(bucket) ? FluidStack.EMPTY : Fluids.getBucketFluid(bucket);
    }

    @Override
    public final int getCapacity() {
        return this._capacity_mB;
    }

    public final int getBucketCapacity() {
        return this._capacity_buckets;
    }

    @Override
    public boolean isMultiuse() {
        return this.getBucketCapacity() > 1;
    }

    @Nonnull
    public ItemStack getEmptyContainer() {
        return this._emptyBucket.get();
    }

    public final boolean isEmpty() {
        return this.getEmptyContainer().func_190926_b();
    }

    public final boolean isFull(ItemStack bucket) {
        return this.getFluid(bucket).getAmount() == this.getCapacity();
    }

    public boolean hasContainerItem(ItemStack bucket) {
        return !this.isEmpty();
    }

    @Nonnull
    public ItemStack getContainerItem(ItemStack bucket) {
        return !this.isEmpty() ? ItemStacks.copy1(this.getEmptyContainer()) : super.getContainerItem(bucket);
    }

    protected ItemStack getBrokenContainer() {
        return ItemStack.field_190927_a;
    }

    public static int getColorFrom(@Nullable ModIntegration mod, FluidStack f) {
        int color_num = 0xFFFFFF;
        if (!f.isEmpty()) {
            Fluid fluid = f.getFluid();
            FluidAttributes a = fluid.getAttributes();
            color_num = a.getColor(f);
            if (a instanceof ContainerFluidAttributes) {
                color_num = ((ContainerFluidAttributes)a).getFlatColor(f);
            } else {
                String full_name = Fluids.registryName(fluid);
                String simple_name = Fluids.name(fluid);
                if (_FLUID_FLATCOLOR_MAP.containsKey(full_name)) {
                    color_num = _FLUID_FLATCOLOR_MAP.get(full_name);
                } else if (_FLUID_FLATCOLOR_MAP.containsKey(simple_name)) {
                    color_num = _FLUID_FLATCOLOR_MAP.get(simple_name);
                } else if (FluidsHelper.isExtensionPresent(mod)) {
                    color_num = FluidsHelper.getColorFrom(mod, f);
                }
            }
        }
        return color_num;
    }

    @Override
    public int getColorFrom(ItemStack bucket, int tintIndex) {
        return tintIndex == 1 && this.useFluidColor() ? UniversalBucketItem.getColorFrom(ModIntegration.get(bucket), this.getFluid(bucket)) : 0xFFFFFF;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack bucket, CompoundNBT nbt) {
        return new UniversalBucketFluidHandler(bucket, this._fliptBucket.get(), this.getBucketCapacity(), b -> this.isEmpty(), this._allowFluid);
    }

    @Nullable
    public static final IFluidHandlerItem getFluidHandler(ItemStack bucket) {
        if (CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY == null || bucket.func_190926_b()) {
            return null;
        }
        return (IFluidHandlerItem)bucket.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null).orElse(null);
    }

    @Nullable
    public static final IFluidHandler getFluidHandler(@Nullable LivingEntity livingTank) {
        if (livingTank == null || CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY == null) {
            return null;
        }
        return (IFluidHandler)livingTank.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null).orElse(null);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack held = player.func_184586_b(hand);
        FluidStack contents = this.getFluid(held);
        BlockRayTraceResult rtr = UniversalBucketItem.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)(this.isEmpty() ? RayTraceContext.FluidMode.SOURCE_ONLY : RayTraceContext.FluidMode.NONE));
        ActionResult override = ForgeEventFactory.onBucketUse((PlayerEntity)player, (World)world, (ItemStack)held, (RayTraceResult)rtr);
        if (override != null) {
            return override;
        }
        if (contents.isEmpty()) {
            return new ActionResult(ActionResultType.PASS, (Object)held);
        }
        if (rtr == null || rtr.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return new ActionResult(ActionResultType.PASS, (Object)held);
        }
        BlockRayTraceResult target = rtr;
        BlockPos hitpos = target.func_216350_a();
        if (world.func_175660_a(player, hitpos)) {
            BlockPos fluidpos = hitpos.func_177972_a(target.func_216354_b());
            if (player.func_175151_a(hitpos, target.func_216354_b(), held)) {
                ItemStack original_held = ItemStacks.copy(held);
                FluidActionResult result = this.tryPlaceFluid(player, world, hand, hitpos, fluidpos, held, contents);
                if (result.isSuccess()) {
                    ItemSupport.noteFluidPlacedAt(player, fluidpos, held);
                    this.addUsedStat(player);
                    if (SharedGlue.getPlayerInSurvival(player)) {
                        ItemStack leftoverBucket;
                        held.func_190918_g(1);
                        ItemStack drained = result.getResult();
                        ItemStack itemStack = leftoverBucket = !drained.func_190926_b() ? drained.func_77946_l() : ItemStacks.copy(this.getEmptyContainer());
                        if (this._breakTest.test(player, original_held, leftoverBucket)) {
                            ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)player, (ItemStack)leftoverBucket, (Hand)hand);
                            leftoverBucket = ItemStacks.copy(this.getBrokenContainer());
                        }
                        if (held.func_190926_b()) {
                            return new ActionResult(SharedGlue.isaClientWorld((IWorldReader)world) ? ActionResultType.SUCCESS : ActionResultType.CONSUME, (Object)leftoverBucket);
                        }
                        SharedGlue.giveStrictItemToPlayer(player, leftoverBucket);
                    }
                    return new ActionResult(SharedGlue.isaClientWorld((IWorldReader)world) ? ActionResultType.SUCCESS : ActionResultType.CONSUME, (Object)held);
                }
            }
        }
        return new ActionResult(ActionResultType.FAIL, (Object)held);
    }

    @Nonnull
    public final FluidActionResult tryPlaceFluid(@Nullable PlayerEntity player, World world, Hand hand, BlockPos hitpos, BlockPos fluidpos, ItemStack held, FluidStack contents) {
        BlockState hit;
        if (contents.getFluid() == Fluids.water() && (hit = world.func_180495_p(hitpos)).func_177230_c() instanceof ILiquidContainer && ((ILiquidContainer)hit.func_177230_c()).func_204510_a((IBlockReader)world, hitpos, hit, contents.getFluid()) && !world.func_230315_m_().func_236040_e_() && ((ILiquidContainer)hit.func_177230_c()).func_204509_a((IWorld)world, hitpos, hit, Fluids.water().func_207204_a(false))) {
            FluidActionResult result = FluidActionResult.FAILURE;
            IFluidHandlerItem fh = UniversalBucketItem.getFluidHandler(ItemStacks.copy1(held));
            if (fh.drain(Fluids.bucketOf((Fluid)Fluids.water()), IFluidHandler.FluidAction.EXECUTE).getAmount() == 1000) {
                player.func_184185_a(SoundEvents.field_187624_K, 1.0f, 1.0f);
                result = new FluidActionResult(fh.getContainer());
            }
            return result;
        }
        FluidActionResult result = FluidUtil.tryPlaceFluid((PlayerEntity)player, (World)world, (Hand)hand, (BlockPos)fluidpos, (ItemStack)held, (FluidStack)contents);
        if (result.isSuccess() && contents.getFluid() == Fluids.lava()) {
            player.func_184185_a(SoundEvents.field_187627_L, 1.0f, 1.0f);
        }
        return result;
    }

    @Nonnull
    protected final FluidActionResult tryPickupFluid(@Nonnull ItemStack bucket, @Nullable PlayerEntity player, World world, BlockPos pos, Direction side) {
        if (!ItemStacks.isEmpty(bucket) && world != null && pos != null) {
            IFluidHandler fspi;
            BlockState blockstate = world.func_180495_p(pos);
            Block hit_block = blockstate.func_177230_c();
            if (hit_block instanceof IBucketPickupHandler) {
                Fluid scooped_fluid;
                IFluidHandlerItem fspi2;
                FlowingFluid have_fluid = null;
                if (hit_block instanceof FlowingFluidBlock) {
                    FlowingFluidBlock fluid_block = (FlowingFluidBlock)hit_block;
                    if (fluid_block.func_204507_t(blockstate).func_206889_d()) {
                        have_fluid = fluid_block.getFluid();
                    }
                } else if (hit_block instanceof IWaterLoggable) {
                    if (((Boolean)blockstate.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
                        have_fluid = Fluids.water();
                    }
                } else if (hit_block == Blocks.field_203203_C) {
                    have_fluid = Fluids.water();
                }
                if (have_fluid != null && (fspi2 = UniversalBucketItem.getFluidHandler(ItemStacks.copy1(bucket))).fill(Fluids.bucketOf((Fluid)have_fluid), IFluidHandler.FluidAction.SIMULATE) == 1000 && fspi2.fill(Fluids.bucketOf(scooped_fluid = ((IBucketPickupHandler)hit_block).func_204508_a((IWorld)world, pos, blockstate)), IFluidHandler.FluidAction.EXECUTE) == 1000) {
                    this.addUsedStat(player);
                    SoundEvent sound = scooped_fluid.getAttributes().getFillSound(Fluids.bucketOf(scooped_fluid));
                    if (sound == null) {
                        sound = RID.isIn(scooped_fluid, "lava") ? SoundEvents.field_187633_N : SoundEvents.field_187630_M;
                    }
                    player.func_184185_a(sound, 1.0f, 1.0f);
                    return new FluidActionResult(fspi2.getContainer());
                }
            } else if (!this.isFull(bucket) && (fspi = (IFluidHandler)FluidUtil.getFluidHandler((World)world, (BlockPos)pos, (Direction)side).orElse(null)) != null) {
                return FluidUtil.tryFillContainer((ItemStack)bucket, (IFluidHandler)fspi, (int)Integer.MAX_VALUE, (PlayerEntity)player, (boolean)true);
            }
        }
        return FluidActionResult.FAILURE;
    }

    public static final Fluid trySpongingFluid(@Nonnull BlockXyz xyz) {
        Block hit_block;
        if (xyz.worldworld().isPresent() && xyz.state != null && xyz.pos != null && (hit_block = xyz.state.func_177230_c()) instanceof IBucketPickupHandler) {
            FlowingFluid have_fluid = null;
            if (hit_block instanceof FlowingFluidBlock) {
                FlowingFluidBlock fluid_block = (FlowingFluidBlock)hit_block;
                if (fluid_block.func_204507_t(xyz.state).func_206889_d()) {
                    have_fluid = fluid_block.getFluid();
                }
            } else if (hit_block instanceof IWaterLoggable) {
                if (((Boolean)xyz.state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
                    have_fluid = Fluids.water();
                }
            } else if (hit_block == Blocks.field_203203_C) {
                have_fluid = Fluids.water();
            }
            if (have_fluid != null) {
                return ((IBucketPickupHandler)hit_block).func_204508_a((IWorld)((World)xyz.worldr), xyz.pos, xyz.state);
            }
        }
        return Fluids.NO_FLUID;
    }

    public static final void addFluidFlatColorMapping(String tag, int ARGB) {
        if (!StringUtils.isBlank((CharSequence)tag)) {
            _FLUID_FLATCOLOR_MAP.putIfAbsent(tag, ARGB);
        }
    }

    public float getFluidPropertyValue(@Nonnull Fluid contained) {
        return 0.0f;
    }

    protected boolean addFluidToDisplayStrings(boolean tip) {
        return true;
    }

    public ITextComponent func_200295_i(ItemStack bucket) {
        FluidStack f;
        ITextComponent display = super.func_200295_i(bucket);
        if (this.addFluidToDisplayStrings(false) && (f = Fluids.sameOrNull(this.getFluid(bucket))) != null) {
            display = new TranslationTextComponent(this.isMultiuse() ? "item.carrots.bucket_with_n" : "item.carrots.bucket_with_1", new Object[]{display, f.getDisplayName(), UniversalBucketItem.bucketfuls(f)});
        }
        return display;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerPropertyOverrides() {
        if (this._setWLMProperty) {
            ItemModelsProperties.func_239418_a_((Item)this, (ResourceLocation)new ResourceLocation("carrots:fluid_id"), (IItemPropertyGetter)new IItemPropertyGetter(){

                public float call(ItemStack bucket, ClientWorld world, LivingEntity unused) {
                    Fluid f = UniversalBucketItem.getFluidHeld(bucket);
                    return f == Fluids.NO_FLUID ? 0.0f : (f == Fluids.experience() ? (float)UniversalFluids.Selector.EXP.value() : (f == Fluids.water() ? (float)UniversalFluids.Selector.WATER.value() : (f == Fluids.lava() ? (float)UniversalFluids.Selector.LAVA.value() : (f == Fluids.milk() ? (float)UniversalFluids.Selector.MILK.value() : (f == Fluids.honey() ? (float)UniversalFluids.Selector.HONEY.value() : (f == Fluids.seedoil() ? (float)UniversalFluids.Selector.SEEDOIL.value() : (f == Fluids.ink() ? (float)UniversalFluids.Selector.INK.value() : MathHelper.func_76131_a((float)((UniversalBucketItem)bucket.func_77973_b()).getFluidPropertyValue(f), (float)0.0f, (float)100.0f))))))));
                }
            });
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack bucket, World world, List<ITextComponent> tooltip, ITooltipFlag flags) {
        FluidStack f;
        if (this.isMultiuse() && this.addFluidToDisplayStrings(true) && (f = Fluids.sameOrNull(this.getFluid(bucket))) != null) {
            int left = this.getBucketCapacity() - UniversalBucketItem.bucketfuls(f);
            tooltip.add((ITextComponent)new TranslationTextComponent("item.carrots.bucket_unused", new Object[]{left, this.getBucketCapacity()}));
        }
        super.func_77624_a(bucket, world, tooltip, flags);
    }

    static {
        _FLUID_FLATCOLOR_MAP.put("water", -12618012);
        _FLUID_FLATCOLOR_MAP.put("flowing_water", -12618012);
        _FLUID_FLATCOLOR_MAP.put("lava", Color.fluidColor(15494656));
        _FLUID_FLATCOLOR_MAP.put("flowing_lava", Color.fluidColor(15494656));
    }
}

