/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.fluid;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jwaresoftware.mcmods.lib.api.IItemPropertyExtender;
import org.jwaresoftware.mcmods.lib.capability.ITemperatureChangeable;
import org.jwaresoftware.mcmods.lib.impl.fluid.DrinkableBucketItem;

public class WarmableBucketItem
extends DrinkableBucketItem
implements ITemperatureChangeable,
IItemPropertyExtender {
    private final int _temp_modifier;

    public WarmableBucketItem(String oid, Supplier<? extends Fluid> supplier, int temp_modifier, Item.Properties builder) {
        super(oid, supplier, builder);
        this._temp_modifier = temp_modifier;
    }

    public WarmableBucketItem(String oid, Supplier<? extends Fluid> supplier, Item.Properties builder) {
        this(oid, supplier, 2, builder);
    }

    @Override
    public ITemperatureChangeable.Category getTemperatureDelivery() {
        return this.isDrinkableFluid() ? ITemperatureChangeable.Category.CONSUMED : ITemperatureChangeable.Category.CARRIED;
    }

    @Override
    public int getTemperatureModifier(ItemStack bucket) {
        return this._temp_modifier;
    }

    @Override
    public boolean canPlayerHeat(ItemStack stack) {
        return true;
    }

    @Override
    public void onCookedOrCrafted(ItemStack bucket) {
        ITemperatureChangeable.UsedEffect e = this.onCreateCheckBonusTemperature(bucket);
        super.onCookedOrCrafted(bucket);
        if (ITemperatureChangeable.UsedEffect.HEATED.equals((Object)e)) {
            this.setHeated(bucket);
        }
    }

    public int getItemStackLimit(ItemStack bucket) {
        return this.hasBonusTemperature(bucket) ? 1 : super.getItemStackLimit(bucket);
    }

    public void func_77663_a(ItemStack bucket, World world, Entity holder, int slotindex, boolean selected) {
        this.onUpdateTickBonusTemperature(bucket, world, holder, slotindex, selected);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerPropertyOverrides() {
        ITemperatureChangeable.TemperaturePropertyGetter.forHeatable((Item)this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack bucket, World world, List<ITextComponent> tooltip, ITooltipFlag flags) {
        this.addBonusTemperatureInformation(bucket, world, tooltip);
        super.func_77624_a(bucket, world, tooltip, flags);
    }
}

