/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.item;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.ITag;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.items.IItemHandler;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LibConfig;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.api.IDrinkableFluid;
import org.jwaresoftware.mcmods.lib.api.INutritionSource;
import org.jwaresoftware.mcmods.lib.api.NutritionNote;

public final class NutritionProfile {
    public static final ITag.INamedTag<Item> FOOD_RELATED = RID.Tags.forItems(LibInfo.rstring("nutrition/food_related"));
    static final Map<Item, Long> _NN_minecraft = new ConcurrentHashMap<Item, Long>(111);

    public static final boolean isTaggable(ItemStack stack) {
        try {
            return !ItemStacks.isEmpty(stack) && (stack.func_222117_E() || stack.func_77973_b().func_206844_a(FOOD_RELATED));
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
    }

    public static final void initFinalize() {
        _NN_minecraft.put(Items.field_151117_aB, NutritionNote.valueOf(NutritionNote.DAIRY, NutritionNote.FATS, NutritionNote.PROTEIN));
        _NN_minecraft.put(Items.field_151172_bF, NutritionNote.valueOf(NutritionNote.VEGGIES, new NutritionNote[0]));
        _NN_minecraft.put(Items.field_151174_bG, NutritionNote.valueOf(NutritionNote.CARBS, new NutritionNote[0]));
        _NN_minecraft.put(Items.field_151168_bH, NutritionNote.valueOf(NutritionNote.CARBS, new NutritionNote[0]));
        _NN_minecraft.put(Items.field_221692_bh, NutritionNote.valueOf(NutritionNote.VEGGIES, new NutritionNote[0]));
        _NN_minecraft.put(Items.field_234723_bx_, NutritionNote.valueOf(NutritionNote.VEGGIES, new NutritionNote[0]));
        _NN_minecraft.put(Items.field_221694_bi, NutritionNote.valueOf(NutritionNote.VEGGIES, NutritionNote.UNSAFE));
        _NN_minecraft.put(Items.field_234722_bw_, NutritionNote.valueOf(NutritionNote.VEGGIES, NutritionNote.UNSAFE));
        _NN_minecraft.put(Items.field_151009_A, NutritionNote.valueOf(NutritionNote.VEGGIES, new NutritionNote[0]));
        _NN_minecraft.put(Items.field_151034_e, NutritionNote.valueOf(NutritionNote.FRUITS, new NutritionNote[0]));
        _NN_minecraft.put(Items.field_151127_ba, NutritionNote.valueOf(NutritionNote.FRUITS, new NutritionNote[0]));
        _NN_minecraft.put(Items.field_185161_cS, NutritionNote.valueOf(NutritionNote.FRUITS, new NutritionNote[0]));
        _NN_minecraft.put(Items.field_222112_pR, NutritionNote.valueOf(NutritionNote.FRUITS, new NutritionNote[0]));
        _NN_minecraft.put(Items.field_222115_pz, NutritionNote.valueOf(NutritionNote.VEGGIES, new NutritionNote[0]));
        _NN_minecraft.put(Items.field_179560_bq, NutritionNote.valueOf(NutritionNote.CARBS, NutritionNote.MEAT, NutritionNote.PROTEIN, NutritionNote.VEGGIES));
        _NN_minecraft.put(Items.field_151158_bO, NutritionNote.valueOf(NutritionNote.CARBS, NutritionNote.DAIRY, NutritionNote.FATS, NutritionNote.GLUTEN, NutritionNote.HI_SUGAR, NutritionNote.SWEETS, NutritionNote.VEGGIES));
        _NN_minecraft.put(Items.field_151106_aX, NutritionNote.valueOf(NutritionNote.CARBS, NutritionNote.GLUTEN, NutritionNote.HI_SUGAR, NutritionNote.SWEETS));
        _NN_minecraft.put(Items.field_151025_P, NutritionNote.valueOf(NutritionNote.CARBS, NutritionNote.GLUTEN, NutritionNote.WHEAT));
        _NN_minecraft.put(Items.field_151070_bp, NutritionNote.valueOf(NutritionNote.MEAT, NutritionNote.PROTEIN, NutritionNote.UNSAFE));
        _NN_minecraft.put(Items.field_151078_bh, NutritionNote.valueOf(NutritionNote.MEAT, NutritionNote.PROTEIN, NutritionNote.UNSAFE));
        _NN_minecraft.put(Items.field_151082_bd, NutritionNote.valueOf(NutritionNote.MEAT, NutritionNote.PROTEIN));
        _NN_minecraft.put(Items.field_151083_be, NutritionNote.valueOf(NutritionNote.FATS, NutritionNote.MEAT, NutritionNote.PROTEIN));
        _NN_minecraft.put(Items.field_151076_bf, NutritionNote.valueOf(NutritionNote.MEAT, NutritionNote.PROTEIN, NutritionNote.UNSAFE));
        _NN_minecraft.put(Items.field_151077_bg, NutritionNote.valueOf(NutritionNote.FATS, NutritionNote.MEAT, NutritionNote.PROTEIN));
        _NN_minecraft.put(Items.field_179561_bm, NutritionNote.valueOf(NutritionNote.MEAT, NutritionNote.PROTEIN));
        _NN_minecraft.put(Items.field_179557_bn, NutritionNote.valueOf(NutritionNote.FATS, NutritionNote.MEAT, NutritionNote.PROTEIN));
        _NN_minecraft.put(Items.field_151147_al, NutritionNote.valueOf(NutritionNote.MEAT, NutritionNote.PROTEIN, NutritionNote.UNSAFE));
        _NN_minecraft.put(Items.field_151157_am, NutritionNote.valueOf(NutritionNote.FATS, NutritionNote.MEAT, NutritionNote.PROTEIN));
        _NN_minecraft.put(Items.field_179558_bo, NutritionNote.valueOf(NutritionNote.MEAT, NutritionNote.PROTEIN, NutritionNote.UNSAFE));
        _NN_minecraft.put(Items.field_179559_bp, NutritionNote.valueOf(NutritionNote.MEAT, NutritionNote.PROTEIN));
        _NN_minecraft.put(Items.field_196088_aY, NutritionNote.valueOf(NutritionNote.FISH, NutritionNote.PROTEIN, NutritionNote.SEAFOOD));
        _NN_minecraft.put(Items.field_196086_aW, NutritionNote.valueOf(NutritionNote.FISH, NutritionNote.PROTEIN, NutritionNote.SEAFOOD));
        _NN_minecraft.put(Items.field_196102_ba, NutritionNote.valueOf(NutritionNote.FISH, NutritionNote.PROTEIN, NutritionNote.SEAFOOD));
        _NN_minecraft.put(Items.field_196087_aX, NutritionNote.valueOf(NutritionNote.FISH, NutritionNote.PROTEIN, NutritionNote.SEAFOOD));
        _NN_minecraft.put(Items.field_196104_bb, NutritionNote.valueOf(NutritionNote.FATS, NutritionNote.FISH, NutritionNote.PROTEIN, NutritionNote.SEAFOOD));
        _NN_minecraft.put(Items.field_222070_lD, NutritionNote.valueOf(NutritionNote.CARBS, NutritionNote.DAIRY, NutritionNote.GLUTEN, NutritionNote.HI_SUGAR, NutritionNote.SWEETS, NutritionNote.WHEAT));
    }

    public static final long like(Item minecraft_item) {
        return _NN_minecraft.getOrDefault(minecraft_item, 0L);
    }

    public static final long checked(long unchecked) {
        long value = unchecked;
        value = NutritionNote.DAIRY_FREE.checked(value);
        value = NutritionNote.GLUTEN_FREE.checked(value);
        value = NutritionNote.OVO_FREE.checked(value);
        value = NutritionNote.LO_SUGAR.checked(value);
        value = NutritionNote.LO_FAT.checked(value);
        value = NutritionNote.LO_SALT.checked(value);
        value = NutritionNote.LACTOSE_FREE.checked(value);
        value = NutritionNote.MEAT_FREE.checked(value);
        value = NutritionNote.SEAFOOD_FREE.checked(value);
        value = NutritionNote.CAFFEINE_FREE.checked(value);
        value = NutritionNote.VEGAN.checked(value);
        value = NutritionNote.ORGANIC.checked(value);
        value = NutritionNote.ANIMAL_FREE_LITE.checked(value);
        value = NutritionNote.CAUTIOUS.checked(value);
        value = NutritionNote.BLAND.checked(value);
        value = NutritionNote.ALLERGEN_LITE.checked(value);
        value = NutritionNote.ALLERGEN_FREE.checked(value);
        return value;
    }

    public static final long adjust(long i_nn, long exclude, long include) {
        if (i_nn >= 0L) {
            if (exclude > 0L) {
                i_nn &= exclude ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if (include > 0L) {
                i_nn |= include;
            }
        }
        i_nn = NutritionNote.clean(i_nn);
        return NutritionProfile.checked(i_nn);
    }

    public static final long compute(ItemStack output, Set<NutritionNote> set, long exclude, long include) {
        Item item = output.func_77973_b();
        long i_nn = NutritionNote.getFor(output, set, false, true);
        if (i_nn == 0L && item instanceof INutritionSource) {
            i_nn = ((INutritionSource)item).getNNCheckList(output);
        }
        return NutritionProfile.adjust(i_nn, exclude, include);
    }

    public static final long compute(ItemStack output, Set<NutritionNote> set) {
        return NutritionProfile.compute(output, set, 0L, 0L);
    }

    public static final long compute(ItemStack output, IItemHandler inputs, Set<NutritionNote> set, long exclude, long include) {
        long merged_nn = 0L;
        int n = inputs.getSlots();
        for (int i = 0; i < n; ++i) {
            ItemStack ingredient = inputs.getStackInSlot(i);
            if (ingredient.func_190926_b()) continue;
            Item item = ingredient.func_77973_b();
            long i_nn = NutritionNote.getFor(ingredient, set, false, false);
            if (i_nn == 0L && !NutritionNote.present(ingredient)) {
                FluidStack f;
                i_nn = item instanceof INutritionSource ? ((INutritionSource)item).getNNCheckList(ingredient) : (ModIntegration.isUniversalBucket(ingredient) ? ((f = FluidUtil.getFluidContained((ItemStack)ingredient).orElse(FluidStack.EMPTY)).getFluid() instanceof IDrinkableFluid ? ((IDrinkableFluid)f.getFluid()).getNNCheckList(ingredient) : _NN_minecraft.getOrDefault(item, 0L).longValue()) : _NN_minecraft.getOrDefault(item, 0L));
            }
            i_nn = NutritionNote.clean(i_nn);
            merged_nn |= i_nn;
        }
        merged_nn = NutritionProfile.adjust(merged_nn, exclude, include);
        return merged_nn;
    }

    public static final long compute(ItemStack output, IItemHandler inputs, Set<NutritionNote> set) {
        return NutritionProfile.compute(output, inputs, set, 0L, 0L);
    }

    public static final long compute(IItemHandler inputs, long preference) {
        long merged_nn = NutritionNote.clean(preference);
        int n = inputs.getSlots();
        for (int i = 0; i < n; ++i) {
            ItemStack ingredient = inputs.getStackInSlot(i);
            if (ingredient.func_190926_b()) continue;
            Item item = ingredient.func_77973_b();
            long i_nn = 0L;
            i_nn = item instanceof INutritionSource ? ((INutritionSource)item).getNNCheckList(ingredient) : _NN_minecraft.getOrDefault(item, 0L).longValue();
            i_nn = NutritionNote.clean(i_nn);
            merged_nn |= i_nn;
        }
        return NutritionProfile.checked(merged_nn);
    }

    public static final boolean applyIfAbsent(ItemStack output, long nn) {
        boolean touched = false;
        if (LibConfig.includeNutritionNotes() && NutritionProfile.isTaggable(output)) {
            NutritionNote.addTo(output, NutritionProfile.checked(nn |= NutritionNote.getFor(output, NutritionNote.BASE_SET, false, false)));
        }
        return touched;
    }
}

