/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.integration;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.InterModComms;
import org.jwaresoftware.mcmods.lib.Armory;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.Villagers;
import org.jwaresoftware.mcmods.lib.impl.ObjRef;
import org.jwaresoftware.mcmods.lib.impl.StackRef;
import org.jwaresoftware.mcmods.lib.integration.BaublesHelper;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.type.capability.ICurio;

final class CuriosLinkImpl
implements BaublesHelper.SPILink {
    CuriosLinkImpl() {
    }

    @Override
    public void initFinalize() {
        if (ModIntegration.GARDEN_CALYPSO.isLoaded()) {
            InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder(SlotTypePreset.HEAD.getIdentifier()).build());
        }
        if (ModIntegration.PINKLYSHEEP.isLoaded() || ModIntegration.ARMOR_UNDERWEAR.isLoaded()) {
            InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("curio").size(2).build());
        }
        if (ModIntegration.PINKLYSHEEP.isLoaded()) {
            InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder(SlotTypePreset.CHARM.getIdentifier()).build());
            InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder(SlotTypePreset.NECKLACE.getIdentifier()).build());
        }
    }

    @Override
    public final ModIntegration modid() {
        return ModIntegration.CURIOS;
    }

    @Override
    public ItemStack findBauble(@Nonnull Predicate<ItemStack> test, @Nonnull LivingEntity wearer) {
        StackRef out = StackRef.ofempty();
        CuriosApi.getCuriosHelper().findEquippedCurio(test, wearer).ifPresent(t -> out.setValue(t.right));
        return (ItemStack)out.getValue();
    }

    @Override
    public void iterateBaubles(@Nonnull Function<BaublesHelper.OwnedBauble, Void> process, @Nonnull LivingEntity wearer) {
        CuriosApi.getCuriosHelper().getEquippedCurios(wearer).ifPresent(ih -> {
            for (int slotindex = 0; slotindex < ih.getSlots(); ++slotindex) {
                process.apply(new BaublesHelper.OwnedBauble(wearer, ih.getStackInSlot(slotindex)));
            }
        });
    }

    @Override
    public <T> T iterateBaubles(@Nonnull Function<BaublesHelper.OwnedBauble, T> process, @Nonnull LivingEntity wearer, T tkt) {
        ObjRef tkt_H = new ObjRef(tkt);
        CuriosApi.getCuriosHelper().getEquippedCurios(wearer).ifPresent(ih -> {
            for (int slotindex = 0; slotindex < ih.getSlots(); ++slotindex) {
                tkt_H.set(process.apply(new BaublesHelper.OwnedBauble(wearer, ih.getStackInSlot(slotindex), tkt_H.get())));
            }
        });
        return tkt_H.get();
    }

    @Override
    @Nullable
    public ICapabilityProvider wrapNecklaceImpl(@Nonnull ItemStack necklace) {
        return new GenericNecklaceImpl();
    }

    @Override
    @Nullable
    public ICapabilityProvider wrapWearableImpl(@Nonnull ItemStack wearable) {
        return new WearableItemImpl(wearable);
    }

    public static class WearableItemImpl
    implements ICapabilityProvider,
    ICurio {
        private final LazyOptional<ICurio> this_handler = LazyOptional.of(() -> this);
        private final BaublesHelper.WearableBaubleCallback _mod_item;
        private final ItemStack _impl_hack;
        @Nullable
        private Object _model;

        public WearableItemImpl(ItemStack curio) {
            this._mod_item = (BaublesHelper.WearableBaubleCallback)curio.func_77973_b();
            this._impl_hack = curio;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction unused) {
            return CuriosCapability.ITEM.orEmpty(capability, this.this_handler);
        }

        public boolean canRightClickEquip() {
            return true;
        }

        public boolean canEquip(String id, LivingEntity wearer) {
            return SharedGlue.isaPlayer((Entity)wearer);
        }

        public void curioTick(String id, int index, LivingEntity wearer) {
            this._mod_item.doWearableBaubleUpdateTick(id, index, wearer, this._impl_hack);
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean canRender(String id, int index, LivingEntity wearer) {
            return !SlotTypePreset.HEAD.getIdentifier().equals(id) || !Armory.isWearingHeadpiece(wearer);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void render(String id, int index, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, LivingEntity wearer, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            BipedModel<LivingEntity> model = this.getModel();
            if (model == null) {
                return;
            }
            model.func_225597_a_(wearer, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            model.func_212843_a_(wearer, limbSwing, limbSwingAmount, partialTicks);
            ICurio.RenderHelper.followBodyRotations((LivingEntity)wearer, (BipedModel[])new BipedModel[]{model});
            IVertexBuilder vertexBuilder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)renderTypeBuffer, (RenderType)model.func_228282_a_(this._mod_item.getWearableBaubleTexture(ModIntegration.CURIOS)), (boolean)false, (boolean)false);
            model.func_225598_a_(matrixStack, vertexBuilder, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        }

        @OnlyIn(value=Dist.CLIENT)
        protected final BipedModel<LivingEntity> getModel() {
            if (this._model == null) {
                this._model = this._mod_item.doCreateWearableBaubleModel(ModIntegration.CURIOS);
            }
            return (BipedModel)BipedModel.class.cast(this._model);
        }
    }

    public static final class GenericNecklaceImpl
    implements ICapabilityProvider,
    ICurio {
        private final LazyOptional<ICurio> this_handler = LazyOptional.of(() -> this);

        public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction unused) {
            return CuriosCapability.ITEM.orEmpty(capability, this.this_handler);
        }

        public boolean canRightClickEquip() {
            return true;
        }

        public boolean canEquip(String identifier, LivingEntity wearer) {
            return SlotTypePreset.NECKLACE.getIdentifier().equals(identifier) && (SharedGlue.isaPlayer((Entity)wearer) || Villagers.isaFriendly((Entity)wearer, true));
        }
    }

    public static final class GenericAmuletImpl
    implements ICapabilityProvider,
    ICurio {
        private final LazyOptional<ICurio> this_handler = LazyOptional.of(() -> this);
        static final GenericAmuletImpl _INSTANCE = new GenericAmuletImpl();

        public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction unused) {
            return CuriosCapability.ITEM.orEmpty(capability, this.this_handler);
        }

        public boolean canRightClickEquip() {
            return true;
        }
    }
}

