/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.integration;

import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBiomeReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.Locations;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.api.DayNightState;
import org.jwaresoftware.mcmods.lib.api.TimeSensitivity;
import org.jwaresoftware.mcmods.lib.api.WorldSeason;
import org.jwaresoftware.mcmods.lib.integration.SeasonsHelper;

public final class EnvironHelper {
    static SPILink _spiInstance = new SPILink(){};

    public static final void initDefaults() {
        SeasonsHelper.initDefaults();
        LibInfo.LOG.debug("carrots/lib environ helper initialized");
    }

    public static final void initFinalize() {
        _spiInstance.initFinalize();
    }

    public static final boolean isAnyExtensionPresent() {
        return ModIntegration.CARROTS_LIB != _spiInstance.modid() || !SeasonsHelper.isDefault();
    }

    public static final WorldSeason getSeason(IBiomeReader worldr, BlockPos at) {
        return (WorldSeason)((Object)_spiInstance.seasonProvider().apply(worldr, at));
    }

    public static final WorldSeason getSeasonConservatively(IBiomeReader worldr, BlockPos at) {
        return Locations.isBlockLoaded((IBlockReader)worldr, at) ? (WorldSeason)((Object)_spiInstance.seasonProvider().apply(worldr, at)) : WorldSeason.UNKNOWN;
    }

    public static final DayNightState getDayNightState(IWorld worldr, BlockPos at) {
        return (DayNightState)((Object)_spiInstance.daynightOracle().apply(worldr, at));
    }

    public static final DayNightState getDayNightStateConservatively(IWorld worldr, BlockPos at) {
        return Locations.isBlockLoaded((IBlockReader)worldr, at) ? (DayNightState)((Object)_spiInstance.daynightOracle().apply(worldr, at)) : DayNightState.UNKNOWN;
    }

    public static final long getNowTicks(@Nonnull World world, @Nonnull TimeSensitivity relTo) {
        if (relTo == null || relTo == TimeSensitivity.NOW) {
            return world.func_82737_E();
        }
        return world.func_82737_E();
    }

    public static final long getNowTicks(@Nonnull World world) {
        return EnvironHelper.getNowTicks(world, TimeSensitivity.NOW);
    }

    public static final long getFutureTime(@Nonnull World world, long minDelayTicks, @Nonnull TimeSensitivity relTo) {
        return EnvironHelper.getNowTicks(world, relTo) + minDelayTicks;
    }

    public static final long getFutureTime(@Nonnull World world, long minDelayTicks) {
        return EnvironHelper.getNowTicks(world) + minDelayTicks;
    }

    public static final long getCountdownTicksLeft(@Nonnull World world, long soonestTimeTicks) {
        return Math.max(0L, soonestTimeTicks - EnvironHelper.getNowTicks(world));
    }

    public static final boolean isBeforeTime(@Nonnull World world, long soonestTimeTicks) {
        boolean before = false;
        long now = EnvironHelper.getNowTicks(world);
        if (soonestTimeTicks > 0L && now < soonestTimeTicks) {
            before = true;
        }
        return before;
    }

    public static final boolean isAfterOrAtTime(@Nonnull World world, long soonestTimeTicks) {
        boolean after = true;
        long now = EnvironHelper.getNowTicks(world);
        if (now < soonestTimeTicks) {
            after = false;
        }
        return after;
    }

    private EnvironHelper() {
    }

    public static interface SPILink {
        default public ModIntegration modid() {
            return ModIntegration.CARROTS_LIB;
        }

        default public void initFinalize() {
        }

        default public WorldSeason.Provider seasonProvider() {
            return SeasonsHelper.get();
        }

        default public DayNightState.Check daynightOracle() {
            return DayNightState.SIMPLE;
        }
    }
}

