/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.integration;

import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.ClassUtils;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.api.WorldSeason;
import org.jwaresoftware.mcmods.lib.integration.SereneSeasonsLinkImpl;

public final class SeasonsHelper {
    private static final WorldSeason.Provider _noopImpl;
    static WorldSeason.Provider _spiInstance;

    static final void initDefaults() {
        if (ModList.get().isLoaded(ModIntegration.SERENE_SEASONS.modid())) {
            _spiInstance = SereneSeasonsLinkImpl::getSeason;
            LibInfo.LOG.info("Registered SereneSeasons mod as default Season provider");
        }
    }

    @Nonnull
    public static final WorldSeason.Provider get() {
        return _spiInstance;
    }

    static final boolean isDefault() {
        return _spiInstance == _noopImpl;
    }

    public static final WorldSeason.Provider set(WorldSeason.Provider impl) {
        if (impl == null) {
            impl = _noopImpl;
        }
        WorldSeason.Provider prevInstance = _spiInstance;
        _spiInstance = Objects.requireNonNull(impl, "A season provider is required");
        LibInfo.LOG.info("Updated library Season provider to " + ClassUtils.getShortCanonicalName(impl.getClass()));
        return prevInstance;
    }

    static {
        _spiInstance = _noopImpl = WorldSeason.BY_BIOME_PROVIDER;
    }
}

