/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.loot;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.BlockState;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameter;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.loot.CarrotsLootTypes;
import org.jwaresoftware.mcmods.lib.loot.LootConditionBase;

public final class BlockStatePropertyCondition
extends LootConditionBase {
    @Nonnull
    final String _tag;
    @Nonnull
    final StatePropertiesPredicate _impl;

    public BlockStatePropertyCondition(String tag, StatePropertiesPredicate impl) {
        this._tag = tag;
        this._impl = impl;
    }

    public Set<LootParameter<?>> func_215855_a() {
        return ImmutableSet.of((Object)LootParameters.field_216287_g);
    }

    @Override
    protected LootConditionType _getLootConditionType() {
        return CarrotsLootTypes.Conditions.BLOCK_STATE_PROPERTY;
    }

    public boolean test(LootContext context) {
        BlockState state = (BlockState)context.func_216031_c(LootParameters.field_216287_g);
        return state != null && RID.isIn(state, this._tag) && this._impl.func_227181_a_(state);
    }

    public static ILootCondition.IBuilder builder(String tag) {
        Validate.notBlank((CharSequence)tag, (String)"A tag group name is required", (Object[])new Object[0]);
        return () -> new BlockStatePropertyCondition(tag, StatePropertiesPredicate.field_227178_a_);
    }

    public static class Serializer
    implements ILootSerializer<BlockStatePropertyCondition> {
        private static final String _IMPL = "properties";

        public BlockStatePropertyCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            String tag = JSONUtils.func_151200_h((JsonObject)json, (String)"tag");
            if (StringUtils.trimToNull((String)tag) == null) {
                throw new JsonSyntaxException("A tag group name is required");
            }
            StatePropertiesPredicate impl = StatePropertiesPredicate.func_227186_a_((JsonElement)json.get(_IMPL));
            return new BlockStatePropertyCondition(tag, impl);
        }

        public void serialize(JsonObject json, BlockStatePropertyCondition lcond, JsonSerializationContext context) {
            json.addProperty("tag", lcond._tag);
            json.add(_IMPL, lcond._impl.func_227180_a_());
        }
    }

    public static class Builder
    implements ILootCondition.IBuilder {
        private final String _tag;
        private StatePropertiesPredicate _implProperties = StatePropertiesPredicate.field_227178_a_;

        public Builder(String tag) {
            Validate.notBlank((CharSequence)tag, (String)"A tag group name is required", (Object[])new Object[0]);
            this._tag = tag;
        }

        public Builder fromProperties(StatePropertiesPredicate.Builder implBuilder) {
            this._implProperties = implBuilder.func_227196_b_();
            return this;
        }

        public ILootCondition build() {
            return new BlockStatePropertyCondition(this._tag, this._implProperties);
        }
    }
}

