/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.loot;

import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.loot.ApplyClampedBonusFunction;
import org.jwaresoftware.mcmods.lib.loot.BlockStatePropertyCondition;
import org.jwaresoftware.mcmods.lib.loot.EnchantCompatibleWithLevelsFunction;
import org.jwaresoftware.mcmods.lib.loot.EnchantRandomFunction;
import org.jwaresoftware.mcmods.lib.loot.FalseCondition;
import org.jwaresoftware.mcmods.lib.loot.HasAdvancementCondition;
import org.jwaresoftware.mcmods.lib.loot.IfBarteringCondition;
import org.jwaresoftware.mcmods.lib.loot.IfEntityInBiomeCondition;
import org.jwaresoftware.mcmods.lib.loot.IfEntityInBiomeOfTypeCondition;
import org.jwaresoftware.mcmods.lib.loot.IfPresentUseFunction;
import org.jwaresoftware.mcmods.lib.loot.IsSilkTouchToolCondition;
import org.jwaresoftware.mcmods.lib.loot.KilledByRealPlayerCondition;
import org.jwaresoftware.mcmods.lib.loot.Loot;
import org.jwaresoftware.mcmods.lib.loot.RandomChanceWithLuckCondition;
import org.jwaresoftware.mcmods.lib.loot.RandomPickFromSharedDictFunction;
import org.jwaresoftware.mcmods.lib.loot.RandomPickFromVariantSetFunction;
import org.jwaresoftware.mcmods.lib.loot.RandomPotionFunction;
import org.jwaresoftware.mcmods.lib.loot.SetQualityGradeFunction;
import org.jwaresoftware.mcmods.lib.loot.SetUnbreakableFunction;

public final class CarrotsLootTypes {
    static final LootConditionType register_c(String name, ILootSerializer<? extends ILootCondition> serializer) {
        return (LootConditionType)Registry.func_218322_a((Registry)Registry.field_239704_ba_, (ResourceLocation)LibInfo.r(name), (Object)new LootConditionType(serializer));
    }

    static final LootFunctionType register_f(String name, ILootSerializer<? extends ILootFunction> serializer) {
        return (LootFunctionType)Registry.func_218322_a((Registry)Registry.field_239694_aZ_, (ResourceLocation)LibInfo.r(name), (Object)new LootFunctionType(serializer));
    }

    static final void initLoad0() {
        Conditions.initLoad0();
        Functions.initLoad0();
        LibInfo.LOG.debug("carrots/lib loot types registered");
    }

    public static final class Functions {
        public static final LootFunctionType ON_CREATED = CarrotsLootTypes.register_f("on_created", (ILootSerializer<? extends ILootFunction>)new Loot.OnCreatedFunction.BaseSerializer());
        public static final LootFunctionType ON_LOOTED = CarrotsLootTypes.register_f("on_looted", (ILootSerializer<? extends ILootFunction>)new Loot.OnLootedFunction.BaseSerializer());
        public static final LootFunctionType IF_PRESENT = CarrotsLootTypes.register_f("ifpresent", (ILootSerializer<? extends ILootFunction>)new IfPresentUseFunction.Serializer());
        public static final LootFunctionType APPLY_BONUS = CarrotsLootTypes.register_f("apply_bonus", (ILootSerializer<? extends ILootFunction>)new ApplyClampedBonusFunction.Serializer());
        public static final LootFunctionType COMPAT_ENCHANT = CarrotsLootTypes.register_f("compat_enchant", (ILootSerializer<? extends ILootFunction>)new EnchantCompatibleWithLevelsFunction.Serializer());
        public static final LootFunctionType RANDOM_ENCHANT = CarrotsLootTypes.register_f("random_enchant", (ILootSerializer<? extends ILootFunction>)new EnchantRandomFunction.Serializer());
        public static final LootFunctionType RANDOM_PICK = CarrotsLootTypes.register_f("random_pick", (ILootSerializer<? extends ILootFunction>)new RandomPickFromSharedDictFunction.Serializer());
        public static final LootFunctionType RANDOM_VARIANT = CarrotsLootTypes.register_f("random_variant", (ILootSerializer<? extends ILootFunction>)new RandomPickFromVariantSetFunction.Serializer());
        public static final LootFunctionType RANDOM_POTION = CarrotsLootTypes.register_f("random_potion", (ILootSerializer<? extends ILootFunction>)new RandomPotionFunction.Serializer());
        public static final LootFunctionType SET_QGRADE = CarrotsLootTypes.register_f("set_qgrade", (ILootSerializer<? extends ILootFunction>)new SetQualityGradeFunction.Serializer());
        public static final LootFunctionType SET_UNBREAKABLE = CarrotsLootTypes.register_f("set_unbreakable", (ILootSerializer<? extends ILootFunction>)new SetUnbreakableFunction.Serializer());

        private Functions() {
        }

        static final void initLoad0() {
        }
    }

    public static final class Conditions {
        public static final LootConditionType FALSE = CarrotsLootTypes.register_c("false", new FalseCondition.Serializer());
        public static final LootConditionType BLOCK_STATE_PROPERTY = CarrotsLootTypes.register_c("block_state_property", new BlockStatePropertyCondition.Serializer());
        public static final LootConditionType SILK_TOUCH = CarrotsLootTypes.register_c("silk_touch", new IsSilkTouchToolCondition.Serializer());
        public static final LootConditionType KILLED_BY_REAL_PLAYER = CarrotsLootTypes.register_c("killed_by_realplayer", new KilledByRealPlayerCondition.Serializer());
        public static final LootConditionType RANDOM_CHANCE_WITH_LUCK = CarrotsLootTypes.register_c("random_chance_with_luck", new RandomChanceWithLuckCondition.Serializer());
        public static final LootConditionType HAS_ADVANCED = CarrotsLootTypes.register_c("has_advanced", new HasAdvancementCondition.Serializer());
        public static final LootConditionType BARTERING = CarrotsLootTypes.register_c("bartering", new IfBarteringCondition.Serializer());
        public static final LootConditionType IN_BIOME = CarrotsLootTypes.register_c("in_biome", new IfEntityInBiomeCondition.Serializer());
        public static final LootConditionType IN_BIOME_TYPE = CarrotsLootTypes.register_c("in_biome_type", new IfEntityInBiomeOfTypeCondition.Serializer());

        private Conditions() {
        }

        static final void initLoad0() {
        }
    }
}

