/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Objects;
import net.minecraft.advancements.Advancement;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.loot.CarrotsLootTypes;
import org.jwaresoftware.mcmods.lib.loot.LootConditionBase;

public final class HasAdvancementCondition
extends LootConditionBase {
    final ResourceLocation _adv_id;
    final boolean _has_not;

    public HasAdvancementCondition(ResourceLocation advid, boolean inverse) {
        this._adv_id = Objects.requireNonNull(advid);
        this._has_not = inverse;
    }

    @Override
    protected LootConditionType _getLootConditionType() {
        return CarrotsLootTypes.Conditions.HAS_ADVANCED;
    }

    public static final boolean test(ServerPlayerEntity player, ResourceLocation adv_id) {
        Advancement advancement;
        boolean has = false;
        if (player != null && (advancement = player.func_184102_h().func_191949_aK().func_192778_a(adv_id)) != null && player.func_192039_O().func_192747_a(advancement).func_192105_a()) {
            has = true;
        }
        return has;
    }

    public boolean test(LootContext context) {
        ServerPlayerEntity player = SharedGlue.getPlayerMPOrNull((Entity)context.func_216031_c(LootParameters.field_216281_a));
        boolean has = HasAdvancementCondition.test(player, this._adv_id);
        return has == !this._has_not;
    }

    public static ILootCondition.IBuilder builder(String adv_id) {
        return () -> new HasAdvancementCondition(new ResourceLocation(adv_id), false);
    }

    public static class Serializer
    implements ILootSerializer<HasAdvancementCondition> {
        public HasAdvancementCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            String adv_id = JSONUtils.func_151200_h((JsonObject)json, (String)"name");
            return new HasAdvancementCondition(new ResourceLocation(adv_id), JSONUtils.func_151209_a((JsonObject)json, (String)"inverse", (boolean)false));
        }

        public void serialize(JsonObject json, HasAdvancementCondition lcond, JsonSerializationContext context) {
            json.addProperty("name", lcond._adv_id.toString());
            json.addProperty("inverse", Boolean.valueOf(lcond._has_not));
        }
    }
}

