/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.StringUtils;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.advancements.AdvancementPredicate;
import org.jwaresoftware.mcmods.lib.advancements.LootedItemTrigger;
import org.jwaresoftware.mcmods.lib.barter.Bartering;
import org.jwaresoftware.mcmods.lib.capability.QualityGrade;
import org.jwaresoftware.mcmods.lib.loot.CarrotsLootTypes;
import org.jwaresoftware.mcmods.lib.loot.Loot;
import org.jwaresoftware.mcmods.lib.recipes.TagIsPresentCondition;

public final class IfPresentUseFunction
extends LootFunction {
    @Nullable
    public final String _itemid;
    @Nullable
    public final Type _itemtype;
    @Nullable
    public final String _modid;
    @Nullable
    public final ResourceLocation _advanced;
    @Nullable
    final String _tagvalue;
    @Nullable
    final TagIsPresentCondition.TagType _tag;

    public IfPresentUseFunction(ILootCondition[] conditions, @Nullable String detail, @Nullable Type type, @Nullable String modid, @Nullable TagIsPresentCondition.TagType tag, @Nullable String tagvalue, @Nullable ResourceLocation advid) {
        super(conditions);
        this._itemid = detail;
        this._itemtype = type;
        this._modid = StringUtils.trimToNull((String)modid);
        this._advanced = advid;
        this._tag = tag;
        this._tagvalue = StringUtils.trimToNull((String)tagvalue);
    }

    public LootFunctionType func_230425_b_() {
        return CarrotsLootTypes.Functions.IF_PRESENT;
    }

    public ItemStack func_215859_a(ItemStack in, LootContext context) {
        ItemStack out = in;
        if (this._itemid != null) {
            if (this._modid != null && !ModIntegration.isPresent(this._modid)) {
                return in;
            }
            if (this._tagvalue != null && this._tag != null && !this._tag.test(this._tagvalue)) {
                return in;
            }
            if (this._advanced != null && !AdvancementPredicate.isDone(this._advanced, Loot.playerFrom(context))) {
                return in;
            }
            if (this._itemtype == Type.LOOT_TABLE) {
                out = this.fromOptionalLootTable(in, context);
            } else if (this._itemtype == Type.BARTER_TOKEN) {
                out = this.fromBarterTokenSource(in, context);
            } else {
                ItemStack preference;
                ResourceLocation r;
                String rstring = this._itemid;
                int i = this._itemid.lastIndexOf(35);
                if (i > 0) {
                    rstring = rstring.substring(0, i);
                }
                if ((r = ResourceLocation.func_208304_a((String)rstring)) != null && ModIntegration.isPresent(r.func_110624_b()) && !(preference = ModIntegration.itemstack(r.func_110624_b(), r.func_110623_a())).func_190926_b()) {
                    if (!preference.func_82837_s()) {
                        ItemStacks.copyDisplayName(in, preference);
                    }
                    out = Loot.resized(preference, in.func_190916_E());
                    if (this._itemtype == Type.REWARD) {
                        this.giveLootedAdvancement(out, context);
                    }
                }
            }
        }
        return out;
    }

    private ItemStack fromOptionalLootTable(ItemStack in, LootContext context) {
        LootTable lT;
        ItemStack out = in;
        ResourceLocation r = new ResourceLocation(this._itemid);
        if (ModIntegration.isPresent(r.func_110624_b()) && (lT = context.func_227502_a_(r)) != LootTable.field_186464_a) {
            try {
                List hits = lT.func_216113_a(context);
                for (ItemStack hit : hits) {
                    if (hit.func_190926_b()) continue;
                    out = hit;
                    break;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return out;
    }

    private ItemStack fromBarterTokenSource(ItemStack in, LootContext context) {
        String rmodid;
        ModIntegration mod;
        ItemStack out = in;
        QualityGrade qg = QualityGrade.findOrUnknown(this._itemid);
        if (qg.isKnown() && Bartering.isEnabled(mod = ModIntegration.get(rmodid = this._modid != null ? this._modid : LibInfo.MOD_ID()))) {
            out = Bartering.getTokenFactory(mod).apply(qg);
        }
        return out;
    }

    private void giveLootedAdvancement(ItemStack out, LootContext context) {
        ServerPlayerEntity player = SharedGlue.getPlayerMPOrNull((Entity)Loot.playerFrom(context));
        if (player != null) {
            LootedItemTrigger.doApply(player, out);
        }
    }

    public static class Serializer
    extends LootFunction.Serializer<IfPresentUseFunction> {
        public IfPresentUseFunction deserialize(JsonObject object, JsonDeserializationContext deserializationContext, ILootCondition[] conditions) {
            String itemid = StringUtils.trimToNull((String)JSONUtils.func_151219_a((JsonObject)object, (String)"prefer", null));
            Type type = Type.fromLString(JSONUtils.func_151219_a((JsonObject)object, (String)"type", null));
            String req_modid = StringUtils.trimToNull((String)JSONUtils.func_151219_a((JsonObject)object, (String)"modid", null));
            if (LibInfo.MOD_ID().equals(req_modid)) {
                req_modid = null;
            }
            TagIsPresentCondition.TagType req_tagtype = null;
            String req_tagvalue = StringUtils.trimToNull((String)JSONUtils.func_151219_a((JsonObject)object, (String)"tag", null));
            if (req_tagvalue == null) {
                req_tagvalue = StringUtils.trimToNull((String)JSONUtils.func_151219_a((JsonObject)object, (String)"dict", null));
            }
            if (req_tagvalue != null) {
                String typestring = JSONUtils.func_151219_a((JsonObject)object, (String)"tag_type", (String)"");
                req_tagtype = TagIsPresentCondition.TagType.fromLString(typestring);
            }
            ResourceLocation req_advid = null;
            if (object.has("advanced")) {
                req_advid = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"advanced"));
            }
            return new IfPresentUseFunction(conditions, itemid, type, req_modid, req_tagtype, req_tagvalue, req_advid);
        }

        public void serialize(JsonObject object, IfPresentUseFunction lfunction, JsonSerializationContext serializationContext) {
            String type;
            super.func_230424_a_(object, (LootFunction)lfunction, serializationContext);
            if (lfunction._modid != null) {
                object.add("modid", serializationContext.serialize((Object)lfunction._modid));
            }
            if (lfunction._tagvalue != null) {
                object.add("tag", serializationContext.serialize((Object)lfunction._tagvalue));
                if (lfunction._tag != TagIsPresentCondition.TagType.ITEM) {
                    object.add("tag_type", serializationContext.serialize((Object)lfunction._tag.Lstring()));
                }
            }
            if (lfunction._advanced != null) {
                object.add("advanced", serializationContext.serialize((Object)lfunction._advanced));
            }
            if (lfunction._itemid != null) {
                object.add("prefer", serializationContext.serialize((Object)lfunction._itemid));
            }
            if ((type = Type.toLString(lfunction._itemtype)) != null) {
                object.add("type", serializationContext.serialize((Object)type));
            }
        }
    }

    public static enum Type {
        ITEM,
        LOOT_TABLE,
        REWARD,
        BARTER_TOKEN;


        @Nullable
        public static final Type fromLString(@Nullable String s) {
            if ("item".equals(s)) {
                return ITEM;
            }
            if ("loot_table".equals(s)) {
                return LOOT_TABLE;
            }
            if ("reward".equals(s)) {
                return REWARD;
            }
            if ("barter_token".equals(s)) {
                return BARTER_TOKEN;
            }
            return null;
        }

        @Nullable
        public static final String toLString(@Nullable Type type) {
            return type == null || type == ITEM ? null : (type == REWARD ? "reward" : (type == BARTER_TOKEN ? "barter_token" : "loot_table"));
        }
    }
}

