/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import org.jwaresoftware.mcmods.lib.loot.CarrotsLootTypes;
import org.jwaresoftware.mcmods.lib.loot.LootConditionBase;

public final class RandomChanceWithLuckCondition
extends LootConditionBase {
    final float _chance;
    final float _luckMultiplier;

    public RandomChanceWithLuckCondition(float chance, float luckMultiplier) {
        this._chance = chance;
        this._luckMultiplier = luckMultiplier;
    }

    @Override
    protected LootConditionType _getLootConditionType() {
        return CarrotsLootTypes.Conditions.RANDOM_CHANCE_WITH_LUCK;
    }

    public boolean test(LootContext context) {
        float luck = context.func_186491_f();
        return context.func_216032_b().nextFloat() < this._chance + luck * this._luckMultiplier;
    }

    public static ILootCondition.IBuilder builder(float chance, float multiplier) {
        return () -> new RandomChanceWithLuckCondition(chance, multiplier);
    }

    public static class Serializer
    implements ILootSerializer<RandomChanceWithLuckCondition> {
        public RandomChanceWithLuckCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            return new RandomChanceWithLuckCondition(JSONUtils.func_151217_k((JsonObject)json, (String)"chance"), JSONUtils.func_151217_k((JsonObject)json, (String)"luck_multiplier"));
        }

        public void serialize(JsonObject json, RandomChanceWithLuckCondition lcond, JsonSerializationContext context) {
            json.addProperty("chance", (Number)Float.valueOf(lcond._chance));
            json.addProperty("luck_multiplier", (Number)Float.valueOf(lcond._luckMultiplier));
        }
    }
}

