/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistries;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LibConfig;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.impl.Flag;
import org.jwaresoftware.mcmods.lib.loot.CarrotsLootTypes;
import org.jwaresoftware.mcmods.lib.loot.Loot;

public final class RandomPotionFunction
extends LootFunction {
    private static boolean _DISABLED = true;
    private static final Random _RNG = new SecureRandom();
    private static List<Potion> _THE_GOOD = Collections.EMPTY_LIST;
    private static List<Potion> _THE_BADD = Collections.EMPTY_LIST;
    final Type _type;
    final boolean _send_event;
    final boolean _allow_basep;

    public static final void initFinalize() {
        if (_THE_GOOD.isEmpty()) {
            _DISABLED = false;
            _THE_GOOD = new ArrayList<Potion>(211);
            _THE_BADD = new ArrayList<Potion>(211);
            ForgeRegistries.POTION_TYPES.forEach(pT -> {
                if (!LibConfig.omitFromRandomGeneration_s(pT)) {
                    Flag good = new Flag(true);
                    pT.func_185170_a().forEach(pE -> {
                        if (Potions.isHarmful(pE.func_188419_a(), false)) {
                            good.setFalse();
                        }
                    });
                    if (good.isFalse()) {
                        _THE_BADD.add((Potion)pT);
                    } else {
                        _THE_GOOD.add((Potion)pT);
                    }
                }
            });
            if (_THE_GOOD.isEmpty() || _THE_BADD.isEmpty()) {
                LibInfo.LOG.warn("Unable to find standard potions; random potion loot function useless");
                _DISABLED = true;
            }
            if (_THE_GOOD.isEmpty()) {
                _THE_GOOD.add(net.minecraft.potion.Potions.field_185232_d);
            }
            if (_THE_BADD.isEmpty()) {
                _THE_BADD.add(net.minecraft.potion.Potions.field_185231_c);
            }
        }
    }

    public RandomPotionFunction(ILootCondition[] conditions, Type type, boolean allow_basep, boolean send_event) {
        super(conditions);
        this._type = type;
        this._allow_basep = allow_basep;
        this._send_event = send_event;
    }

    public LootFunctionType func_230425_b_() {
        return CarrotsLootTypes.Functions.RANDOM_POTION;
    }

    private static final Potion defaultAny(Random rng) {
        return rng.nextFloat() < 0.7f ? net.minecraft.potion.Potions.field_185250_v : net.minecraft.potion.Potions.field_185252_x;
    }

    public ItemStack func_215859_a(ItemStack in, LootContext context) {
        ItemStack out = in;
        if (!_DISABLED && !in.func_190926_b()) {
            Potion pT;
            Random rng = context.func_216032_b() == context.func_202879_g().func_201674_k() ? _RNG : context.func_216032_b();
            switch (this._type) {
                case HARMFUL: {
                    pT = _THE_BADD.get(rng.nextInt(_THE_BADD.size()));
                    break;
                }
                case BENEFICIAL: {
                    pT = _THE_GOOD.get(rng.nextInt(_THE_GOOD.size()));
                    break;
                }
                default: {
                    pT = (Potion)Registry.field_212621_j.func_186801_a(rng);
                    if (!Potions.isEmpty(pT) || this._allow_basep) break;
                    pT = RandomPotionFunction.defaultAny(rng);
                }
            }
            if (this._allow_basep || !Potions.isEmpty(pT)) {
                out = Potions.isap(in, false) ? ItemStacks.copy1(in) : new ItemStack((IItemProvider)Items.field_151068_bn);
                PotionUtils.func_185188_a((ItemStack)out, (Potion)pT);
                if (this._send_event) {
                    NonNullList lwrap = NonNullList.func_191196_a();
                    lwrap.add((Object)out);
                    try {
                        ForgeEventFactory.onPotionBrewed((NonNullList)lwrap);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                out = Loot.resized(out, in.func_190916_E());
            }
        }
        return out;
    }

    @Nullable
    public static final Potion get(Type type, @Nullable Potion defaultIfDisabled) {
        Potion outp = defaultIfDisabled;
        if (!_DISABLED) {
            Potion p;
            if (type == null) {
                type = Type.ANY;
            }
            switch (type) {
                case HARMFUL: {
                    p = _THE_BADD.get(_RNG.nextInt(_THE_BADD.size()));
                    break;
                }
                case BENEFICIAL: {
                    p = _THE_GOOD.get(_RNG.nextInt(_THE_GOOD.size()));
                    break;
                }
                default: {
                    p = (Potion)Registry.field_212621_j.func_186801_a(_RNG);
                }
            }
            if (p != null && !p.func_185170_a().isEmpty()) {
                outp = p;
            }
        }
        return outp;
    }

    public static final boolean doApply(ItemStack in, Type type, boolean byname) {
        Potion p;
        boolean altered = false;
        if (!(_DISABLED || ItemStacks.isEmpty(in) || (p = RandomPotionFunction.get(type, null)) == null || p.func_185170_a().isEmpty())) {
            if (byname) {
                PotionUtils.func_185188_a((ItemStack)in, (Potion)p);
            } else {
                PotionUtils.func_185184_a((ItemStack)in, (Collection)p.func_185170_a());
            }
            altered = true;
        }
        return altered;
    }

    public static final class Serializer
    extends LootFunction.Serializer<RandomPotionFunction> {
        public RandomPotionFunction deserialize(JsonObject object, JsonDeserializationContext deserializationContext, ILootCondition[] conditions) {
            String typestring = JSONUtils.func_151219_a((JsonObject)object, (String)"type", (String)Type.ANY.value());
            boolean allow_basep = JSONUtils.func_151209_a((JsonObject)object, (String)"inerts", (boolean)false);
            boolean events = JSONUtils.func_151209_a((JsonObject)object, (String)"sendevent", (boolean)false);
            return new RandomPotionFunction(conditions, Type.fromLString(typestring), allow_basep, events);
        }

        public void serialize(JsonObject object, RandomPotionFunction lfunction, JsonSerializationContext serializationContext) {
            super.func_230424_a_(object, (LootFunction)lfunction, serializationContext);
            if (lfunction._type != Type.ANY) {
                object.add("type", serializationContext.serialize((Object)lfunction._type.value()));
            }
            if (lfunction._allow_basep) {
                object.add("inerts", serializationContext.serialize((Object)true));
            }
            if (lfunction._send_event) {
                object.add("sendevent", serializationContext.serialize((Object)true));
            }
        }
    }

    public static enum Type {
        ANY("any"),
        BENEFICIAL("good"),
        HARMFUL("bad");

        private final String _value;

        private Type(String v) {
            this._value = v;
        }

        public String value() {
            return this._value;
        }

        public static final Type fromLString(String s) {
            if (BENEFICIAL.value().equals(s) || "buff".equals(s)) {
                return BENEFICIAL;
            }
            if (HARMFUL.value().equals(s) || "debuff".equals(s)) {
                return HARMFUL;
            }
            return ANY;
        }
    }
}

