/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.JSONUtils;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.loot.CarrotsLootTypes;

public final class SetUnbreakableFunction
extends LootFunction {
    final boolean _unrepairable;

    public SetUnbreakableFunction(ILootCondition[] conditions, boolean unrepairable) {
        super(conditions);
        this._unrepairable = unrepairable;
    }

    public LootFunctionType func_230425_b_() {
        return CarrotsLootTypes.Functions.SET_UNBREAKABLE;
    }

    public ItemStack func_215859_a(ItemStack stack, LootContext context) {
        if (!stack.func_190926_b()) {
            CompoundNBT nbt = ItemStacks.getOrCreateData(stack);
            nbt.func_74757_a("Unbreakable", true);
            if (this._unrepairable && stack.func_77984_f()) {
                stack.func_82841_c(SharedGlue.UNREPAIRABLE_TOOL_COST());
            }
        }
        return stack;
    }

    public static class Serializer
    extends LootFunction.Serializer<SetUnbreakableFunction> {
        public SetUnbreakableFunction deserialize(JsonObject object, JsonDeserializationContext deserializationContext, ILootCondition[] conditions) {
            boolean unrepairable = !JSONUtils.func_151209_a((JsonObject)object, (String)"repairable", (boolean)false);
            return new SetUnbreakableFunction(conditions, unrepairable);
        }

        public void serialize(JsonObject object, SetUnbreakableFunction lfunction, JsonSerializationContext serializationContext) {
            super.func_230424_a_(object, (LootFunction)lfunction, serializationContext);
            if (!lfunction._unrepairable) {
                object.add("repairable", serializationContext.serialize((Object)true));
            }
        }
    }
}

