/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.recipes;

import com.google.gson.JsonObject;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.api.mod.IModConfig;
import org.jwaresoftware.mcmods.lib.recipes.ModConfigConditionBase;

public final class ConfigIsPresentCondition
extends ModConfigConditionBase {
    public static final ResourceLocation NAME = LibInfo.r("config_present");
    final String _feature;

    public ConfigIsPresentCondition(IModConfig config, String feature) {
        super(config);
        this._feature = feature;
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test() {
        if ("false".equals(this._feature)) {
            return false;
        }
        return "true".equals(this._feature) || this._config.isPresent(this._feature);
    }

    public static abstract class Serializer
    implements IConditionSerializer<ConfigIsPresentCondition> {
        protected final IModConfig _config;
        protected final String _default_feature;

        protected Serializer(@Nonnull IModConfig config) {
            this(config, "supercalifragilisticexpialidocious");
        }

        protected Serializer(@Nonnull IModConfig config, @Nonnull String feature) {
            this._config = config;
            this._default_feature = Objects.requireNonNull(feature, "a config option name required");
        }

        public final ConfigIsPresentCondition read(JsonObject json) {
            String feature = JSONUtils.func_151219_a((JsonObject)json, (String)"value", (String)this._default_feature);
            return new ConfigIsPresentCondition(this._config, feature);
        }

        public final void write(JsonObject json, ConfigIsPresentCondition rc) {
            if (!this._default_feature.equals(rc._feature)) {
                json.addProperty("value", rc._feature);
            }
        }
    }
}

