/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.recipes;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.recipes.JR;
import org.jwaresoftware.mcmods.lib.recipes.NutritionNotedShapelessRecipe;
import org.jwaresoftware.mcmods.lib.recipes.ShapedRecipeWrapping;

public class NutritionNotedShapedRecipe
extends ShapedRecipeWrapping {
    @Nullable
    final NutritionNotedShapelessRecipe.NNAdjustment _nnadj;
    final boolean _cleanwipe;

    NutritionNotedShapedRecipe(boolean wipe, @Nullable NutritionNotedShapelessRecipe.NNAdjustment nnadj, ShapedRecipe from) {
        super(from);
        this._nnadj = nnadj;
        this._cleanwipe = wipe;
    }

    @Override
    public IRecipeSerializer<?> func_199559_b() {
        return Serializer.INSTANCE;
    }

    @Override
    public ItemStack func_77571_b() {
        return JR.safeNotifyCookedOrCrafted(ItemStacks.copy(super.func_77571_b()), (IInventory)null, this._nnadj);
    }

    @Override
    public ItemStack func_77572_b(CraftingInventory grid) {
        return JR.safeNotifyCookedOrCrafted(this.baseline_getCraftingResult(grid), (IInventory)grid, this._nnadj);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory grid) {
        return this._cleanwipe ? SharedGlue.emptyNonNullItemStackList(grid.func_70302_i_()) : super.func_179532_b((IInventory)grid);
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<NutritionNotedShapedRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public NutritionNotedShapedRecipe read(ResourceLocation recipeId, JsonObject json) {
            NutritionNotedShapelessRecipe.NNAdjustment nnadj = NutritionNotedShapelessRecipe.NNAdjustment.deserialize_outof(json.get("nnotes"));
            boolean wipe = JSONUtils.func_151209_a((JsonObject)json, (String)"cleanwipe", (boolean)false);
            return new NutritionNotedShapedRecipe(wipe, nnadj, JR.readShaped(recipeId, json));
        }

        public void write(PacketBuffer data, NutritionNotedShapedRecipe recipe) {
            data.writeBoolean(recipe._cleanwipe);
            NutritionNotedShapelessRecipe.NNAdjustment.save(data, recipe._nnadj);
            JR.writeShaped(data, recipe);
        }

        public NutritionNotedShapedRecipe read(ResourceLocation recipeId, PacketBuffer data) {
            boolean wipe = data.readBoolean();
            NutritionNotedShapelessRecipe.NNAdjustment nnadj = NutritionNotedShapelessRecipe.NNAdjustment.read(data);
            return new NutritionNotedShapedRecipe(wipe, nnadj, JR.readShaped(recipeId, data));
        }
    }
}

