/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.recipes;

import com.google.gson.JsonObject;
import java.util.Locale;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.RID;

public final class TagIsPresentCondition
implements ICondition {
    public static final ResourceLocation NAME = LibInfo.r("tag_exists");
    final String _tag;
    final TagType _type;
    final boolean _is_not;

    TagIsPresentCondition(String tag, @Nullable TagType type, boolean inverse) {
        this._tag = tag;
        this._type = type == null ? TagType.ITEM : type;
        this._is_not = inverse;
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test() {
        boolean is = this._type.test(this._tag);
        return is == !this._is_not;
    }

    public static class Serializer
    implements IConditionSerializer<TagIsPresentCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public ResourceLocation getID() {
            return NAME;
        }

        public final TagIsPresentCondition read(JsonObject json) {
            String name = JSONUtils.func_151219_a((JsonObject)json, (String)"value", (String)"supercalifragilisticexpialidocious");
            TagType type = TagType.fromLString(JSONUtils.func_151219_a((JsonObject)json, (String)"tag_type", null));
            return new TagIsPresentCondition(name, type, JSONUtils.func_151209_a((JsonObject)json, (String)"inverse", (boolean)false));
        }

        public final void write(JsonObject json, TagIsPresentCondition rc) {
            if (!"supercalifragilisticexpialidocious".equals(rc._tag)) {
                json.addProperty("value", rc._tag);
                if (rc._type != TagType.ITEM) {
                    json.addProperty("tag_type", rc._type.Lstring());
                }
                json.addProperty("inverse", Boolean.valueOf(rc._is_not));
            }
        }
    }

    public static enum TagType implements Predicate<String>
    {
        MISSING(t -> false),
        ITEM(t -> RID.isIngredientDefined(t)),
        FLUID(t -> RID.isFluidDefined(t)),
        BLOCK(t -> RID.getBlockTag(t) != null),
        ENCHANTMENT(t -> RID.getEnchantmentTag(t) != null),
        POTION(t -> RID.getPotionTag(t) != null);

        private final Predicate<String> _impl;

        private TagType(Predicate<String> check) {
            this._impl = check;
        }

        @Override
        public final boolean test(String tag) {
            return this._impl.test(tag);
        }

        public final String Lstring() {
            return this == MISSING ? "false" : this.name().toLowerCase(Locale.ROOT);
        }

        @Nullable
        public static final TagType fromLString(@Nullable String s) {
            if (s != null && !s.isEmpty()) {
                if ("fluid".equals(s = s.toLowerCase(Locale.ROOT))) {
                    return FLUID;
                }
                if ("block".equals(s)) {
                    return BLOCK;
                }
                if ("false".equals(s) || "impossible".equals(s)) {
                    return MISSING;
                }
                if ("potion".equals(s)) {
                    return POTION;
                }
                if ("enchantment".equals(s)) {
                    return ENCHANTMENT;
                }
            }
            return null;
        }
    }
}

