/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.impl.FoodItemBase;

public final class FoodPortion
extends FoodItemBase {
    private static final ThreadLocal<FoodPortion> _currentFoodPortion = new ThreadLocal();
    private final int _foodValue;
    private final float _foodSaturation;

    public FoodPortion(int foodAmount, float foodSaturation) {
        super("gen_anyfood_portion", foodAmount, foodSaturation, false, true);
        this._foodValue = foodAmount;
        this._foodSaturation = foodSaturation;
    }

    public final String itemid_prefix() {
        return "vfp_";
    }

    private void onConsumedViaACStats(ItemStack eaten, World world, PlayerEntity player) {
        player.func_71024_bL().func_221410_a((Item)this, eaten);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onConsumed(ItemStack eaten, int foodAmount, float foodSaturation, World world, PlayerEntity player) {
        if (ModIntegration.APPLECORE.isLoaded()) {
            FoodPortion portion = new FoodPortion(foodAmount, foodSaturation);
            _currentFoodPortion.set(portion);
            try {
                portion.onConsumedViaACStats(eaten, world, player);
            }
            finally {
                _currentFoodPortion.set(null);
                portion = null;
            }
        } else {
            player.func_71024_bL().func_75122_a(foodAmount, foodSaturation);
        }
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> items) {
    }

    @Nullable
    private static FoodPortion toACEdible(ItemStack stack, Item item) {
        FoodPortion adapter = null;
        return adapter;
    }

    @Nullable
    public static Item toFood(@Nonnull ItemStack ingredient) {
        FoodPortion food = null;
        if (!ItemStacks.isEmpty((ItemStack)ingredient)) {
            Item item = ingredient.func_77973_b();
            if (ModIntegration.APPLECORE.isLoaded()) {
                food = FoodPortion.toACEdible(ingredient, item);
            }
            if (food == null && item.func_219971_r() && item.func_219967_s() != null) {
                food = item;
            }
        }
        return food;
    }
}

