/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LiquidType;
import org.jwaresoftware.mcmods.lib.api.IDrink;
import org.jwaresoftware.mcmods.lib.api.IMultiColored;
import org.jwaresoftware.mcmods.lib.capability.ITemperatureChangeable;
import org.jwaresoftware.mcmods.lib.integration.ENVHelper;
import org.jwaresoftware.mcmods.vfp.common.FoodColor;
import org.jwaresoftware.mcmods.vfp.common.IReheatable;
import org.jwaresoftware.mcmods.vfp.common.Ingredient;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpLiquidFood;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;

public abstract class VfpLiquidMultiItem
extends VfpPantryMultiItem
implements IMultiColored,
IDrink {
    @Nonnull
    protected final LiquidType _drinkType;

    protected static final <T extends Ingredient> boolean register(T flavor, List<T> variant_flavors, String typename) {
        Validate.notNull(flavor, (String)"A non-null flavor is required for %s", (Object[])new Object[]{typename});
        boolean added = false;
        if (!variant_flavors.contains(flavor)) {
            added = variant_flavors.add(flavor);
        }
        return added;
    }

    protected VfpLiquidMultiItem(@Nonnull VfpProfile baseprofile, @Nonnull VfpVariant variant, @Nonnull LiquidType type) {
        super(baseprofile, false, variant, (ItemGroup)null, true);
        Validate.notNull((Object)type, (String)"Non-null liquid type required", (Object[])new Object[0]);
        this._drinkType = type;
        this.setMaxStackSize(this.getItemMaxStackSize().count());
        this.completeInit(this._profile);
    }

    protected abstract Item getNewEmptyContainer();

    protected VfpCapacity getItemMaxStackSize() {
        return VfpLiquidFood.DEFAULT_STACK_SIZE;
    }

    @Nullable
    protected Integer getColorFromIngredient(Ingredient ingredient, int tintIndex) {
        int num;
        Integer colorValue = null;
        Item ingredientitem = ingredient.recipeitem().func_77973_b();
        if (ingredient instanceof FoodColor) {
            int num2 = ((FoodColor)((Object)ingredient)).color(ingredient.recipeitem());
            if (num2 != 0xF1F1F1) {
                colorValue = num2;
            }
        } else if (ingredientitem instanceof FoodColor) {
            int num3 = ((FoodColor)ingredientitem).color(ingredient.recipeitem());
            if (num3 != 0xF1F1F1) {
                colorValue = num3;
            }
        } else if (ingredientitem instanceof IMultiColored && (num = ((IMultiColored)ingredientitem).getColorFrom(ingredient.recipeitem(), tintIndex)) != 0xFFFFFF) {
            colorValue = num;
        }
        return colorValue;
    }

    protected int getColorFromVariant(int tintIndex) {
        Integer colorValue;
        int color_num = 0;
        Ingredient ingredient = this._variant.datadata(Ingredient.class);
        if (ingredient != null && (colorValue = this.getColorFromIngredient(ingredient, tintIndex)) != null) {
            color_num = colorValue;
        }
        return color_num;
    }

    public int getColorFrom(ItemStack stack, int tintIndex) {
        int default_color_num;
        int color_num = default_color_num = 0xFFFFFF;
        if (tintIndex <= 0 && (color_num = this.getColorFromVariant(tintIndex)) == 0) {
            color_num = default_color_num;
        }
        return color_num;
    }

    @Override
    protected boolean canConsume(ItemStack held, World world, PlayerEntity player) {
        boolean consume = super.canConsume(held, world, player);
        if (!consume && (VfpConfig.manageTemperature() || VfpConfig.manageThirst())) {
            IReheatable t_cap;
            boolean bl = consume = this.getThirstQuenched(held) > 0.0f && ENVHelper.isThirsty((World)world, (PlayerEntity)player);
            if (!consume && (t_cap = this.getTemperatureChangeCapability(held)) != null && t_cap.hasBonusTemperature(held)) {
                consume = ENVHelper.isPlayerAtExtremeTemperature((PlayerEntity)player, (boolean)t_cap.isCooled(held));
            }
        }
        return consume;
    }

    @Override
    protected void applyPotionEffectsOnConsumed(ItemStack original, ItemStack remaining, World world, PlayerEntity player) {
        super.applyPotionEffectsOnConsumed(original, remaining, world, player);
        if (VfpConfig.manageThirst()) {
            ENVHelper.quenchThirst((PlayerEntity)player, (IDrink)this, (ItemStack)original);
        }
        if (VfpConfig.manageTemperature()) {
            IReheatable t_cap = this.getTemperatureChangeCapability(original);
            ENVHelper.applyTemperatureRelief((ItemStack)original, (ITemperatureChangeable)t_cap, (PlayerEntity)player);
        }
    }

    @Override
    protected ItemStack onItemConsumedFully(ItemStack original, ItemStack remaining, World world, PlayerEntity player) {
        return VfpLiquidMultiItem.returnOrDropContainer((ItemStack)remaining, (PlayerEntity)player, (ItemStack)ItemStacks.create((Item)this.getNewEmptyContainer()));
    }

    public float getThirstQuenched(ItemStack liquid) {
        return this._drinkType.getThirstQuenched(liquid);
    }

    public float getHydrationAdded(ItemStack liquid) {
        return this._drinkType.getHydrationAdded(liquid);
    }

    public float getThirstTriggerChance(ItemStack liquid, @Nullable LivingEntity drinker) {
        return this._drinkType.getThirstTriggerChance(liquid, drinker);
    }

    public int getTemperatureModifier(ItemStack liquid) {
        return 1;
    }
}

