/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.Effects;
import org.jwaresoftware.mcmods.lib.Instructions;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.Tooltips;
import org.jwaresoftware.mcmods.lib.api.IHappyFood;
import org.jwaresoftware.mcmods.lib.api.INutritionSource;
import org.jwaresoftware.mcmods.lib.api.ITiny;
import org.jwaresoftware.mcmods.lib.impl.FoodItemBase;
import org.jwaresoftware.mcmods.lib.impl.ItemSupport;
import org.jwaresoftware.mcmods.vfp.common.FoodPortion;
import org.jwaresoftware.mcmods.vfp.common.IReheatable;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpAware;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpPotions;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;

public class VfpPantryItem
extends FoodItemBase
implements VfpAware,
INutritionSource {
    public static final int DEFAULT_GOOD_POTION_EFFECT_DURATION_SECS = 30;
    public static final int DEFAULT_BAD_POTION_EFFECT_DURATION_SECS = 15;
    protected static final int MAX_FOOD_POINTS_ALLOWED = SharedGlue.DEFAULT_MAX_PLAYER_FOOD_LEVEL();
    protected static final int PORTION_FOOD_AMOUNT = 2 * SharedGlue.PLAYER_ONE_FOOD_LEVEL();
    protected static final int MAX_PORTION_FOOD_AMOUNT = 4 * SharedGlue.PLAYER_ONE_FOOD_LEVEL();
    public static final int MAX_TOTAL_FOOD_VALUE_ALLOWED = LikeFood.HEFTIEST_FOOD.healAmount() * SharedGlue.TABLE_CRAFT_GRID_SIZE();
    protected static final float MAX_FOOD_SATURATION_ALLOWED = SharedGlue.DEFAULT_MAX_PLAYER_SATURATION_LEVEL();
    private static final String _NBT_FOOD_TOTAL_USED = "FoodUsed";
    private static final String _NBT_FOOD_TOTAL = "FoodTotal";
    private static final String _NBT_FOOD_PER_USE = "FoodPortion";
    protected static final String _NBT_FOOD_SATURATION = "FoodSaturation";
    static final TextFormatting _BLUE = TextFormatting.BLUE;
    static final TextFormatting _ENDD = TextFormatting.RESET;
    protected final VfpProfile _profile;
    protected final boolean _debugFlag;
    protected final int _foodPoints;
    protected final float _saturationModifier;
    protected boolean _instaConsumeAllowed = false;
    protected boolean _returnContainerOnConsumed;

    @Nonnull
    public static Item.Properties foodproperties(@Nullable Item.Properties ip, LikeFood like, boolean isWolfFood) {
        return VfpPantryItem.foodproperties((Item.Properties)ip, (int)like.healAmount(), (float)like.saturationModifier(), (boolean)isWolfFood, (boolean)false);
    }

    public VfpPantryItem(@Nonnull VfpProfile profile, Item.Properties ip, int foodPoints, float saturationFactor, boolean delayed) {
        super(profile.fmlid(), false, ip);
        Validate.isTrue((boolean)profile.isItem(), (String)"A pantry item's VFP type MUST align as an Item", (Object[])new Object[0]);
        this._profile = profile;
        this._debugFlag = VfpConfig.getInstance().isDebugMode();
        this._foodPoints = foodPoints;
        this._saturationModifier = saturationFactor;
        if (!delayed) {
            this.completeInit(profile);
        }
    }

    public VfpPantryItem(@Nonnull VfpProfile profile, Item.Properties ip, LikeFood like, boolean delayed) {
        this(profile, ip, like.healAmount(), like.saturationModifier(), delayed);
    }

    protected VfpPantryItem(@Nonnull VfpProfile profile, int foodPoints, float saturationFactor, boolean isWolfFood, @Nullable ItemGroup tab, boolean delayed) {
        this(profile, VfpPantryItem.foodproperties(null, (int)foodPoints, (float)saturationFactor, (boolean)isWolfFood, (boolean)false).func_200916_a(VfpUtils.bestTab(profile, tab == null ? SharedGlue.CreativeTabs_food : tab)), foodPoints, saturationFactor, delayed);
    }

    protected VfpPantryItem(@Nonnull VfpProfile profile, LikeFood like, boolean isWolfFood, @Nullable ItemGroup tab, boolean delayed) {
        this(profile, VfpPantryItem.foodproperties(null, (int)like.healAmount(), (float)like.saturationModifier(), (boolean)isWolfFood, (boolean)false).func_200916_a(VfpUtils.bestTab(profile, tab == null ? SharedGlue.CreativeTabs_food : tab)), like.healAmount(), like.saturationModifier(), delayed);
    }

    public VfpPantryItem(VfpProfile profile, int foodLevel, float saturationFactor, boolean isWolfFood, ItemGroup tab) {
        this(profile, foodLevel, saturationFactor, isWolfFood, tab, false);
    }

    public VfpPantryItem(VfpProfile profile, int foodLevel, float saturationFactor, ItemGroup tab) {
        this(profile, foodLevel, saturationFactor, false, tab);
    }

    public VfpPantryItem(VfpProfile profile, LikeFood like, ItemGroup tab) {
        this(profile, like.healAmount(), like.saturationModifier(), false, tab);
    }

    public VfpPantryItem(VfpProfile profile, LikeFood like, ItemGroup tab, boolean delayed) {
        this(profile, like.healAmount(), like.saturationModifier(), false, tab, delayed);
    }

    public VfpPantryItem(VfpProfile profile, LikeFood like, boolean isWolfFood, ItemGroup tab) {
        this(profile, like.healAmount(), like.saturationModifier(), isWolfFood, tab);
    }

    public VfpPantryItem(VfpProfile profile) {
        this(profile, LikeFood.crumb, null);
    }

    public final String itemid_prefix() {
        return this._profile.itemid_prefix();
    }

    @Override
    public final VfpProfile vfplink() {
        return this._profile;
    }

    public final <T extends VfpPantryItem> T autoregister(Class<T> of) {
        VfpUtils.autoregisterItem((Item)this, this._profile);
        return (T)((VfpPantryItem)of.cast(this));
    }

    public final VfpPantryItem autoregister() {
        VfpUtils.autoregisterItem((Item)this, this._profile);
        return this;
    }

    public final void setHiddenByDefault(boolean hidden) {
        this._hidden = hidden;
    }

    public final VfpPantryItem setConsumeFullyContainerItem(@Nonnull Item containerItem) {
        this.setContainerItem(containerItem);
        this._returnContainerOnConsumed = true;
        return this;
    }

    protected boolean isEdible(@Nullable ItemStack stack) {
        return this._profile.isEdible();
    }

    protected boolean isDrinkable(@Nullable ItemStack stack) {
        return this.isEdible(stack) && this._profile.isLiquid();
    }

    protected boolean isEdibleUse(ItemStack stack) {
        return this.isEdible(stack) && (stack == null || this.getHealAmount(stack) > 0);
    }

    @Nullable
    public Food func_219967_s() {
        return this.isEdible(ItemStack.field_190927_a) ? super.func_219967_s() : null;
    }

    protected boolean isMultiuse(ItemStack stack) {
        return this._profile.isCompressible() && this.isEdible(stack) && stack.func_77973_b() == this && Instructions.hasXFoodFlag((ItemStack)stack);
    }

    protected boolean isDynamic(ItemStack stack) {
        return this._profile.isDynamic() && this.isEdible(stack) && stack.func_77973_b() == this && Instructions.hasXFoodFlag((ItemStack)stack);
    }

    protected boolean isInstaConsume(ItemStack stack) {
        return this.isEdible(stack) && this._instaConsumeAllowed && VfpConfig.getInstance().allowInstaEating() && this.getHealAmount(stack) <= LikeFood.MORSEL_PORTION.healAmount();
    }

    protected boolean getPreferSingleUseFood() {
        boolean flat = VfpConfig.getInstance().preferSingleUseFood("all", false);
        if (flat && this._foodPoints > SharedGlue.DEFAULT_MAX_PLAYER_FOOD_LEVEL()) {
            flat = false;
        }
        return flat;
    }

    public <T extends VfpPantryItem> T setInstaConsume() {
        this._instaConsumeAllowed = true;
        return (T)this;
    }

    @Nullable
    protected IReheatable getTemperatureChangeCapability(ItemStack stack) {
        IReheatable spi = null;
        if (!ItemStacks.isEmpty((ItemStack)stack) && this.isEdible(stack) && stack.func_77973_b() instanceof IReheatable) {
            spi = (IReheatable)stack.func_77973_b();
        }
        return spi;
    }

    protected void completeInit(@Nonnull VfpProfile profile) {
        if (this.isEdible(null)) {
            if (profile.isHarmfulIfEatenDirectly()) {
                float chance = 0.0625f;
                if (profile.isHarmfulIfEatenDirectlyAlways()) {
                    chance = 1.0f;
                }
                this.addPotionEffect(SharedGlue.Potion_poison, this.getPotionEffectDurationSecs(false), (int)chance, chance);
            } else if (profile.isEmptyCalorieSugarHigh()) {
                this.addPotionEffect(SharedGlue.Potion_moveSpeed, this.getPotionEffectDurationSecs(true), 1, 1.0f);
                this.setAlwaysEdible();
            }
        }
    }

    protected int getPotionEffectDurationSecs(boolean good) {
        return good ? 30 : 15;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return !this.isEdibleUse(stack) ? UseAction.NONE : (this.isDrinkable(stack) ? UseAction.DRINK : super.func_77661_b(stack));
    }

    public int func_77626_a(ItemStack stack) {
        return !this.isEdibleUse(stack) ? 0 : (this.getHealAmount(stack) <= LikeFood.MORSEL_PORTION.healAmount() ? SharedGlue.SHORT_FOOD_CONSUME_DURATION() : super.func_77626_a(stack));
    }

    protected int getDefaultPortionFoodPoints() {
        return -1;
    }

    public int getPortionFoodPoints(ItemStack stack) {
        int amount = this._foodPoints;
        if (this.isMultiuse(stack)) {
            CompoundNBT instr = Instructions.get((ItemStack)stack);
            if (instr.func_150297_b(_NBT_FOOD_PER_USE, 99)) {
                amount = instr.func_74762_e(_NBT_FOOD_PER_USE);
            } else {
                amount = this.getDefaultPortionFoodPoints();
                if (amount <= 0) {
                    amount = PORTION_FOOD_AMOUNT;
                }
            }
        }
        return amount;
    }

    public int getFoodPointsUsed(@Nonnull ItemStack stack) {
        int amount = -1;
        if (this.isMultiuse(stack)) {
            CompoundNBT instr = Instructions.get((ItemStack)stack);
            amount = instr.func_74762_e(_NBT_FOOD_TOTAL_USED);
        }
        return amount;
    }

    public int getTotalFoodPoints(@Nonnull ItemStack stack) {
        CompoundNBT instr;
        int amount = this.getPortionFoodPoints(stack);
        if (this.isMultiuse(stack) && (instr = Instructions.get((ItemStack)stack)).func_150297_b(_NBT_FOOD_TOTAL, 99)) {
            amount = instr.func_74762_e(_NBT_FOOD_TOTAL);
        }
        return amount;
    }

    public boolean setFoodPointsUsed(@Nonnull ItemStack stack, int foodAmount) {
        boolean fullyConsumed = true;
        if (this.isMultiuse(stack)) {
            CompoundNBT instr = Instructions.get((ItemStack)stack);
            int totalFoodAmount = instr.func_74762_e(_NBT_FOOD_TOTAL);
            instr.func_74768_a(_NBT_FOOD_TOTAL_USED, MathHelper.func_76125_a((int)foodAmount, (int)0, (int)totalFoodAmount));
            fullyConsumed = foodAmount >= totalFoodAmount;
        }
        return fullyConsumed;
    }

    public final int getAvailableFoodPoints(ItemStack stack) {
        int amount;
        if (this.isMultiuse(stack)) {
            amount = this.getTotalFoodPoints(stack) - this.getFoodPointsUsed(stack);
            amount = MathHelper.func_76125_a((int)amount, (int)0, (int)MAX_TOTAL_FOOD_VALUE_ALLOWED);
        } else {
            amount = this.getPortionFoodPoints(stack);
        }
        return amount;
    }

    public int getHealAmount(ItemStack stack) {
        CompoundNBT instr;
        int left;
        int amount = this.getPortionFoodPoints(stack);
        if (this.isMultiuse(stack) && (left = (instr = Instructions.get((ItemStack)stack)).func_74762_e(_NBT_FOOD_TOTAL) - instr.func_74762_e(_NBT_FOOD_TOTAL_USED)) < amount) {
            amount = left;
        }
        return amount;
    }

    protected final float computeSaturationModifierForWarmedFood(ItemStack stack, float modifier, float warmedMultiplier, boolean scaled) {
        IReheatable t_cap;
        if (modifier > 0.0f && (t_cap = this.getTemperatureChangeCapability(stack)) != null && t_cap.isHeated(stack)) {
            modifier *= warmedMultiplier;
            if (scaled) {
                // empty if block
            }
        }
        return modifier;
    }

    public int getItemStackLimit(ItemStack stack) {
        if (this.getFoodPointsUsed(stack) > 0) {
            return 1;
        }
        IReheatable t_cap = this.getTemperatureChangeCapability(stack);
        if (t_cap != null && t_cap.hasBonusTemperature(stack)) {
            return 1;
        }
        return super.getItemStackLimit(stack);
    }

    protected static ItemStack initMultiuseInstance(@Nonnull ItemStack food, int foodTotal, int foodPerUse) {
        CompoundNBT instr = Instructions.createshell((ItemStack)food);
        instr.func_74757_a("XFood", true);
        instr.func_74768_a(_NBT_FOOD_TOTAL, foodTotal);
        if (foodPerUse > 0) {
            instr.func_74768_a(_NBT_FOOD_PER_USE, foodPerUse);
        }
        return food;
    }

    protected static ItemStack createMultiuseInstance(Item item, int amount, int foodTotal, int foodPerUse) {
        ItemStack food = new ItemStack((IItemProvider)item, amount);
        return VfpPantryItem.initMultiuseInstance(food, foodTotal, foodPerUse);
    }

    public ItemStack createInstance(Item item, int amount) {
        boolean flat;
        if (!SharedGlue.isDefined((Item)item)) {
            item = this;
        }
        return !(flat = this.getPreferSingleUseFood()) && this._profile.isCompressible() && this._profile.isEdible() && this._foodPoints > SharedGlue.HEARTY_FOOD_POINTS_THRESHOLD() ? VfpPantryItem.createMultiuseInstance(item, amount, this._foodPoints, this.getDefaultPortionFoodPoints()) : new ItemStack((IItemProvider)item, amount);
    }

    public void func_77622_d(ItemStack stack, @Nullable World unused0, @Nullable PlayerEntity player) {
        this.onCookedOrCrafted(stack);
    }

    public void onCookedOrCrafted(ItemStack food) {
        if (!this._profile.isCompressible() || !this._profile.isEdible() || Instructions.hasXFoodFlag((ItemStack)food)) {
            return;
        }
        boolean flat = this.getPreferSingleUseFood();
        if (!flat && this._foodPoints > SharedGlue.HEARTY_FOOD_POINTS_THRESHOLD()) {
            VfpPantryItem.initMultiuseInstance(food, this._foodPoints, this.getDefaultPortionFoodPoints());
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        boolean show = super.showDurabilityBar(stack);
        if (this.isMultiuse(stack)) {
            CompoundNBT instr = Instructions.get((ItemStack)stack);
            show = instr.func_74762_e(_NBT_FOOD_TOTAL_USED) > 0;
        }
        return show;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        CompoundNBT instr;
        double durability = super.getDurabilityForDisplay(stack);
        if (this.isMultiuse(stack) && (instr = Instructions.get((ItemStack)stack)).func_74762_e(_NBT_FOOD_TOTAL_USED) > 0) {
            double foodUsed = instr.func_74769_h(_NBT_FOOD_TOTAL_USED);
            double foodTotal = instr.func_74769_h(_NBT_FOOD_TOTAL);
            durability = foodUsed / foodTotal;
        }
        return durability;
    }

    protected boolean canConsume(ItemStack held, World world, PlayerEntity player) {
        return player.func_71043_e(this.getBaseFood().func_221468_d());
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack held = player.func_184586_b(hand);
        ActionResultType r = ActionResultType.FAIL;
        if (this.isEdible(held) && (ItemStacks.getSize((ItemStack)held) == 1 || !this.isMultiuse(held)) && this.canConsume(held, world, player)) {
            r = ActionResultType.CONSUME;
            if (this.isInstaConsume(held)) {
                held = this.func_77654_b(held, world, (LivingEntity)player);
            } else {
                player.func_184598_c(hand);
            }
        }
        return new ActionResult(r, (Object)held);
    }

    protected final void onPortionConsumed(ItemStack eaten, int foodAmount, float foodSaturation, World world, PlayerEntity player) {
        foodAmount = this.getUseHealAmount(eaten, foodAmount);
        foodSaturation = this.getUseSaturationModifier(eaten, foodSaturation);
        FoodPortion.onConsumed(eaten, foodAmount, foodSaturation, world, player);
        Effects.playFoodConsumed((World)world, (PlayerEntity)player);
        this.addUsedStat(player);
    }

    protected ItemStack onItemConsumedFully(ItemStack original, ItemStack remaining, World world, PlayerEntity player) {
        ItemStack container;
        if (this._returnContainerOnConsumed && original.func_77973_b().hasContainerItem(original) && !ItemStacks.isEmpty((ItemStack)(container = original.func_77973_b().getContainerItem(original)))) {
            remaining = VfpPantryItem.returnOrDropContainer((ItemStack)remaining, (PlayerEntity)player, (ItemStack)container);
        }
        return remaining;
    }

    public ItemStack func_77654_b(ItemStack food, World world, LivingEntity consumer) {
        ItemStack remaining = food;
        PlayerEntity player = SharedGlue.getPlayerOrNull((Entity)consumer);
        if (player == null) {
            remaining = super.func_77654_b(food, world, consumer);
        } else {
            boolean consumedFully = false;
            ItemStack original = ItemStacks.copy1((ItemStack)food);
            if (!this.isMultiuse(food)) {
                this.onPortionConsumed(food, this.getHealAmount(food), this.getSaturationModifier(food), world, player);
                if (SharedGlue.getPlayerInSurvival((PlayerEntity)player) && ItemStacks.decrBy((ItemStack)food, (int)1)) {
                    remaining = ItemStack.field_190927_a;
                }
                consumedFully = true;
            } else {
                int useAmount;
                int maxFoodAmount = MAX_PORTION_FOOD_AMOUNT;
                int minFoodAmount = this.getPortionFoodPoints(food);
                boolean needSaturation = false;
                if (player.func_110143_aJ() < player.func_110138_aP() * 0.75f) {
                    maxFoodAmount *= 2;
                    needSaturation = true;
                }
                if ((useAmount = MAX_FOOD_POINTS_ALLOWED - player.func_71024_bL().func_75116_a()) > maxFoodAmount) {
                    useAmount = maxFoodAmount;
                }
                if (useAmount < minFoodAmount && (needSaturation || useAmount > 3)) {
                    useAmount = minFoodAmount;
                }
                int foodUsed = this.getFoodPointsUsed(food);
                int foodLeft = this.getTotalFoodPoints(food) - (foodUsed + useAmount);
                if (foodLeft <= 0) {
                    this.onPortionConsumed(food, useAmount += foodLeft, this.getSaturationModifier(food), world, player);
                    if (SharedGlue.getPlayerInSurvival((PlayerEntity)player) && ItemStacks.decrBy((ItemStack)food, (int)1)) {
                        remaining = ItemStack.field_190927_a;
                    }
                    consumedFully = true;
                } else {
                    this.onPortionConsumed(food, useAmount, this.getSaturationModifier(food), world, player);
                    if (SharedGlue.isaServerWorld((IWorldReader)world)) {
                        this.setFoodPointsUsed(remaining, foodUsed + useAmount);
                    }
                }
            }
            this.onFoodEaten(original, remaining, world, player);
            if (consumedFully) {
                remaining = this.onItemConsumedFully(original, remaining, world, player);
            }
        }
        return remaining;
    }

    protected final void addWellFedEffectForHappyFood(ItemStack eaten, PlayerEntity player, int duration_secs) {
        IReheatable t_cap = this.getTemperatureChangeCapability(eaten);
        boolean golden = VfpUtils.isGoldGrade(eaten);
        if (golden || t_cap != null && t_cap.isHeated(eaten)) {
            Potions.addPotionEffect((LivingEntity)player, (Effect)VfpPotions.WELL_STUFFED, (int)duration_secs, (int)(golden ? 1 : 0), (boolean)false, (boolean)false);
        }
    }

    protected void applyEatHappyFoodEffect(ItemStack eaten, PlayerEntity player) {
        Item item = eaten.func_77973_b();
        if (item instanceof IHappyFood || item.func_206844_a((ITag)RID.Tags.HAPPY_FOODS)) {
            SharedGlue.Potion_saturation.func_76394_a((LivingEntity)player, 1);
        }
    }

    public static final void addLongSaturation(PlayerEntity player, int duration_secs) {
        int satLevel = 0;
        if (player.func_110143_aJ() < player.func_110138_aP()) {
            ++satLevel;
        }
        Potions.addStubbornPotionEffect((LivingEntity)player, (Effect)SharedGlue.Potion_saturation, (int)duration_secs, (int)satLevel, (boolean)false, (boolean)false);
    }

    protected void addLongSaturation(ItemStack eaten, PlayerEntity player) {
        VfpPantryItem.addLongSaturation(player, this.getPotionEffectDurationSecs(true));
    }

    protected float isHarmfulIfEatenDirectly(ItemStack original, PlayerEntity player) {
        float chance = 0.0f;
        if (this._profile.isHarmfulIfEatenDirectly()) {
            chance = this._profile.isHarmfulIfEatenDirectlyAlways() ? 1.0f : 0.25f;
        }
        return chance;
    }

    protected void applyPotionEffectsOnConsumed(ItemStack original, ItemStack remaining, World world, PlayerEntity player) {
        for (Pair effectchance : this.getBaseFood().func_221464_f()) {
            if (effectchance.getFirst() == null || !(player.func_70681_au().nextFloat() < ((Float)effectchance.getSecond()).floatValue())) continue;
            player.func_195064_c(new EffectInstance((EffectInstance)effectchance.getFirst()));
        }
        float harmful = this.isHarmfulIfEatenDirectly(original, player);
        if (harmful > 0.0f) {
            if (harmful >= 1.0f || player.func_70681_au().nextFloat() < harmful) {
                Potions.addPotionEffects((LivingEntity)player, (Potion)VfpPotions.FOOD_POISONING);
            }
        } else {
            this.applyEatHappyFoodEffect(original, player);
        }
    }

    protected void onFoodEaten(ItemStack original, ItemStack remaining, World world, PlayerEntity player) {
        if (SharedGlue.isaServerWorld((IWorldReader)world)) {
            this.applyPotionEffectsOnConsumed(original, remaining, world, player);
            ItemSupport.noteItemConsumed((PlayerEntity)player, (ItemStack)original);
        }
    }

    protected void addPotionEffect(Effect potion, int duration_secs, int amplifier, float chance) {
        Potions.addPotionEffect((Item)this, (Effect)potion, (int)duration_secs, (int)amplifier, (float)chance);
    }

    public float getCompostChance(@Nonnull Item item) {
        return item != this || this._profile.isLiquid() ? 0.0f : (this instanceof ITiny ? 0.15f : 0.65f);
    }

    public boolean isHiddenByDefault() {
        return VfpConfig.getInstance().showAllItemsInUI() ? false : super.isHiddenByDefault();
    }

    protected void addFoodPointsInformation_(ItemStack stack, World world, List<ITextComponent> tooltip, boolean advanced) {
        IReheatable t_cap;
        if (this.isMultiuse(stack)) {
            int availPts = this.getAvailableFoodPoints(stack);
            int usesLeft = MathHelper.func_76123_f((float)((float)availPts / (float)this.getPortionFoodPoints(stack)));
            tooltip.add((ITextComponent)new TranslationTextComponent("multiuse.food.left.advanced", new Object[]{usesLeft, availPts}));
        }
        if ((t_cap = this.getTemperatureChangeCapability(stack)) != null) {
            t_cap.addBonusTemperatureInformation(stack, world, tooltip);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected final void addDebugInformation(ItemStack stack, List<ITextComponent> tooltip, ITooltipFlag flags) {
        if (this._debugFlag && this.isEdible(stack)) {
            IFormattableTextComponent displayString = new StringTextComponent("VFP: ").func_230529_a_((ITextComponent)new StringTextComponent("H: ").func_240699_a_(_BLUE)).func_230529_a_((ITextComponent)new StringTextComponent("" + this.getHealAmount(stack) + ", ")).func_230529_a_((ITextComponent)new StringTextComponent("S: ").func_240699_a_(_BLUE)).func_230529_a_((ITextComponent)new StringTextComponent(String.format("%.3f", Float.valueOf(this.getSaturationModifier(stack)))));
            tooltip.add((ITextComponent)displayString);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flags) {
        if (ItemStacks.isFlaggedAsSample((ItemStack)stack)) {
            Tooltips.addSampleTipLine(tooltip);
        }
        this.addFoodPointsInformation_(stack, world, tooltip, flags.func_194127_a() || this._debugFlag);
        super.func_77624_a(stack, world, tooltip, flags);
        this.addDebugInformation(stack, tooltip, flags);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || !oldStack.func_77969_a(newStack);
    }

    protected static final String _toString(ItemStack stack) {
        VfpPantryItem item;
        StringBuilder sb = new StringBuilder(50);
        sb.append(String.valueOf(stack));
        if (stack.func_77973_b() instanceof VfpPantryItem && (item = (VfpPantryItem)stack.func_77973_b()).isMultiuse(stack)) {
            sb.append("[");
            sb.append(item.getFoodPointsUsed(stack));
            sb.append("/");
            sb.append(item.getTotalFoodPoints(stack));
            sb.append("]");
        }
        return sb.toString();
    }
}

