/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.Whatis;
import org.jwaresoftware.mcmods.lib.api.ICompostable;
import org.jwaresoftware.mcmods.lib.impl.block.BlockBase;
import org.jwaresoftware.mcmods.lib.impl.block.ItemBlockBase;
import org.jwaresoftware.mcmods.vfp.common.VfpAware;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;

public class VfpPlainBlock
extends BlockBase
implements VfpAware {
    protected final VfpProfile _profile;

    public VfpPlainBlock(@Nonnull VfpProfile profile, @Nullable AbstractBlock.Properties bp) {
        super(profile.fmlid(), bp, false);
        Validate.isTrue((boolean)profile.isBlock(), (String)"A VFP block's type MUST align as a Block", (Object[])new Object[0]);
        this._profile = profile;
    }

    protected VfpPlainBlock(@Nonnull VfpProfile profile, Material likeMaterial) {
        super(profile.fmlid(), likeMaterial);
        Validate.isTrue((boolean)profile.isBlock(), (String)"A VFP block's type MUST align as a Block", (Object[])new Object[0]);
        this._profile = profile;
    }

    protected VfpPlainBlock(@Nonnull VfpProfile profile, Block likeBlock) {
        this(profile, AbstractBlock.Properties.func_200950_a((AbstractBlock)likeBlock));
    }

    public final String itemid_prefix() {
        return this._profile.itemid_prefix();
    }

    @Override
    public final VfpProfile vfplink() {
        return this._profile;
    }

    public VfpPlainBlock autoregister() {
        VfpUtils.autoregisterBlock((Block)this, this._profile);
        return this;
    }

    public final <T extends VfpPlainBlock> T autoregister(Class<T> of) {
        return (T)((VfpPlainBlock)of.cast(this.autoregister()));
    }

    public BlockItem makeItemBlock(@Nonnull Block block, Item.Properties ip) {
        return this instanceof ICompostable ? new VfpCompostableBlockItem(block, ip) : new VfpBlockItem(block, ip);
    }

    public static class VfpCompostableBlockItem
    extends VfpBlockItem
    implements ICompostable {
        public VfpCompostableBlockItem(Block block, Item.Properties ip) {
            super(block, ip);
        }

        public VfpCompostableBlockItem(Block block, @Nonnull String oid, Item.Properties ip) {
            super(block, oid, ip);
        }

        public float getCompostChance(Item blockitem) {
            Block b = this.func_179223_d();
            if (!SharedGlue.isDefined((Block)b)) {
                return 0.0f;
            }
            if (b instanceof ICompostable) {
                return ((ICompostable)b).getCompostChance(blockitem);
            }
            if (Whatis.isLikelyNotShownAsItem((Object)b)) {
                return 0.85f;
            }
            return blockitem == this ? this.getDefaultCompostChance(this) : -1.0f;
        }

        protected float getDefaultCompostChance(VfpBlockItem blockitem) {
            return super.getCompostChance((Item)blockitem);
        }
    }

    public static class VfpBlockItem
    extends ItemBlockBase
    implements VfpAware {
        public VfpBlockItem(Block block, @Nonnull String oid, Item.Properties ip) {
            super(block, oid, ip != null ? ip : new Item.Properties().func_200916_a(SharedGlue.CreativeTabs_misc));
            if (SharedGlue.isDefined((Block)block)) {
                Validate.isInstanceOf(VfpAware.class, (Object)block);
            }
        }

        public VfpBlockItem(Block block, Item.Properties ip) {
            super(block, ip != null ? ip : new Item.Properties().func_200916_a(SharedGlue.CreativeTabs_misc));
            Validate.isInstanceOf(VfpAware.class, (Object)block);
        }

        protected final <T extends VfpAware> VfpAware getVfpBlock(Class<T> of) {
            return (VfpAware)of.cast(this.func_179223_d());
        }

        @Override
        public VfpProfile vfplink() {
            return this.getVfpBlock(VfpAware.class).vfplink();
        }

        public final String itemid_prefix() {
            return this.vfplink().itemid_prefix();
        }
    }
}

