/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.OneXp;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;

public class VfpProfileSupport
implements VfpProfile {
    public static final long _NONE = 0L;
    public static final long _BLOCK = 1L;
    public static final long _PANTRY = 16L;
    public static final long _EDIBLE = 256L;
    public static final long _HARMFUL = 4096L;
    public static final long _HARMFUL_LITE = 65536L;
    public static final long _COMPRESS = 0x100000L;
    public static final long _DENSE = 0x1000000L;
    public static final long _PACKABLE = 0x10000000L;
    public static final long _PACKAGED = 0x100000000L;
    public static final long _GRADEABLE = 0x1000000000L;
    public static final long _DYNAMIC = 0x10000000000L;
    public static final long _LIQUID = 0x100000000000L;
    public static final long _SUGAR_HIGH = 0x1000000000000L;
    static final Map<ResourceLocation, Float> _XP_VALUES = new HashMap<ResourceLocation, Float>(2001, 0.85f);
    private String _fmlid;
    private long _attrs;
    private float _newXp = OneXp.Never.value();
    private VfpCapacity _capty = VfpCapacity.NONE;

    public static final String normalize(@Nonnull String name) {
        return name.toLowerCase(Locale.ROOT);
    }

    public static final void saveXp(VfpProfile profile) {
        float xp = profile.craftingXp();
        if (xp > 0.0f) {
            _XP_VALUES.put(new ResourceLocation(profile.modid(), profile.fmlid()), Float.valueOf(xp));
        }
    }

    public VfpProfileSupport() {
    }

    public VfpProfileSupport(String id, boolean block) {
        this._fmlid = id;
        this._attrs = block ? (this._attrs |= 1L) : (this._attrs &= 0xFFFFFFFFFFFFFFFEL);
    }

    public VfpProfileSupport(String id, long definition) {
        this._fmlid = id;
        this._attrs = definition;
    }

    public VfpProfileSupport(String id, VfpProfileSupport from) {
        this._fmlid = id;
        this._attrs = from._attrs;
        this._newXp = from._newXp;
        this._capty = from._capty;
    }

    public VfpProfileSupport(String id, VfpProfileSupport from, long additional) {
        this._fmlid = id;
        this._attrs = from._attrs | additional;
        this._newXp = from._newXp;
        this._capty = from._capty;
    }

    @Override
    public VfpProfile derivative(VfpVariant variant) {
        VfpProfileSupport copy = new VfpProfileSupport(variant.fmlid(), this);
        if (variant.capacity() != null) {
            copy.setCapacity(variant.capacity());
        }
        if (this.isEdible() && !LikeFood.something(variant.food())) {
            copy.setEdible(false);
        }
        return copy;
    }

    public final long attrmask() {
        return this._attrs;
    }

    public final String fullid() {
        return this.modid() + ":" + this.fmlid();
    }

    @Override
    public String fmlid() {
        return this._fmlid;
    }

    @Override
    public boolean isBlock() {
        return (this._attrs & 1L) == 1L;
    }

    public void setTypeBlock() {
        this._attrs |= 1L;
    }

    @Override
    public boolean isItem() {
        return !this.isBlock();
    }

    public void setTypeItem() {
        this._attrs &= 0xFFFFFFFFFFFFFFFEL;
    }

    @Override
    public boolean isPantryStoreable() {
        return (this._attrs & 0x10L) == 16L;
    }

    public void setPantryStoreable(boolean flag) {
        this._attrs = flag ? (this._attrs |= 0x10L) : (this._attrs &= 0xFFFFFFFFFFFFFFEFL);
    }

    @Override
    public boolean isEdible() {
        return (this._attrs & 0x100L) == 256L;
    }

    public void setEdible(boolean flag) {
        this._attrs = flag ? (this._attrs |= 0x100L) : (this._attrs &= 0xFFFFFFFFFFFFFEFFL);
    }

    @Override
    public boolean isHarmfulIfEatenDirectly() {
        return (this._attrs & 0x1000L) == 4096L || (this._attrs & 0x10000L) == 65536L;
    }

    @Override
    public boolean isHarmfulIfEatenDirectlyAlways() {
        return (this._attrs & 0x1000L) == 4096L;
    }

    public void setHarmfulIfEatenDirectly(boolean flag, boolean always) {
        this._attrs = always ? (flag ? (this._attrs |= 0x1000L) : (this._attrs &= 0xFFFFFFFFFFFFEFFFL)) : (flag ? (this._attrs |= 0x10000L) : (this._attrs &= 0xFFFFFFFFFFFEFFFFL));
    }

    @Override
    public boolean isEmptyCalorieSugarHigh() {
        return (this._attrs & 0x1000000000000L) == 0x1000000000000L;
    }

    public void setEmptyCalorieSugarHigh(boolean flag) {
        this._attrs = flag ? (this._attrs |= 0x1000000000000L) : (this._attrs &= 0xFFFEFFFFFFFFFFFFL);
    }

    @Override
    public boolean isCompressible() {
        return (this._attrs & 0x100000L) == 0x100000L;
    }

    public void setCompressible(boolean flag) {
        this._attrs = flag ? (this._attrs |= 0x100000L) : (this._attrs &= 0xFFFFFFFFFFEFFFFFL);
    }

    @Override
    public boolean isDynamic() {
        return (this._attrs & 0x10000000000L) == 0x10000000000L;
    }

    public void setDynamic(boolean flag) {
        this._attrs = flag ? (this._attrs |= 0x10000000000L) : (this._attrs &= 0xFFFFFEFFFFFFFFFFL);
    }

    @Override
    public boolean isDense() {
        return (this._attrs & 0x1000000L) == 0x1000000L;
    }

    public void setDense(boolean flag) {
        this._attrs = flag ? (this._attrs |= 0x1000000L) : (this._attrs &= 0xFFFFFFFFFEFFFFFFL);
    }

    @Override
    public boolean isPackageable() {
        return (this._attrs & 0x10000000L) == 0x10000000L;
    }

    public void setPackageable(boolean flag) {
        this._attrs = flag ? (this._attrs |= 0x10000000L) : (this._attrs &= 0xFFFFFFFFEFFFFFFFL);
    }

    @Override
    public boolean isPackaged() {
        return (this._attrs & 0x100000000L) == 0x100000000L;
    }

    public void setPackaged(boolean flag) {
        this._attrs = flag ? (this._attrs |= 0x100000000L) : (this._attrs &= 0xFFFFFFFEFFFFFFFFL);
    }

    @Override
    public boolean isGradeable() {
        return (this._attrs & 0x1000000000L) == 0x1000000000L;
    }

    public void setGradeable(boolean flag) {
        this._attrs = flag ? (this._attrs |= 0x1000000000L) : (this._attrs &= 0xFFFFFFEFFFFFFFFFL);
    }

    @Override
    public boolean isLiquid() {
        return (this._attrs & 0x100000000000L) == 0x100000000000L;
    }

    public void setLiquid(boolean flag) {
        this._attrs = flag ? (this._attrs |= 0x100000000000L) : (this._attrs &= 0xFFFFEFFFFFFFFFFFL);
    }

    @Override
    public float craftingXp() {
        return this._newXp;
    }

    public void setCraftingXp(float xp) {
        this._newXp = xp;
    }

    @Override
    public VfpCapacity capacity() {
        return this._capty;
    }

    public void setCapacity(@Nonnull VfpCapacity capty) {
        this._capty = capty == null ? VfpCapacity.NONE : capty;
    }

    public VfpCapacity compressedCapacity() {
        return null;
    }
}

