/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.meals;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jwaresoftware.mcmods.lib.LiquidType;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.IItemPropertyExtender;
import org.jwaresoftware.mcmods.lib.capability.IGradeable;
import org.jwaresoftware.mcmods.lib.capability.ITemperatureChangeable;
import org.jwaresoftware.mcmods.vfp.common.IReheatable;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpLiquidMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.runtime.VfpRewards;

public final class BowlFood
extends VfpLiquidMultiItem
implements IReheatable,
IItemPropertyExtender {
    private static boolean _GOT_ROASTED_EGGPLANT = false;
    private static boolean _GOT_EARTHINESS = false;
    private static BowlFood[] INSTANCES;

    static final LikeFood plusBread(LikeFood from, boolean flatbread) {
        return new LikeFood(from.name() + "+bread", -1, from, flatbread ? LikeFood.flouronly_bread : LikeFood.sandwich);
    }

    BowlFood(DishDef variant) {
        super((VfpProfile)VfpOid.Heavy_Stew, variant, variant.isSop() ? LiquidType.SOUP : LiquidType.STEW);
        if (variant.isStew() || variant == DishDef.Fish_Chowder || variant == DishDef.Potato_Chowder) {
            this._gid = "stews";
        }
        this.setContainerItem(null);
        this.autoregister();
    }

    @Override
    protected int getDefaultPortionFoodPoints() {
        return LikeFood.mushroom_stew.healAmount();
    }

    @Override
    protected Item getNewEmptyContainer() {
        return Items.field_151054_z;
    }

    @Override
    protected VfpCapacity getItemMaxStackSize() {
        return VfpConfig.getInstance().maxSoupsStackCapacity(super.getItemMaxStackSize());
    }

    @Nonnull
    private DishDef getDish() {
        return (DishDef)this._variant;
    }

    @Override
    public UseAction func_77661_b(ItemStack bowl) {
        DishDef dish = this.getDish();
        return dish.isCombo() ? UseAction.EAT : (dish.isSop() ? UseAction.DRINK : UseAction.EAT);
    }

    @Override
    protected boolean getPreferSingleUseFood() {
        boolean flat;
        boolean bl = flat = !this.getDish().isMultiuse() || VfpConfig.getInstance().preferSingleUseFood("stews", true);
        if (flat && this.getDish().food().isOversized()) {
            flat = false;
        }
        return flat;
    }

    @Override
    public float getSaturationModifier(ItemStack bowl) {
        float baseAmount = super.getSaturationModifier(bowl);
        DishDef dish = this.getDish();
        if (dish.isGradeable() && VfpUtils.isGoldGrade(bowl)) {
            baseAmount *= 1.2f;
        }
        float warmMultiplier = 2.0f;
        if (dish.isSop() || dish.isMultiuse() && this.isMultiuse(bowl)) {
            warmMultiplier = 1.5f;
        }
        return this.computeSaturationModifierForWarmedFood(bowl, baseAmount, warmMultiplier, true);
    }

    public int getUseHealAmount(ItemStack bowl, int foodPoints) {
        DishDef dish = this.getDish();
        if (dish.isGradeable() && VfpUtils.isGoldGrade(bowl)) {
            foodPoints = Math.min(MAX_FOOD_POINTS_ALLOWED, MathHelper.func_76123_f((float)((float)foodPoints * 1.2f)));
        }
        return foodPoints;
    }

    @Override
    public int getTemperatureModifier(ItemStack bowl) {
        int warmMultiplier = 1;
        DishDef dish = this.getDish();
        if (!dish.isSop()) {
            warmMultiplier = 3;
        } else if (dish.isCombo()) {
            warmMultiplier = 2;
        }
        return warmMultiplier;
    }

    @Override
    protected void applyEatHappyFoodEffect(ItemStack eaten, PlayerEntity player) {
        DishDef dish = this.getDish();
        if (!this.isMultiuse(eaten) && dish.food().feedsWell()) {
            this.addWellFedEffectForHappyFood(eaten, player, 180);
        } else {
            super.applyEatHappyFoodEffect(eaten, player);
        }
    }

    public void func_77663_a(ItemStack bowl, World world, Entity holder, int slotindex, boolean selected) {
        this.onUpdateTickBonusTemperature(bowl, world, holder, slotindex, selected);
    }

    public boolean canPlayerHeat(ItemStack bowl) {
        return true;
    }

    @Override
    public void onCookedOrCrafted(ItemStack bowl) {
        ITemperatureChangeable.UsedEffect e = this.onCreateCheckBonusTemperature(bowl);
        super.onCookedOrCrafted(bowl);
        if (ITemperatureChangeable.UsedEffect.HEATED.equals((Object)e)) {
            this.setHeated(bowl);
        }
    }

    @Override
    public void func_77622_d(ItemStack bowl, @Nullable World world, @Nullable PlayerEntity player) {
        super.func_77622_d(bowl, world, player);
        if (this.isHeated(bowl) && player != null) {
            player.func_195066_a(VfpObj.Heated_Food_stat);
        }
    }

    @Override
    public float getCompostChance(Item what) {
        return what == this ? (this.getDish().isCombo() ? 1.0f : (this.getDish().isSop() ? 0.25f : 0.65f)) : -1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerPropertyOverrides() {
        ITemperatureChangeable.TemperaturePropertyGetter.forHeatable((Item)this);
        if (this.getDish().isGradeable()) {
            IGradeable.QualityGradePropertyGetter.addTo((Item)this);
        }
    }

    @Override
    protected boolean showSubItem(VfpVariant variant, ItemGroup forTab, ItemGroup pickedTab) {
        boolean show = true;
        if (!VfpConfig.getInstance().showAllItemsInUI()) {
            DishDef dish = this.getDish();
            if (dish == DishDef.Eggplant_Saltfish_Stew || dish == DishDef.Eggplant_Saltfish_Stew_Combo) {
                show = _GOT_ROASTED_EGGPLANT;
            } else if (dish == DishDef.Earthy_Stew) {
                show = _GOT_EARTHINESS;
            }
        }
        return show;
    }

    private static final ItemStack newBowl(int amount, DishDef dish) {
        BowlFood instance = INSTANCES[dish.index()];
        boolean flat = instance.getPreferSingleUseFood();
        ItemStack a_bowl = !flat && dish.isMultiuse() ? BowlFood.createMultiuseInstance((Item)instance, amount, dish.food().healAmount(), LikeFood.mushroom_stew.healAmount()) : new ItemStack((IItemProvider)instance, amount);
        return a_bowl;
    }

    @Override
    public ItemStack createInstance(Item item, int amount) {
        if (item != this) {
            return ItemStack.field_190927_a;
        }
        return BowlFood.newBowl(amount, this.getDish());
    }

    static final void makeObjects() {
        if (INSTANCES == null) {
            int N = DishDef.VALUES.size();
            INSTANCES = new BowlFood[N];
            for (int i = 0; i < N; ++i) {
                DishDef dishDef = DishDef.VALUES.get(i);
                BowlFood.INSTANCES[dishDef.index()] = new BowlFood(dishDef);
            }
        }
    }

    static final void linkLikeFoods() {
        boolean intermod = VfpConfig.getInstance().includeInterModRecipes();
        _GOT_ROASTED_EGGPLANT = intermod && SharedGlue.ingredientDefined((String)"foods/grilled_eggplants");
        boolean bl = _GOT_EARTHINESS = intermod && SharedGlue.ingredientDefined((String)"foods/wild_potatoes");
        if (INSTANCES != null) {
            LikeFood.gruel.food().item((Item)INSTANCES[DishDef.Basic_Gruel.index()]);
            LikeFood.sop.food().item((Item)INSTANCES[DishDef.Sop.index()]);
            LikeFood.meat_stew.food().item((Item)INSTANCES[DishDef.Ham_Hocks_Stew.index()]);
            LikeFood.fish_chowder.food().item((Item)INSTANCES[DishDef.Fish_Chowder.index()]);
            LikeFood.tato_chowder.food().item((Item)INSTANCES[DishDef.Potato_Chowder.index()]);
            LikeFood.vegetable_stew.food().item((Item)INSTANCES[DishDef.Veggie_Stew.index()]);
            LikeFood.earthy_stew.food().item((Item)INSTANCES[DishDef.Earthy_Stew.index()]);
            LikeFood.acorn_stew.food().item((Item)INSTANCES[DishDef.Acorn_Meat_Stew.index()]);
        }
    }

    static final void setRecipeRewards() {
        if (INSTANCES != null) {
            ArrayList<ItemStack> instances = new ArrayList<ItemStack>(29);
            ItemStack the_bowl = BowlFood.newBowl(1, DishDef.Pumpkin_Pigtail_Stew);
            VfpRewards.addRewardingCraftItem(the_bowl, VfpOid.Heavy_Stew.craftingXp());
            instances.add(the_bowl);
            instances.add(BowlFood.newBowl(1, DishDef.Pumpkin_Pigtail_Stew_Combo));
            the_bowl = BowlFood.newBowl(1, DishDef.Eggplant_Saltfish_Stew);
            VfpRewards.addRewardingCraftItem(the_bowl, VfpOid.Heavy_Stew.craftingXp());
            instances.add(the_bowl);
            instances.add(BowlFood.newBowl(1, DishDef.Eggplant_Saltfish_Stew_Combo));
            the_bowl = BowlFood.newBowl(1, DishDef.Veggie_Stew);
            VfpRewards.addRewardingCraftItem(the_bowl, VfpOid.Heavy_Stew.craftingXp());
            instances.add(the_bowl);
            instances.add(BowlFood.newBowl(1, DishDef.Veggie_Stew_Combo));
            the_bowl = BowlFood.newBowl(1, DishDef.PolarBear_Stew);
            VfpRewards.addRewardingCraftItem(the_bowl, VfpOid.Heavy_Stew.craftingXp());
            instances.add(the_bowl);
            the_bowl = BowlFood.newBowl(1, DishDef.Acorn_Meat_Stew);
            VfpRewards.addRewardingCraftItem(the_bowl, VfpOid.Heavy_Stew.craftingXp());
            instances.add(the_bowl);
            the_bowl = BowlFood.newBowl(1, DishDef.Basic_Gruel);
            VfpRewards.addRewardingCraftItem(the_bowl, VfpOid.Light_Soup.craftingXp());
            instances.add(the_bowl);
            instances.add(BowlFood.newBowl(1, DishDef.Basic_Gruel_Combo));
            the_bowl = BowlFood.newBowl(1, DishDef.Sop);
            instances.add(the_bowl);
            instances.add(BowlFood.newBowl(1, DishDef.Sop_Combo));
            the_bowl = BowlFood.newBowl(1, DishDef.Egg_Sop);
            VfpRewards.addRewardingCraftItem(the_bowl, VfpOid.Light_Soup.craftingXp());
            instances.add(the_bowl);
            instances.add(BowlFood.newBowl(1, DishDef.Egg_Sop_Combo));
            the_bowl = BowlFood.newBowl(1, DishDef.Cave_Stew);
            VfpRewards.addRewardingCraftItem(the_bowl, VfpOid.Heavy_Stew.craftingXp());
            instances.add(the_bowl);
            the_bowl = BowlFood.newBowl(1, DishDef.Earthy_Stew);
            VfpRewards.addRewardingCraftItem(the_bowl, VfpOid.Heavy_Stew.craftingXp());
            instances.add(the_bowl);
            the_bowl = BowlFood.newBowl(1, DishDef.Fish_Chowder);
            VfpRewards.addRewardingCraftItem(the_bowl, VfpOid.Fish_Chowder.craftingXp());
            instances.add(the_bowl);
            the_bowl = BowlFood.newBowl(1, DishDef.Potato_Chowder);
            VfpRewards.addRewardingCraftItem(the_bowl, VfpOid.Potato_Chowder.craftingXp());
            instances.add(the_bowl);
            the_bowl = BowlFood.newBowl(1, DishDef.Ham_Hocks_Stew);
            VfpRewards.addRewardingCraftItem(the_bowl, VfpOid.Heavy_Stew.craftingXp());
            instances.add(the_bowl);
            instances.add(BowlFood.newBowl(1, DishDef.Mushroom_Stew_Combo));
            instances.add(BowlFood.newBowl(1, DishDef.Beetroot_Sop_Combo));
            the_bowl = BowlFood.newBowl(1, DishDef.Fish_Sop);
            instances.add(the_bowl);
            REHEATABLES.addAll(instances);
        }
    }

    static final class DishDef
    extends VfpVariant {
        static final ArrayList<DishDef> VALUES = new ArrayList(53);
        static final DishDef Basic_Gruel = new DishDef("basic_gruel", false, false, LiquidType.BROTH, LikeFood.gruel, Completer.NONE);
        static final DishDef Basic_Gruel_Combo = new DishDef(Basic_Gruel, false, Completer.BREADSLICE);
        static final DishDef Sop = new DishDef("basic_sop", false, false, LiquidType.BROTH, LikeFood.sop, Completer.NONE);
        static final DishDef Sop_Combo = new DishDef(Sop, false, Completer.BREADSLICE);
        static final DishDef Egg_Sop = new DishDef("friedegg_sop", false, false, LiquidType.BROTH, new LikeFood("egg_sop", -1, LikeFood.sop, LikeFood.fried_egg), Completer.NONE);
        static final DishDef Egg_Sop_Combo = new DishDef(Egg_Sop, false, Completer.BREADSLICE);
        static final DishDef Fish_Sop = new DishDef("fish_sop", false, false, LiquidType.BROTH, new LikeFood("fish_sop", -1, LikeFood.sop, LikeFood.fish_sausage), Completer.NONE);
        static final DishDef Veggie_Stew = new DishDef("veggie_stew", false, true, null, LikeFood.vegetable_stew, Completer.NONE);
        static final DishDef Veggie_Stew_Combo = new DishDef(Veggie_Stew, false, false, Completer.FLATBREAD);
        static final DishDef Acorn_Meat_Stew = new DishDef("acorn_meat_stew", false, true, null, LikeFood.acorn_stew, Completer.NONE);
        static final DishDef Cave_Stew = new DishDef("cave_stew", false, false, null, LikeFood.rabbit_stew, Completer.NONE);
        static final DishDef Earthy_Stew = new DishDef("earthy_stew", true, false, null, LikeFood.earthy_stew, Completer.NONE);
        static final DishDef Pumpkin_Pigtail_Stew = new DishDef("pumpkin_pigtail_stew", false, true, null, LikeFood.vegetable_stew, Completer.NONE);
        static final DishDef Pumpkin_Pigtail_Stew_Combo = new DishDef(Pumpkin_Pigtail_Stew, false, Completer.FLATBREAD);
        static final DishDef Eggplant_Saltfish_Stew = new DishDef("eggplant_saltfish_stew", false, true, null, LikeFood.vegetable_stew, Completer.NONE);
        static final DishDef Eggplant_Saltfish_Stew_Combo = new DishDef(Eggplant_Saltfish_Stew, false, Completer.FLATBREAD);
        static final DishDef Ham_Hocks_Stew = new DishDef("ham_hocks_stew", true, false, null, LikeFood.meat_stew, Completer.NONE);
        static final DishDef PolarBear_Stew = new DishDef("polar_bear_stew", true, true, null, LikeFood.meat_stew, Completer.NONE);
        static final DishDef Fish_Chowder = new DishDef("fish_chowder", false, true, LiquidType.SOUP, LikeFood.fish_chowder, Completer.NONE);
        static final DishDef Potato_Chowder = new DishDef("potato_chowder", false, false, LiquidType.SOUP, LikeFood.tato_chowder, Completer.NONE);
        static final DishDef Mushroom_Stew_Combo = new DishDef("mushroom_stew_combo", false, false, null, BowlFood.plusBread(LikeFood.mushroom_stew, false), Completer.BREADSLICE);
        static final DishDef Beetroot_Sop_Combo = new DishDef("beetroot_soup_combo", false, false, LiquidType.SOUP, BowlFood.plusBread(LikeFood.beetsoup, false), Completer.BREADSLICE);
        private final boolean _multiuse;
        private final LiquidType _lqtype;
        private final boolean _graded;

        DishDef(String id, boolean multi, boolean graded, @Nonnull LiquidType lqtype, @Nullable LikeFood like, @Nullable Completer addon) {
            super(VALUES.size(), id, like, (Object)addon, SharedGlue.CreativeTabs_food);
            this._multiuse = multi;
            this._lqtype = lqtype == null ? LiquidType.STEW : lqtype;
            this._graded = graded;
            VALUES.add(this);
        }

        DishDef(String id, boolean multi, boolean graded, @Nullable LiquidType lqtype, @Nullable Completer addon) {
            this(id, multi, graded, lqtype, null, addon);
        }

        DishDef(DishDef from, boolean multi, boolean graded, Completer addon) {
            this(from.fmlid() + "_combo", multi, graded, from._lqtype, BowlFood.plusBread(from.food(), addon == Completer.FLATBREAD), addon);
        }

        DishDef(DishDef from, boolean multi, Completer addon) {
            this(from, multi, false, addon);
        }

        final boolean isMultiuse() {
            return this._multiuse;
        }

        final boolean isGradeable() {
            return this._graded;
        }

        final boolean isSop() {
            return this._lqtype == LiquidType.BROTH;
        }

        final boolean isStew() {
            return this._lqtype == LiquidType.STEW;
        }

        @Nullable
        Completer mealCompleter() {
            return this.datadata(Completer.class);
        }

        final boolean isCombo() {
            return this.mealCompleter() != Completer.NONE;
        }
    }

    static enum Completer {
        NONE,
        RICE,
        FLATBREAD,
        BREADSLICE,
        PASTA,
        FRIES,
        PLANTAIN,
        MASH,
        BISCUIT;

    }
}

