/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.meals;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.IVariant;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;

public final class Tatoes
extends VfpPantryMultiItem
implements IVariant {
    static VfpVariant[] VARIANT_ARRAY = new VfpVariant[]{new VfpVariant(0, "stuffed_potato", LikeFood.stuffed_potato), new VfpVariant(1, "stuffed_potato_egg", LikeFood.overstuffed_potato), new VfpVariant(2, "stuffed_potato_shroom", LikeFood.overstuffed_potato), new VfpVariant(3, "stuffed_potato_redmeat", LikeFood.overstuffed_potato), new VfpVariant(4, "stuffed_potato_poultry", LikeFood.overstuffed_potato), new VfpVariant(5, "stuffed_potato_spam", LikeFood.overstuffed_potato), new VfpVariant(6, "stuffed_potato_pork", LikeFood.overstuffed_potato), new VfpVariant(7, "stuffed_potato_fish", LikeFood.overstuffed_potato), new VfpVariant(8, "stuffed_potato_cheese", LikeFood.overstuffed_potato), new VfpVariant(9, "stuffed_potato_veggie", LikeFood.overstuffed_potato), new VfpVariant(10, "stuffed_potato_muscle_egg", new LikeFood("muscle_tato++", -1, LikeFood.overstuffed_potato, LikeFood.muscle_boost))};
    private static final int _WELL_STUFFED_META = 0;
    private static final int _FISH_OVERSTUFFED_META = 7;
    private static final int _MUSCLE_STUFFED_META = 10;
    private static Tatoes[] INSTANCES;

    Tatoes(VfpVariant variant) {
        super((VfpProfile)VfpOid.Tatoes, false, variant);
        this.autoregister();
    }

    public final String varid() {
        return this.getVariant().name();
    }

    @Override
    protected int getDefaultPortionFoodPoints() {
        return LikeFood.buttered_potato.healAmount();
    }

    @Override
    protected boolean getPreferSingleUseFood() {
        boolean flat = VfpConfig.getInstance().preferSingleUseFood("stuffed_potatoes", false);
        if (flat && this._variant.food().isOversized()) {
            flat = false;
        }
        return flat;
    }

    public final List<ItemStack> copyOfAllVariantMembers() {
        ArrayList<ItemStack> all = new ArrayList<ItemStack>(INSTANCES.length + 2);
        for (Tatoes tato : INSTANCES) {
            all.add(tato.createInstance((Item)tato));
        }
        return all;
    }

    @Override
    public float getCompostChance(Item what) {
        return what == this ? 0.85f : -1.0f;
    }

    @Override
    protected void onFoodEaten(ItemStack eaten, ItemStack remaining, World world, PlayerEntity player) {
        if (SharedGlue.isaServerWorld((IWorldReader)world) && eaten.func_77973_b() == INSTANCES[10]) {
            Potions.onMuscleFoodEaten((LivingEntity)player, (int)(this.isMultiuse(eaten) ? 1 : -1));
        }
        super.onFoodEaten(eaten, remaining, world, player);
    }

    private static final ItemStack newTatoFood(int amount, int index) {
        Tatoes instance = INSTANCES[index];
        boolean flat = instance.getPreferSingleUseFood();
        VfpVariant variant = VARIANT_ARRAY[index];
        ItemStack stuffed_tato = flat || variant.food().healAmount() < SharedGlue.HEARTY_FOOD_POINTS_THRESHOLD() ? new ItemStack((IItemProvider)instance, amount) : Tatoes.createMultiuseInstance((Item)instance, amount, variant.food().healAmount(), LikeFood.buttered_potato.healAmount());
        return stuffed_tato;
    }

    @Override
    public ItemStack createInstance(Item item, int amount) {
        if (!SharedGlue.isDefined((Item)item)) {
            item = this;
        }
        return Tatoes.newTatoFood(amount, ((Tatoes)item)._variant.index());
    }

    static final void makeObjects() {
        if (INSTANCES == null) {
            INSTANCES = new Tatoes[VARIANT_ARRAY.length];
            for (int i = 0; i < INSTANCES.length; ++i) {
                Tatoes.INSTANCES[i] = new Tatoes(VARIANT_ARRAY[i]);
            }
        }
    }

    static final void linkLikeFoods() {
        if (INSTANCES != null) {
            LikeFood.buttered_potato.food().item(Items.field_151168_bH);
            LikeFood.stuffed_potato.food().item(Tatoes.wellstuffed());
            LikeFood.overstuffed_potato.food().item(Tatoes.fishstuffed());
        }
    }

    public static final ItemStack wellstuffed() {
        return Tatoes.newTatoFood(1, 0);
    }

    public static final ItemStack fishstuffed() {
        return Tatoes.newTatoFood(1, 7);
    }
}

