/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.misc;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.MinecraftForge;
import org.jwaresoftware.mcmods.lib.BrewEffect;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.mod.IModRuntime;
import org.jwaresoftware.mcmods.lib.loot.Loot;
import org.jwaresoftware.mcmods.vfp.agents.JuJuExtensions;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpFertilizerItem;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.misc.FluidSourceInteractionHandler;
import org.jwaresoftware.mcmods.vfp.runtime.VfpBuildHelperSupport;
import org.jwaresoftware.mcmods.vfp.runtime.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.runtime.VfpRewards;
import org.jwaresoftware.mcmods.vfp.tonics.BootlegGelo;
import org.jwaresoftware.mcmods.vfp.tonics.KelpShake;
import org.jwaresoftware.mcmods.vfp.tonics.TonicDrink;

public final class MiscBuildHelper
extends VfpBuildHelperSupport {
    @Override
    protected String categoryName() {
        return "Miscellaneous";
    }

    @Override
    public void installEventBusHandlers(IModRuntime runtime) {
        MinecraftForge.EVENT_BUS.register((Object)new FluidSourceInteractionHandler());
    }

    @Override
    public void makeObjects(IModRuntime runtime) {
        VfpConfig config = (VfpConfig)runtime.getConfig();
        boolean brewingEnabled = config.includePotionBrewing();
        VfpObj.Weighted_Plate_obj = VfpBuilder.newCraftOnlyItem(VfpOid.Weighted_Plate);
        VfpObj.Sandwich_Press_Plate_obj = VfpBuilder.newCraftOnlyItem(VfpOid.Sandwich_Press_Plate);
        VfpObj.Flesh_Meal_obj = new VfpFertilizerItem(VfpOid.Flesh_Meal).autoregister();
        VfpObj.Animal_Hide_Tie_obj = VfpBuilder.newItem(VfpOid.Animal_Hide_Tie);
        VfpObj.Portion_Leather_obj = VfpBuilder.newItem(VfpOid.Portion_Leather);
        VfpObj.Bone_Pencil_obj = VfpBuilder.newMisc(VfpOid.Bone_Pencil);
        VfpObj.Fire_Proofing_Powder_obj = VfpBuilder.newBrewingItem(VfpOid.Fire_Proofing_Powder, (BrewEffect)(brewingEnabled ? BrewEffect.magmaCreamEffect : null), false);
        VfpObj.Fermented_Feather_obj = VfpBuilder.newBrewingItem(VfpOid.Fermented_Feather, (BrewEffect)(brewingEnabled ? BrewEffect.fermentedSpiderEyeEffect : null), false);
        VfpObj.Potion_Mixer_Funnel_obj = VfpBuilder.newItem(VfpOid.Potion_Mixer_Funnel, SharedGlue.CreativeTabs_brewing);
        VfpObj.Tonic_Drink_obj = new TonicDrink();
        VfpObj.Kelp_Shake_obj = new KelpShake();
        VfpObj.Bootleg_Gelo_obj = new BootlegGelo();
    }

    @Override
    public void makeObjectsFinalPass(IModRuntime runtime) {
        VfpObj.Iron_Stomach_obj = VfpBuilder.newMisc(VfpOid.Iron_Stomach);
    }

    @Override
    public void installDeferredTasks(IModRuntime runtime) {
        VfpFertilizerItem.initDispenseBehavior(VfpObj.Flesh_Meal_obj);
    }

    @Override
    public void addLootEntries(IModRuntime runtime) {
        Loot.addFishedUpJunk((String)"vanillafoodpantry", (String)VfpOid.Flint_Cutter.fmlid(), (Item)VfpObj.Flint_Cutter_obj, (float)0.25f, (float)0.25f);
        Loot.addFishedUpJunk((String)"vanillafoodpantry", (String)VfpOid.Empty_Jar.fmlid(), (Item)VfpObj.Empty_Jar_obj);
        Loot.addFishedUpJunk((String)"vanillafoodpantry", (String)VfpOid.Dark_Empty_Jar.fmlid(), (Item)VfpObj.Dark_Empty_Jar_obj);
        Loot.addFishedUpJunk((String)"vanillafoodpantry", (String)VfpOid.Animal_Hide_Tie.fmlid(), (Item)VfpObj.Animal_Hide_Tie_obj);
        Loot.addFishedUpUncommon((String)"vanillafoodpantry", (String)VfpOid.Jungle_Juice_Jar.fmlid(), (ItemStack)JuJuExtensions.jujujuice());
        Loot.addFishedUpUncommon((String)"vanillafoodpantry", (String)VfpOid.Ink_Pearl_Shard.fmlid(), (Item)VfpObj.Ink_Pearl_Shard_obj);
    }

    @Override
    public void setRecipeRewards(IModRuntime runtime) {
        VfpRewards.addRewardingCraftItem(new ItemStack((IItemProvider)VfpObj.Flint_Cutter_obj), VfpOid.Flint_Cutter.craftingXp());
        VfpRewards.addRewardingCraftItem(new ItemStack((IItemProvider)VfpObj.Flesh_Meal_obj), VfpOid.Flesh_Meal.craftingXp());
    }
}

