/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.runtime;

import java.security.SecureRandom;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.template.BlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.placement.ConfiguredPlacement;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;

public final class VfpOreGenerator {
    private static final Random _RANDOM = new SecureRandom();
    public static final RuleTest IS_PLAIN_STONE = new BlockMatchRuleTest(Blocks.field_150348_b);
    static ConfiguredFeature<?, ?> NATRON_GEN;
    static ConfiguredFeature<?, ?> TRONA_GEN;
    static ConfiguredFeature<?, ?> ROCKSALT_GEN;
    static ConfiguredFeature<?, ?> NETHER_ROCKSALT_GEN;

    public static final void install() {
        if (!VfpConfig.getInstance().isOreGenerationEnabled()) {
            return;
        }
        MinecraftForge.EVENT_BUS.addListener(VfpOreGenerator::addOresToBiomes);
    }

    public static final void makeFeatures() {
        if (!VfpConfig.getInstance().isOreGenerationEnabled()) {
            return;
        }
        Registry registry = WorldGenRegistries.field_243653_e;
        ROCKSALT_GEN = Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(IS_PLAIN_STONE, VfpObj.RockSalt_OreBlock_obj.func_176223_P(), 4 + _RANDOM.nextInt(11))).func_227228_a_((ConfiguredPlacement)((ConfiguredPlacement)Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(5, 5, 210)).func_242728_a()).func_242731_b(10));
        NETHER_ROCKSALT_GEN = Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241883_b, VfpObj.Nether_RockSalt_OreBlock_obj.func_176223_P(), 5 + _RANDOM.nextInt(6))).func_227228_a_((ConfiguredPlacement)((ConfiguredPlacement)Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(20, 20, 60)).func_242728_a()).func_242731_b(8));
        Registry.func_218322_a((Registry)registry, (ResourceLocation)ModInfo.r("ore_rock_salt"), ROCKSALT_GEN);
        Registry.func_218322_a((Registry)registry, (ResourceLocation)ModInfo.r("ore_netherrock_salt"), NETHER_ROCKSALT_GEN);
        NATRON_GEN = Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(IS_PLAIN_STONE, VfpObj.Natron_OreBlock_obj.func_176223_P(), 4 + _RANDOM.nextInt(11))).func_227228_a_((ConfiguredPlacement)((ConfiguredPlacement)Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(5, 5, 210)).func_242728_a()).func_242731_b(10));
        TRONA_GEN = Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig((RuleTest)new BlockMatchRuleTest(VfpObj.Natron_OreBlock_obj), VfpObj.Trona_OreBlock_obj.func_176223_P(), 4 + _RANDOM.nextInt(11))).func_227228_a_((ConfiguredPlacement)((ConfiguredPlacement)Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(5, 5, 210)).func_242728_a()).func_242731_b(10));
        Registry.func_218322_a((Registry)registry, (ResourceLocation)ModInfo.r("ore_natron"), NATRON_GEN);
        Registry.func_218322_a((Registry)registry, (ResourceLocation)ModInfo.r("ore_trona"), TRONA_GEN);
    }

    public static final void addOresToBiomes(BiomeLoadingEvent event) {
        if (VfpConfig.getInstance().isOreGenerationEnabled()) {
            switch (event.getCategory()) {
                case THEEND: {
                    break;
                }
                case NETHER: {
                    VfpOreGenerator.addNetherOres(event);
                    break;
                }
                default: {
                    VfpOreGenerator.addOverworldOres(event);
                }
            }
        }
    }

    private static final void addNetherOres(BiomeLoadingEvent event) {
        event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, NETHER_ROCKSALT_GEN);
    }

    private static final void addOverworldOres(BiomeLoadingEvent event) {
        ResourceLocation rid_biome = event.getName();
        if (rid_biome == null || !ModIntegration.MINECRAFT.belongsTo(rid_biome) || !"the_void".equals(rid_biome.func_110623_a())) {
            event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, ROCKSALT_GEN);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, NATRON_GEN);
            event.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, TRONA_GEN);
        }
    }
}

