/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.sandwiches;

import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jwaresoftware.mcmods.lib.recipes.JR;
import org.jwaresoftware.mcmods.lib.recipes.ShapedRecipeWrapping;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.common.FoodPortion;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.sandwiches.DeckerSandwich;

public class KingDeckerSandwichRecipe
extends ShapedRecipeWrapping {
    public static final String NAME = ModInfo.rstring("kingme_decker_shaped");
    public static final ShapedRecipeWrapping.Serializer<KingDeckerSandwichRecipe> SERIALIZER = new ShapedRecipeWrapping.Serializer(KingDeckerSandwichRecipe::new);
    private static final int _MAX_DECKER_FOOD_VALUE = LikeFood.BASE_DECKER.healAmount() + LikeFood.roast_veg.healAmount();
    private static final int _MAX_KINGME_FOOD_VALUE = LikeFood.TOWERING_MEGAWICH.healAmount() + LikeFood.BASE_DECKER.healAmount();

    KingDeckerSandwichRecipe(ShapedRecipe from) {
        super(from);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public boolean func_192399_d() {
        return true;
    }

    public ItemStack func_77572_b(CraftingInventory grid) {
        int foodTotal = 0;
        int n = grid.func_70302_i_();
        for (int i = 0; i < n; ++i) {
            ItemStack stack = grid.func_70301_a(i);
            Item food = FoodPortion.toFood(stack);
            if (food == null) continue;
            int sandwichTotal = DeckerSandwich.getIngredientFoodTotal(food, stack);
            if (sandwichTotal > _MAX_DECKER_FOOD_VALUE && stack.func_77973_b() instanceof DeckerSandwich) {
                return ItemStack.field_190927_a;
            }
            if ((foodTotal += sandwichTotal) < _MAX_KINGME_FOOD_VALUE) continue;
            return ItemStack.field_190927_a;
        }
        return DeckerSandwich.kingme((IItemHandler)new InvWrapper((IInventory)grid));
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory grid) {
        return JR.defaultRecipeGetRemainingItems((CraftingInventory)grid);
    }
}

