/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.sugar;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.LiquidType;
import org.jwaresoftware.mcmods.lib.api.IVariant;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowder;
import org.jwaresoftware.mcmods.vfp.common.Ingredient;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpLiquidMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpTransientVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;

public final class FizzyDrink
extends VfpLiquidMultiItem
implements IVariant {
    private static int BUZZED_EFFECT_DURATION_SECS = 90;
    private static final List<Ingredient> VARIANT_FLAVORS = new ArrayList<Ingredient>(19);
    private static FizzyDrink[] INSTANCES;

    public static final boolean register(Ingredient flavor) {
        return FizzyDrink.register(flavor, VARIANT_FLAVORS, "fizzy drinks");
    }

    public static final boolean register(FoodPowder.Type flavor) {
        Validate.notNull((Object)flavor, (String)"A non-null flavor is required for a fizzy drink", (Object[])new Object[0]);
        String name = null;
        name = flavor == FoodPowder.Type.CARROT ? "orange" : (flavor == FoodPowder.Type.DANDELION ? "dandy" : (flavor == FoodPowder.Type.POPPY ? "poppy" : (flavor == FoodPowder.Type.CACTUS ? "klingon" : flavor.name_lowercased())));
        return FizzyDrink.register(FoodPowder.toIngredient(flavor, FoodPowder.Usage.DRINK_FLAVOR, name));
    }

    FizzyDrink(VfpVariant variant) {
        super((VfpProfile)VfpOid.FizzyDrink, variant, LiquidType.FIZZY);
        this.autoregister();
    }

    @Nonnull
    private Ingredient ingredientFrom() {
        return this._variant.datadata(Ingredient.class);
    }

    public String oid() {
        return VfpOid.FizzyDrink.fmlid();
    }

    @Override
    protected Item getNewEmptyContainer() {
        return VfpObj.Our_Empty_Bottle_obj;
    }

    @Override
    protected VfpCapacity getItemMaxStackSize() {
        return VfpConfig.getInstance().maxDrinksStackCapacity(super.getItemMaxStackSize());
    }

    @Override
    protected int getPotionEffectDurationSecs(boolean good) {
        return good ? BUZZED_EFFECT_DURATION_SECS : super.getPotionEffectDurationSecs(good);
    }

    @Override
    protected Integer getColorFromIngredient(Ingredient ingredient, int renderPass) {
        Integer colorValue = super.getColorFromIngredient(ingredient, renderPass);
        if (colorValue == null) {
            colorValue = 33731;
        }
        return colorValue;
    }

    public String varid() {
        return this.getVariant().fmlid();
    }

    public List<ItemStack> copyOfAllVariantMembers() {
        ArrayList<ItemStack> all = new ArrayList<ItemStack>(INSTANCES.length + 2);
        for (int i = 0; i < INSTANCES.length; ++i) {
            all.add(new ItemStack((IItemProvider)INSTANCES[i]));
        }
        return all;
    }

    @Override
    public boolean isHiddenByDefault() {
        return VfpConfig.getInstance().showAllItemsInUI() ? false : !this.ingredientFrom().isEnabled();
    }

    static final void makeObjects() {
        if (INSTANCES == null && VARIANT_FLAVORS.size() > 0) {
            INSTANCES = new FizzyDrink[VARIANT_FLAVORS.size()];
            String baseName = VfpOid.FizzyDrink.fmlid() + "_";
            for (int i = 0; i < INSTANCES.length; ++i) {
                Ingredient ingredient = VARIANT_FLAVORS.get(i);
                FizzyDrink.INSTANCES[i] = new FizzyDrink(new VfpTransientVariant(i, ingredient.id(), baseName + ingredient.name(), LikeFood.hardened_sugar, ingredient, null));
            }
        }
    }
}

