/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.sugar;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jwaresoftware.mcmods.lib.ItemStackDef;
import org.jwaresoftware.mcmods.lib.LiquidType;
import org.jwaresoftware.mcmods.lib.Misc;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.IItemPropertyExtender;
import org.jwaresoftware.mcmods.lib.api.IVariant;
import org.jwaresoftware.mcmods.lib.capability.ITemperatureChangeable;
import org.jwaresoftware.mcmods.vfp.common.DictionaryNameItemAdaptor;
import org.jwaresoftware.mcmods.vfp.common.FoodColor;
import org.jwaresoftware.mcmods.vfp.common.IReheatable;
import org.jwaresoftware.mcmods.vfp.common.Ingredient;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpLiquidMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPotions;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpTransientVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;

public final class Juice
extends VfpLiquidMultiItem
implements IVariant,
IReheatable,
IItemPropertyExtender {
    public static final int GENERIC_JUICE_COLOR = 10796325;
    private static final List<Flavor> FLAVORS = new ArrayList<Flavor>(23);
    private static Juice[] INSTANCES;

    public static final synchronized boolean register(Flavor flavor) {
        return Juice.register(flavor, FLAVORS, "juice");
    }

    Juice(VfpVariant variant) {
        super((VfpProfile)VfpOid.Juice, variant, LiquidType.JUICE);
        this.autoregister();
    }

    @Nonnull
    private Flavor flavorFrom() {
        return this._variant.datadata(Flavor.class);
    }

    static final void setUncraftable(int id) {
        for (Flavor flavor : FLAVORS) {
            if (flavor.id() != id) continue;
            flavor.setEnabled(Misc.ALWAYS_FALSE);
            break;
        }
    }

    public String oid() {
        return VfpOid.Juice.fmlid();
    }

    @Override
    protected Item getNewEmptyContainer() {
        return VfpObj.Our_Empty_Bottle_obj;
    }

    @Override
    protected VfpCapacity getItemMaxStackSize() {
        return VfpConfig.getInstance().maxDrinksStackCapacity(super.getItemMaxStackSize());
    }

    @Override
    protected Integer getColorFromIngredient(Ingredient ingredient, int renderPass) {
        Integer colorValue = super.getColorFromIngredient(ingredient, renderPass);
        if (colorValue == null) {
            colorValue = 10796325;
        }
        return colorValue;
    }

    public int getCoolDuration(ItemStack juice) {
        int duration = IReheatable.super.getCoolDuration(juice);
        if ("cactus".equals(this.flavorFrom().name())) {
            duration *= 2;
        }
        return duration;
    }

    public int getBonusTemperatureTimeLeftForApply(ItemStack juice, int min) {
        if (min <= 0) {
            min = 90;
        }
        return Math.max(min, this.getBonusTemperatureTimeLeft(juice));
    }

    private boolean isFortified(ItemStack juice) {
        return juice.func_190926_b() ? false : this.flavorFrom().isFortified() || VfpUtils.isGoldGrade(juice);
    }

    @Override
    protected void applyPotionEffectsOnConsumed(ItemStack original, ItemStack remaining, World world, PlayerEntity player) {
        super.applyPotionEffectsOnConsumed(original, remaining, world, player);
        if (this.isCooled(original) && !VfpConfig.manageTemperature()) {
            Potion what = VfpPotions.VIGOR;
            if (this.isFortified(original)) {
                what = VfpPotions.STRONG_VIGOR;
            }
            Potions.addPotionEffects((LivingEntity)player, (Potion)what);
        }
    }

    @Override
    public float getThirstQuenched(ItemStack juice) {
        float amount = super.getThirstQuenched(juice);
        if (this.isFortified(juice)) {
            amount = LiquidType.POWER.getThirstQuenched(juice);
        }
        return amount;
    }

    @Override
    public float getHydrationAdded(ItemStack juice) {
        float amount = super.getHydrationAdded(juice);
        if (this.isFortified(juice)) {
            amount = LiquidType.POWER.getHydrationAdded(juice);
        }
        return amount;
    }

    @Override
    public float getSaturationModifier(ItemStack juice) {
        float amount = super.getSaturationModifier(juice);
        if (VfpUtils.isGoldGrade(juice)) {
            amount *= 1.5f;
        }
        return amount;
    }

    @Override
    public int getTemperatureModifier(ItemStack juice) {
        int chillModifier = super.getTemperatureModifier(juice);
        if (this.isFortified(juice)) {
            chillModifier *= 2;
        }
        return chillModifier;
    }

    @Override
    public void onCookedOrCrafted(ItemStack juice) {
        ITemperatureChangeable.UsedEffect e = this.onCreateCheckBonusTemperature(juice);
        super.onCookedOrCrafted(juice);
        if (ITemperatureChangeable.UsedEffect.COOLED.equals((Object)e)) {
            this.setCooled(juice);
        }
    }

    public void func_77663_a(ItemStack juice, World world, Entity holder, int slotindex, boolean selected) {
        this.onUpdateTickBonusTemperature(juice, world, holder, slotindex, selected);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerPropertyOverrides() {
        ITemperatureChangeable.TemperaturePropertyGetter.forCoolable((Item)this);
    }

    public String varid() {
        return this.getVariant().fmlid();
    }

    public List<ItemStack> copyOfAllVariantMembers() {
        ArrayList<ItemStack> all = new ArrayList<ItemStack>(INSTANCES.length + 2);
        for (int i = 0; i < INSTANCES.length; ++i) {
            all.add(new ItemStack((IItemProvider)INSTANCES[i]));
        }
        return all;
    }

    @Override
    public boolean isHiddenByDefault() {
        return VfpConfig.getInstance().showAllItemsInUI() ? false : !this.flavorFrom().isEnabled();
    }

    static final void makeObjects() {
        if (INSTANCES == null && !FLAVORS.isEmpty()) {
            INSTANCES = new Juice[FLAVORS.size()];
            for (int i = 0; i < INSTANCES.length; ++i) {
                Flavor flavor = FLAVORS.get(i);
                Juice.INSTANCES[i] = new Juice(new VfpTransientVariant(i, flavor.fmlid(), LikeFood.juice, flavor, null));
            }
        }
    }

    public static final class Flavor
    extends Ingredient
    implements FoodColor {
        private boolean _uncommonFlag;
        private final int _colorValue;
        private final Object _secondaryIngredient;
        private boolean _dilutedFlag;
        private boolean _powerFlag;

        public Flavor(String name, int id, ItemStackDef primary, @Nullable Object secondary, int colorValue) {
            super(name, id, primary, 2);
            this._secondaryIngredient = secondary;
            this._colorValue = colorValue >= 0 ? colorValue : 10796325;
        }

        public Flavor(String name, int id, Item primary, @Nullable Object secondary, int colorValue) {
            this(name, id, new ItemStackDef(primary), secondary, colorValue);
        }

        public Flavor(String name, int id, String primary, @Nullable Object secondary, int colorValue) {
            this(name, id, DictionaryNameItemAdaptor.newi(primary), secondary, colorValue);
        }

        @Override
        public int color(ItemStack stack) {
            return this._colorValue;
        }

        @Nullable
        public Object recipeitem2() {
            return this._secondaryIngredient instanceof ItemStackDef ? ItemStackDef.convert((Object)this._secondaryIngredient) : this._secondaryIngredient;
        }

        public String fmlid() {
            return VfpOid.Juice.fmlid() + "_" + this.name();
        }

        public Flavor setDiluted() {
            this._dilutedFlag = true;
            return this;
        }

        public final boolean isDiluted() {
            return this._dilutedFlag;
        }

        public Flavor setUncommon() {
            this._uncommonFlag = true;
            return this;
        }

        public final boolean isUncommon() {
            return this._uncommonFlag;
        }

        public Flavor setFortified() {
            this._powerFlag = true;
            return this;
        }

        public final boolean isFortified() {
            return this._powerFlag;
        }

        @Override
        public boolean isEnabled() {
            boolean b = super.isEnabled();
            if (b && this._secondaryIngredient instanceof String) {
                b = SharedGlue.ingredientDefined((String)((String)this._secondaryIngredient));
            }
            return b;
        }
    }
}

