/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.sugar;

import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import org.jwaresoftware.mcmods.lib.ItemStackDef;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.mod.IModRuntime;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowder;
import org.jwaresoftware.mcmods.vfp.common.Ingredient;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.milk.BowlOfMilk;
import org.jwaresoftware.mcmods.vfp.runtime.VfpBuildHelperSupport;
import org.jwaresoftware.mcmods.vfp.runtime.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.runtime.VfpRewards;
import org.jwaresoftware.mcmods.vfp.sugar.DrinkSyrup;
import org.jwaresoftware.mcmods.vfp.sugar.FizzyDrink;
import org.jwaresoftware.mcmods.vfp.sugar.FruitPreservesJar;
import org.jwaresoftware.mcmods.vfp.sugar.Gelo;
import org.jwaresoftware.mcmods.vfp.sugar.GoldenSugar;
import org.jwaresoftware.mcmods.vfp.sugar.ItalianSoda;
import org.jwaresoftware.mcmods.vfp.sugar.Juice;
import org.jwaresoftware.mcmods.vfp.sugar.SimpleCookie;
import org.jwaresoftware.mcmods.vfp.sugar.Snocone;

public final class SugarExtrasBuildHelper
extends VfpBuildHelperSupport {
    private static final int _JUICE_MODDED_OFFSET = 20;

    @Override
    protected String categoryName() {
        return "SugarExtras";
    }

    @Override
    public void makeObjects(IModRuntime runtime) {
        int mush_maxstack = VfpCapacity.FULL_BUCKET_STACK.count();
        VfpObj.Birch_Bark_obj = VfpBuilder.newMisc(VfpOid.Birch_Bark);
        VfpObj.Hardened_Xylitol_Clump_obj = VfpBuilder.newItem(VfpOid.Hardened_Xylitol_Clump);
        VfpObj.Hardened_Sugar_obj = VfpBuilder.newFood(VfpOid.Hardened_Sugar, LikeFood.hardened_sugar);
        VfpObj.Golden_Sugar_obj = new GoldenSugar(VfpOid.Golden_Sugar, LikeFood.golden_sugar);
        VfpObj.Molasses_Ball_obj = VfpBuilder.newFood(VfpOid.Molasses_Ball, LikeFood.hardened_sugar);
        VfpObj.Bowl_Honey_obj = BowlOfMilk.honey();
        VfpObj.Crystalized_Honey_obj = VfpBuilder.newFood(VfpOid.Crystalized_Honey, LikeFood.honey_bottle);
        VfpObj.Taffy_Blob_obj = VfpBuilder.newFood(VfpOid.Taffy_Blob, LikeFood.sugarbomb);
        VfpObj.Hardened_Sugar_Pantry_Block_obj = VfpBuilder.newStorageBlock(VfpOid.Hardened_Sugar_Pantry_Block, Blocks.field_150354_m, VfpObj.Hardened_Sugar_obj);
        VfpObj.Golden_Beetroots_obj = new GoldenSugar(VfpOid.Golden_Beetroots, LikeFood.golden_beetroots);
        VfpObj.Carrot_Jam_Mush_obj = VfpBuilder.newMushBucket(VfpOid.Carrot_Jam_Mush, mush_maxstack);
        VfpObj.Apple_Jelly_Mush_obj = VfpBuilder.newMushBucket(VfpOid.Apple_Jelly_Mush, mush_maxstack);
        VfpObj.ChorusFruit_Jelly_Mush_obj = VfpBuilder.newMushBucket(VfpOid.ChorusFruit_Jelly_Mush, mush_maxstack);
        VfpObj.MixedBerry_Jam_Mush_obj = VfpBuilder.newMushBucket(VfpOid.Mixed_Berry_Jam_Mush, mush_maxstack);
        VfpObj.Ugli_Smash_Mush_obj = VfpBuilder.newMushBucket(VfpOid.Ugli_Smash_Mush, mush_maxstack);
        VfpObj.Carrot_Jam_obj = FruitPreservesJar.newJar(VfpOid.Carrot_Jam, 16744969);
        VfpObj.Apple_Jelly_obj = FruitPreservesJar.newJar(VfpOid.Apple_Jelly, 15769948);
        VfpObj.ChorusFruit_Jelly_obj = FruitPreservesJar.newJar(VfpOid.ChorusFruit_Jelly, 11168687);
        VfpObj.SpruceTips_Jelly_obj = FruitPreservesJar.newJar(VfpOid.Spruce_Tips_Jelly, 12509816);
        VfpObj.UgliSmash_Jam_obj = FruitPreservesJar.newJar(VfpOid.Ugli_Smash_Jam, 16117921);
        VfpObj.MixedBerry_Jam_obj = FruitPreservesJar.newJar(VfpOid.Mixed_Berry_Jam, 8522501);
        this.registerCookieFlavors();
        FoodPowder.Type.values().forEach(powder -> {
            if (powder.isDrinkFlavor()) {
                FizzyDrink.register(powder);
            }
        });
        this.registerJuiceFlavors();
        this.registerGeloFlavors();
        DrinkSyrup.makeObjects();
        this.registerSnoconeFlavors();
    }

    @Override
    public void makeObjectsFinalPass(IModRuntime runtime) {
        SimpleCookie.makeObjects();
        VfpObj.Italian_Soda_obj = new ItalianSoda((VfpProfile)VfpOid.Italian_Soda, LikeFood.hardened_sugar, false);
        FizzyDrink.makeObjects();
        Gelo.makeObjects();
        Juice.makeObjects();
        Snocone.makeObjects();
    }

    @Override
    public void linkLikeFoods(IModRuntime runtime) {
        LikeFood.hardened_sugar.food().item(VfpObj.Hardened_Sugar_obj);
    }

    @Override
    public void setRecipeRewards(IModRuntime runtime) {
        VfpRewards.addRewardingCraftItem(new ItemStack((IItemProvider)VfpObj.Fizzing_Agent_obj), VfpOid.Fizzing_Agent.craftingXp());
        VfpRewards.addRewardingCraftItem(new ItemStack((IItemProvider)VfpObj.Taffy_Blob_obj), VfpOid.Taffy_Blob.craftingXp());
        VfpRewards.addRewardingCraftItem(new ItemStack((IItemProvider)VfpObj.Golden_Beetroots_obj), VfpOid.Golden_Beetroots.craftingXp());
    }

    @Override
    public void finish(IModRuntime runtime) {
        this.detectUncraftableJuiceFlavors();
    }

    private void registerCookieFlavors() {
        SimpleCookie.register("sugar", VfpObj.Portion_Butter_obj);
        SimpleCookie.register("molasses", VfpObj.Molasses_Ball_obj);
        SimpleCookie.register(FoodPowder.toIngredient(FoodPowder.Type.COCOA, 0, null));
        SimpleCookie.register(FoodPowder.toIngredient(FoodPowder.Type.CACTUS, 0, "klingon"));
        SimpleCookie.register(FoodPowder.toIngredient(FoodPowder.Type.APPLE, 0, null));
    }

    private void registerSnoconeFlavors() {
        for (DrinkSyrup.Flavor flavor : DrinkSyrup.Flavor.values()) {
            Snocone.register(flavor);
        }
    }

    private void registerGeloFlavors() {
        for (FoodPowder.Type powder : FoodPowder.Type.values()) {
            if (!powder.isDrinkFlavor() || powder == FoodPowder.Type.CREAM || powder == FoodPowder.Type.MILK) continue;
            Gelo.register(powder);
        }
        Gelo.register(FoodPowder.Type.UGLI_FRUIT);
        Gelo.register(new Ingredient("honey", 0, new ItemStackDef(() -> Items.field_226638_pX_)));
    }

    private void registerJuiceFlavors() {
        int id0 = FoodPowder.Usage.DRINK_FLAVOR.idFirst();
        Juice.register(new Juice.Flavor("apple", id0 + 0, "foods/apples", null, 10974244));
        Juice.register(new Juice.Flavor("carrot", id0 + 1, Items.field_151172_bF, null, SharedGlue.MapColor_ADOBE.field_76291_p));
        Juice.register(new Juice.Flavor("cane", id0 + 2, Items.field_222065_kN, (Object)Items.field_221794_dg, 15189861).setFortified());
        Juice.register(new Juice.Flavor("cactus", id0 + 3, new ItemStackDef(Blocks.field_150434_aF), null, 10009467).setFortified());
        Juice.register(new Juice.Flavor("potato", id0 + 4, Items.field_151174_bG, null, 14139771));
        Juice.register(new Juice.Flavor("raftugli", id0 + 5, new ItemStackDef(VfpOid.Raftugli_Fruit.resourceid()), (Object)"ingredients/sweeteners", 16776528).setUncommon().setFortified().setDiluted());
        Juice.register(new Juice.Flavor("berries", id0 + 6, Items.field_222112_pR, null, 8522501));
        Juice.register(new Juice.Flavor("melon", id0 + 7, Items.field_151127_ba, null, 0xFFBBBB));
        Juice.register(new Juice.Flavor("kelp", id0 + 8, Items.field_222066_kO, null, 7375145).setFortified());
        int id = id0 + 20;
        Juice.register(new Juice.Flavor("tomato", id++, "foods/tomatoes", null, 12791562));
        Juice.register(new Juice.Flavor("grape", id++, "foods/grapes", (Object)"foods/apples", 8595540));
        Juice.register(new Juice.Flavor("kiwi", id++, "foods/kiwis", (Object)Items.field_151127_ba, 12308059));
        Juice.register(new Juice.Flavor("veggies", id++, "foods/broccoli", (Object)"foods/cucumbers", -1).setFortified());
        Juice.register(new Juice.Flavor("mango", id++, "foods/mangoes", (Object)Items.field_151127_ba, 16759296).setFortified());
    }

    private void detectUncraftableJuiceFlavors() {
        int id = FoodPowder.Usage.DRINK_FLAVOR.idFirst() + 20;
        if (!SharedGlue.ingredientDefined((String)"foods/tomatoes")) {
            Juice.setUncraftable(id);
        }
        ++id;
        if (!SharedGlue.ingredientDefined((String)"foods/grapes")) {
            Juice.setUncraftable(id);
        }
        ++id;
        if (!SharedGlue.ingredientDefined((String)"foods/kiwis")) {
            Juice.setUncraftable(id);
        }
        ++id;
        if (!SharedGlue.ingredientDefined((String)"foods/broccoli") || !SharedGlue.ingredientDefined((String)"foods/cucumbers")) {
            Juice.setUncraftable(id);
        }
        ++id;
        if (!SharedGlue.ingredientDefined((String)"foods/mangoes")) {
            Juice.setUncraftable(id);
        }
        ++id;
    }
}

