/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.tonics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.NonNullList;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.StubbornPotionEffect;
import org.jwaresoftware.mcmods.lib.recipes.ShapedRecipeWrapping;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.tonics.BasicTonicRecipe;
import org.jwaresoftware.mcmods.vfp.tonics.TonicDrink;

public final class CompositeTonicRecipe
extends ShapedRecipeWrapping {
    public static final String NAME = ModInfo.rstring("mixed_tonic_shaped");
    public static final ShapedRecipeWrapping.Serializer<CompositeTonicRecipe> SERIALIZER = new ShapedRecipeWrapping.Serializer(CompositeTonicRecipe::new);

    CompositeTonicRecipe(ShapedRecipe from) {
        super(from);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    static final List<EffectInstance> splitEffects(List<EffectInstance> effects, int spread) {
        if (spread > 1) {
            ListIterator<EffectInstance> litr = effects.listIterator();
            while (litr.hasNext()) {
                EffectInstance e = litr.next();
                if (e.func_188419_a().func_76403_b() && e.func_188419_a() != SharedGlue.Potion_saturation) {
                    litr.remove();
                    continue;
                }
                int duration = Math.max(1, e.func_76459_b() / spread);
                EffectInstance new_e = new EffectInstance(e.func_188419_a(), duration, e.func_76458_c(), e.func_82720_e(), e.func_188418_e());
                litr.set(new_e);
            }
        }
        return effects;
    }

    private List<EffectInstance> normalizedEffects(List<EffectInstance> effects, boolean fortified) {
        LinkedHashMap<Effect, StubbornPotionEffect> hits = new LinkedHashMap<Effect, StubbornPotionEffect>();
        for (EffectInstance e_next : effects) {
            Effect p = e_next.func_188419_a();
            EffectInstance e_curr = (EffectInstance)hits.get(p);
            if (e_curr != null) {
                e_curr.func_199308_a(e_next);
                continue;
            }
            hits.put(p, StubbornPotionEffect.from((EffectInstance)e_next));
        }
        effects.clear();
        if (hits.size() <= VfpConfig.getInstance().maxMoonshineMixCapacity()) {
            for (EffectInstance e_next : hits.values()) {
                if (!fortified) {
                    effects.add(new EffectInstance(e_next));
                    continue;
                }
                effects.add(e_next);
            }
        }
        hits.clear();
        return effects;
    }

    private List<EffectInstance> mergeEffects(CraftingInventory grid, List<Integer> slots, MutableObject<String> type_id, boolean fortified) {
        CompoundNBT holdNbt = new CompoundNBT();
        ArrayList<String> registered_types = new ArrayList<String>();
        int n_valid = 0;
        for (int slotindex : slots) {
            String type_id0;
            ItemStack from = grid.func_70301_a(slotindex);
            List additional = Potions.getEffects((ItemStack)from, (boolean)true);
            Potions.addCustomEffects((CompoundNBT)holdNbt, (boolean)false, (Collection)additional);
            if (!additional.isEmpty() && (type_id0 = Potions.getTypeTranslationKeyOrNull((ItemStack)from, (String)"item.minecraft.potion.effect.")) != null) {
                ++n_valid;
                if (!registered_types.contains(type_id0)) {
                    registered_types.add(type_id0);
                }
            }
            additional.clear();
        }
        if (n_valid == slots.size() && registered_types.size() == 1) {
            type_id.setValue(registered_types.get(0));
        }
        return this.normalizedEffects(PotionUtils.func_185192_b((CompoundNBT)holdNbt), fortified);
    }

    public ItemStack func_77572_b(CraftingInventory grid) {
        ItemStack out = ItemStack.field_190927_a;
        if (!VfpConfig.getInstance().allowMoonshineMixing() || VfpConfig.getInstance().maxMoonshineMixCapacity() <= 1) {
            return out;
        }
        ArrayList<Integer> source_slots = new ArrayList<Integer>();
        int n_spread = 0;
        boolean fortified = false;
        for (int i = 0; i < grid.func_70302_i_(); ++i) {
            ItemStack next = grid.func_70301_a(i);
            if (ItemStacks.isEmpty((ItemStack)next)) continue;
            if (RID.matches((ItemStack)next, (String)"empty_bottles", (Item)VfpObj.Our_Empty_Bottle_obj)) {
                ++n_spread;
                continue;
            }
            if (Potions.isa((ItemStack)next, (boolean)true)) {
                source_slots.add(i);
                continue;
            }
            if (!RID.matches((ItemStack)next, (String)"ingredients/vinegar")) continue;
            fortified = true;
        }
        if (n_spread == 1 && !source_slots.isEmpty()) {
            MutableObject type_id = new MutableObject();
            List<EffectInstance> final_effect = this.mergeEffects(grid, source_slots, (MutableObject<String>)type_id, fortified);
            out = TonicDrink.create(final_effect, fortified, null, (String)type_id.getValue());
        }
        return out;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory grid) {
        return BasicTonicRecipe.getRemainingIncludingEmptyGlassBottles(grid);
    }
}

