/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.utensils;

import com.google.gson.JsonObject;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.FurnaceTileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jwaresoftware.mcmods.lib.BurnTimes;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.recipes.JR;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpRecipe;

public final class CutterExtractHeatPortionsRecipe
extends VfpRecipe {
    public static final String NAME = ModInfo.rstring("heat_portions_shapeless");

    CutterExtractHeatPortionsRecipe() {
        super(new ResourceLocation(NAME));
    }

    public IRecipeSerializer<?> func_199559_b() {
        return Serializer.INSTANCE;
    }

    private int smeltCount(Item item, ItemStack stack) {
        if (item == Items.field_221657_bQ) {
            return 2;
        }
        int bT = stack.getBurnTime();
        bT = ForgeEventFactory.getItemBurnTime((ItemStack)stack, (int)(bT < 0 ? FurnaceTileEntity.func_214001_f().getOrDefault(item, 0) : bT));
        if (bT <= 0 || bT > BurnTimes.FULL_STACK_BURN_TIME) {
            return -1;
        }
        return bT /= 200;
    }

    private boolean isCutter(ItemStack next) {
        boolean y = false;
        if (VfpObj.Flint_Cutter_obj == next.func_77973_b()) {
            y = true;
        } else if (RID.matches((ItemStack)next, (String)"carrots:food_cutters")) {
            y = true;
        }
        return y;
    }

    public boolean matches(CraftingInventory grid, World world) {
        if (!VfpConfig.getInstance().allowGeneralFlintCutter()) {
            return false;
        }
        int n_cutter = 0;
        int n_marker = 0;
        int n = 0;
        for (int i = 0; i < grid.func_70302_i_(); ++i) {
            ItemStack next = grid.func_70301_a(i);
            if (ItemStacks.isEmpty((ItemStack)next)) continue;
            Item item = next.func_77973_b();
            if (this.isCutter(next)) {
                ++n_cutter;
            } else if (item == VfpObj.Heat_Portion_obj) {
                ++n_marker;
            } else {
                if (this.smeltCount(item, next) <= 0) {
                    return false;
                }
                ++n;
            }
            if (n_cutter <= 1 && n_marker <= 1) continue;
            return false;
        }
        return n_cutter == 1 && n_marker <= 1 && n == 1;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public boolean func_192399_d() {
        return true;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public ItemStack getCraftingResult(CraftingInventory grid) {
        ItemStack out = ItemStack.field_190927_a;
        for (int i = 0; i < grid.func_70302_i_(); ++i) {
            Item item;
            ItemStack next = grid.func_70301_a(i);
            if (ItemStacks.isEmpty((ItemStack)next) || (item = next.func_77973_b()) == VfpObj.Heat_Portion_obj || this.isCutter(next)) continue;
            int n = this.smeltCount(item, next);
            if (n <= 0) break;
            out = new ItemStack((IItemProvider)VfpObj.Heat_Portion_obj, Math.min(SharedGlue.MAX_STACK_SIZE(), n));
            break;
        }
        return out;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory grid) {
        return JR.defaultRecipeGetRemainingItems((CraftingInventory)grid);
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<CutterExtractHeatPortionsRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public CutterExtractHeatPortionsRecipe read(ResourceLocation recipeId, JsonObject json) {
            return new CutterExtractHeatPortionsRecipe();
        }

        public CutterExtractHeatPortionsRecipe read(ResourceLocation recipeId, PacketBuffer data) {
            return new CutterExtractHeatPortionsRecipe();
        }

        public void write(PacketBuffer data, CutterExtractHeatPortionsRecipe recipe) {
        }
    }
}

