/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.utensils;

import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.recipes.ShapelessRecipeWrapping;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;

public class FillBucketJarRecipe
extends ShapelessRecipeWrapping {
    public static final String NAME = ModInfo.rstring("fill_bigjar_shapeless");
    public static final ShapelessRecipeWrapping.Serializer<FillBucketJarRecipe> SERIALIZER = new ShapelessRecipeWrapping.Serializer(FillBucketJarRecipe::new);

    FillBucketJarRecipe(ShapelessRecipe from) {
        super(from);
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public boolean func_192399_d() {
        return true;
    }

    static boolean matchesFillShape(CraftingInventory grid) {
        int jar_count = 0;
        int holder_count = 0;
        for (int i = 0; i < grid.func_70302_i_(); ++i) {
            ItemStack next = grid.func_70301_a(i);
            if (next.func_190926_b()) continue;
            if (next.func_77973_b() == VfpObj.Empty_Bucket_Jar_obj) {
                ++jar_count;
                continue;
            }
            if (ItemStacks.getFluidHandler((ItemStack)ItemStacks.copy1((ItemStack)next)) != null) {
                ++holder_count;
                continue;
            }
            return false;
        }
        return jar_count == 1 && holder_count == 1;
    }

    public boolean func_77569_a(CraftingInventory grid, World world) {
        return super.func_77569_a(grid, world) && FillBucketJarRecipe.matchesFillShape(grid);
    }

    public ItemStack func_77572_b(CraftingInventory grid) {
        IFluidHandlerItem jarholder;
        FluidStack fluid;
        ItemStack out = ItemStack.field_190927_a;
        ItemStack jar = null;
        ItemStack holder = null;
        IFluidHandlerItem fluidholder = null;
        for (int i = 0; i < grid.func_70302_i_(); ++i) {
            ItemStack next = grid.func_70301_a(i);
            if (next.func_190926_b()) continue;
            if (next.func_77973_b() == VfpObj.Empty_Bucket_Jar_obj) {
                jar = next;
            } else {
                IFluidHandlerItem fH = ItemStacks.getFluidHandler((ItemStack)ItemStacks.copy1((ItemStack)next));
                if (fH != null) {
                    fluidholder = fH;
                    holder = next;
                }
            }
            if (jar != null && holder != null) break;
        }
        if (jar != null && holder != null && (fluid = fluidholder.drain(1000, IFluidHandler.FluidAction.SIMULATE)).getAmount() == 1000 && (jarholder = ItemStacks.getFluidHandler((ItemStack)ItemStacks.copy1((ItemStack)jar))).fill(fluid, IFluidHandler.FluidAction.EXECUTE) == fluid.getAmount()) {
            out = jarholder.getContainer();
        }
        return out;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory grid) {
        NonNullList leftovers = NonNullList.func_191197_a((int)grid.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < leftovers.size(); ++i) {
            ItemStack next = grid.func_70301_a(i);
            if (next.func_190926_b()) continue;
            if (next.func_77973_b() == VfpObj.Empty_Bucket_Jar_obj) {
                leftovers.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)next));
                continue;
            }
            IFluidHandlerItem fluidholder = ItemStacks.getFluidHandler((ItemStack)ItemStacks.copy1((ItemStack)next));
            if (fluidholder == null) continue;
            fluidholder.drain(1000, IFluidHandler.FluidAction.EXECUTE);
            leftovers.set(i, (Object)fluidholder.getContainer());
        }
        return leftovers;
    }
}

