/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.veggies;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;

public class NomadFoodBar
extends VfpPantryItem {
    protected final boolean _longlastingFlag;

    public NomadFoodBar(@Nonnull VfpProfile profile, LikeFood food, boolean longlasting) {
        super(profile, food, null);
        this._longlastingFlag = longlasting;
        this.autoregister();
    }

    @Override
    public ItemStack createInstance(Item item, int amount) {
        return new ItemStack((IItemProvider)item, amount);
    }

    @Override
    protected int getPotionEffectDurationSecs(boolean good) {
        return this._longlastingFlag && good ? 360 : 120;
    }

    @Override
    protected void applyPotionEffectsOnConsumed(ItemStack original, ItemStack remaining, World world, PlayerEntity player) {
        if (this._longlastingFlag) {
            this.addLongSaturation(original, player);
        }
        super.applyPotionEffectsOnConsumed(original, remaining, world, player);
    }

    @Override
    public float getCompostChance(Item bar) {
        return bar == this ? (this._longlastingFlag ? 1.0f : 0.8f) : -1.0f;
    }

    public static final NomadFoodBar mealBar() {
        return new NomadFoodBar((VfpProfile)VfpOid.Nomads_Meal_Bar, LikeFood.nomads_fullbar, true);
    }

    public static final NomadFoodBar snackBar() {
        return new NomadFoodBar((VfpProfile)VfpOid.Nomads_Snack_Bar, LikeFood.nomads_halfbar, false);
    }
}

