/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.veggies;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpSimpleBowlFood;

public class VfpSpecialSalad
extends VfpSimpleBowlFood {
    protected final boolean _longlastingFlag;

    protected VfpSpecialSalad(VfpProfile oid, LikeFood like, boolean longlasting) {
        super(oid, like, false);
        this._longlastingFlag = longlasting;
        this.setMaxStackSize(this.getItemMaxStackSize().count());
    }

    @Override
    protected VfpCapacity getItemMaxStackSize() {
        return this._longlastingFlag ? VfpCapacity.SMALL_STACK : VfpConfig.getInstance().maxSoupsStackCapacity(super.getItemMaxStackSize());
    }

    @Override
    public float getCompostChance(Item what) {
        return what == this ? 1.0f : -1.0f;
    }

    @Override
    protected int getPotionEffectDurationSecs(boolean good) {
        return this._longlastingFlag && good ? 180 : super.getPotionEffectDurationSecs(good);
    }

    @Override
    protected void applyPotionEffectsOnConsumed(ItemStack original, ItemStack remaining, World world, PlayerEntity player) {
        if (this._longlastingFlag) {
            this.addLongSaturation(original, player);
        }
        super.applyPotionEffectsOnConsumed(original, remaining, world, player);
    }

    public static final VfpSpecialSalad newSalad() {
        return new VfpSpecialSalad((VfpProfile)VfpOid.Special_Salad, LikeFood.special_salad, true);
    }
}

