/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.water;

import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBiomeReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biomes;
import net.minecraftforge.common.BiomeDictionary;
import org.jwaresoftware.mcmods.lib.BlockXyz;
import org.jwaresoftware.mcmods.lib.Fluids;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.Locations;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpPlainItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;

public abstract class EmptyFluidContainerItem
extends VfpPlainItem {
    protected EmptyFluidContainerItem(VfpProfile oid, Item.Properties ip) {
        super(oid, ip);
        if (oid.isVFP()) {
            this.autoregister();
        }
    }

    protected EmptyFluidContainerItem(VfpProfile oid) {
        super(oid, (ItemGroup)(oid.isVFP() ? SharedGlue.CreativeTabs_misc : null));
        if (oid.isVFP()) {
            this.autoregister();
        }
    }

    protected static final boolean isSwampishBiomeAtPos(World world, BlockPos blockpos) {
        RegistryKey biome = Locations.biomeKeyFor((IBiomeReader)world, (BlockPos)blockpos);
        return Locations.isaRegularSwamp((RegistryKey)biome) || Locations.isBiomeLike((RegistryKey)biome, (RegistryKey)Biomes.field_76780_h, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DENSE});
    }

    @Nullable
    protected abstract ItemStack getWaterFilledContainerItem(World var1, BlockPos var2, PlayerEntity var3);

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack held = player.func_184586_b(hand);
        if (ItemStacks.isEmpty((ItemStack)held)) {
            return new ActionResult(ActionResultType.PASS, (Object)held);
        }
        BlockRayTraceResult hit = EmptyFluidContainerItem.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY);
        ActionResult result = new ActionResult(ActionResultType.PASS, (Object)held);
        if (hit != null && hit.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult blockhit = hit;
            BlockPos blockpos = blockhit.func_216350_a();
            if (!world.func_175660_a(player, blockpos) || !player.func_175151_a(blockpos.func_177972_a(blockhit.func_216354_b()), blockhit.func_216354_b(), held)) {
                return result;
            }
            if (Fluids.IsWater.present((BlockXyz)new BlockXyz((IWorldReader)world, blockpos))) {
                ItemStack filledItem = this.getWaterFilledContainerItem(world, blockpos, player);
                if (ItemStacks.isEmpty((ItemStack)filledItem)) {
                    return new ActionResult(ActionResultType.FAIL, (Object)held);
                }
                this.addUsedStat(player);
                if (ItemStacks.decrBy((ItemStack)held, (int)1)) {
                    return new ActionResult(ActionResultType.CONSUME, (Object)filledItem);
                }
                if (!player.field_71071_by.func_70441_a(filledItem)) {
                    player.func_71019_a(filledItem, false);
                }
            }
        }
        return result;
    }
}

