/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.agents;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.jwaresoftware.mcmods.vfp.agents.TronaOreWorldGenerator;
import org.jwaresoftware.mcmods.vfp.common.MinecraftGlue;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpOreBlock;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryBlock;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.core.VfpBuildHelperSupport;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.VfpRuntime;

final class CarbonationBuildHelper
extends VfpBuildHelperSupport {
    CarbonationBuildHelper() {
    }

    @Override
    protected String categoryName() {
        return "Carbonation";
    }

    @Override
    public void doBuildEventBusHandlers(FMLStateEvent event, VfpRuntime runtime) {
        if (runtime.getConfig().isOreGenerationEnabled()) {
            TronaOreWorldGenerator wg = TronaOreWorldGenerator.create(runtime.getConfig());
            GameRegistry.registerWorldGenerator((IWorldGenerator)wg, (int)wg.importance());
        }
    }

    @Override
    public void doBuildPrimaryObjects(FMLStateEvent event, VfpRuntime runtime) {
        VfpObj.Natron_Crystals_obj = VfpBuilder.newItem(VfpOid.Natron_Crystals);
        VfpObj.Natron_Ingot_obj = VfpBuilder.newStorageItem(VfpOid.Natron_Ingot);
        VfpObj.Natron_OreBlock_obj = new VfpOreBlock((VfpProfile)VfpOid.Natron_Ore, Blocks.field_150348_b, new ItemStack(VfpObj.Natron_Crystals_obj, 2), 1).autoregister();
        OreDictionary.registerOre((String)"oreNatron", (Block)VfpObj.Natron_OreBlock_obj);
        VfpObj.Trona_Crystals_obj = VfpBuilder.newItem(VfpOid.Trona_Crystals);
        VfpObj.Trona_OreBlock_obj = new VfpOreBlock((VfpProfile)VfpOid.Trona_Ore, Blocks.field_150348_b, new ItemStack(VfpObj.Trona_Crystals_obj, 3), 5).autoregister();
        OreDictionary.registerOre((String)"oreTrona", (Block)VfpObj.Trona_OreBlock_obj);
        VfpObj.Baking_Soda_obj = VfpBuilder.newAdditive(VfpOid.Baking_Soda);
        VfpObj.Baking_Soda_Pantry_Block_obj = new VfpPantryBlock((VfpProfile)VfpOid.Baking_Soda_Pantry_Block, (Block)Blocks.field_150354_m, VfpObj.Baking_Soda_obj).autoregister();
    }

    @Override
    public void doBuildRecipes(VfpRuntime runtime) {
        Item[] seeds;
        VfpBuilder.autorecipe("Carbonation", VfpCapacity.PORTABLE, (Object)VfpObj.Natron_Crystals_obj, VfpObj.Natron_Ingot_obj, VfpObj.Natron_Crystals_obj);
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Baking_Soda_obj, VfpCapacity.CRYSTAL_BATCH.count()), new Object[]{VfpObj.Natron_Crystals_obj}));
        for (Item seed : seeds = new Item[]{Items.field_151014_N, Items.field_151081_bc, Items.field_151080_bb}) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Drying_Agent_obj, VfpCapacity.DENSE_CRYSTAL_BATCH.count()), new Object[]{"xxx", "xcx", "xxx", Character.valueOf('x'), seed, Character.valueOf('c'), VfpObj.Natron_Crystals_obj}));
        }
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Drying_Agent_obj, VfpCapacity.DENSE_CRYSTAL_BATCH.count()), new Object[]{VfpObj.Natron_Crystals_obj, VfpObj.Sunflower_plant_obj}));
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(VfpObj.Baking_Soda_obj, 3), new Object[]{VfpObj.Trona_Crystals_obj, VfpObj.Baking_Soda_obj}));
        VfpBuilder.autorecipe(this.categoryName(), VfpCapacity.STANDARD_BLOCK, (Object)VfpObj.Baking_Soda_obj, VfpObj.Baking_Soda_Pantry_Block_obj, VfpObj.Baking_Soda_obj);
    }

    @Override
    public void doAddChestGenLoot(VfpRuntime runtime) {
        ChestGenHooks village = ChestGenHooks.getInfo((String)"villageBlacksmith");
        village.addItem(new WeightedRandomChestContent(new ItemStack(VfpObj.Natron_Ingot_obj), 1, 1, MinecraftGlue.UNCOMMON_WEIGHT()));
        village.addItem(new WeightedRandomChestContent(new ItemStack(VfpObj.Trona_Crystals_obj), 1, 1, MinecraftGlue.TREASURE_WEIGHT()));
    }

    @Override
    public void doInitRenderModels(FMLStateEvent event, VfpRuntime runtime) {
        if (runtime.hasUI()) {
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Natron_Crystals, VfpObj.Natron_Crystals_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Natron_Ingot, VfpObj.Natron_Ingot_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Natron_Ore, VfpObj.Natron_OreBlock_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Trona_Crystals, VfpObj.Trona_Crystals_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Trona_Ore, VfpObj.Trona_OreBlock_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Baking_Soda, VfpObj.Baking_Soda_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Baking_Soda_Pantry_Block, VfpObj.Baking_Soda_Pantry_Block_obj);
        }
    }
}

