/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.agents;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.Potion;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowders;
import org.jwaresoftware.mcmods.vfp.common.DictionaryNameItemAdaptor;
import org.jwaresoftware.mcmods.vfp.common.FoodColor;
import org.jwaresoftware.mcmods.vfp.common.Ingredient;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpLiquidMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpTransientVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.VfpRewards;

public final class Water
extends VfpLiquidMultiItem {
    public static final int GENERIC_COLOR = 3694022;
    public static final int SWEET_COLOR = 9411776;
    public static final int ROSE_COLOR = 15059658;
    public static final int TONICS_COLOR = 15708682;
    public static final int TULIP_COLOR = 0xFFCACA;
    public static final int FIZZY_COLOR = 33731;
    public static final int SWAMP_COLOR = 4354870;
    public static final int BIRCH_COLOR = 12503149;
    private static final int _PLAIN = 0;
    private static final int _SWEET = 1;
    private static final int _ROSE = 2;
    private static final int _TULIP = 3;
    static final int _FIZZY = 4;
    private static final int _SWAMP = 5;
    private static final int _BIRCH = 6;
    static final int _IDS_END = 7;
    public static final int FIRST_CUSTOM_ID = 33;
    private static final ItemStack _PLACEHOLDER = new ItemStack(Items.field_151124_az);
    private static final List<Ingredient> VARIANT_FLAVORS = new ArrayList<Ingredient>();
    private static final VfpVariantSet VARIANT_SET;
    private static Water INSTANCE;
    private static ItemStack[] TYPED_INSTANCES;

    public static final synchronized boolean register(Flavor flavor) {
        Validate.notNull((Object)flavor, (String)"A non-null flavor is required for a flavored water drink", (Object[])new Object[0]);
        if (flavor.id() >= 0 && flavor.id() < 7) {
            return false;
        }
        return Water.register(flavor, VARIANT_FLAVORS, "water");
    }

    public Water(VfpOid oid, CreativeTabs tab) {
        super((VfpProfile)oid, VARIANT_SET, tab);
        this.func_77848_i();
        if (VfpConfig.getInstance().ignoreMagicalEmptiesBug()) {
            this.func_77642_a(VfpObj.Our_Empty_Bottle_obj);
        }
    }

    @Override
    protected ItemStack getNewEmptyContainer() {
        return new ItemStack(VfpObj.Our_Empty_Bottle_obj);
    }

    @Override
    protected VfpCapacity getItemMaxStackSize() {
        return VfpCapacity.MAX_STACK;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected Integer getVariantColorFromMeta(VfpVariant type, Ingredient ingredient, int renderPass) {
        Integer colorValue = super.getVariantColorFromMeta(type, ingredient, renderPass);
        if (colorValue == null) {
            colorValue = 3694022;
        }
        return colorValue;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List subItems) {
        if (tab == null) {
            super.func_150895_a(item, tab, subItems);
        } else {
            CreativeTabs wantTab = VfpUtils.preferredTab();
            if (wantTab == null) {
                wantTab = CreativeTabs.field_78039_h;
            }
            if (wantTab == tab) {
                subItems.add(new ItemStack(item, 1, 0));
                subItems.add(new ItemStack(item, 1, 1));
                subItems.add(new ItemStack(item, 1, 4));
                subItems.add(new ItemStack(item, 1, 6));
            }
        }
    }

    protected void func_77849_c(ItemStack stack, World world, EntityPlayer player) {
        Ingredient ingredient;
        if (!world.field_72995_K && (ingredient = VfpVariant.byItemStack(stack, this._variant_default).datadata(Ingredient.class)) != null && ingredient.id() == 6) {
            player.func_82170_o(Potion.field_76438_s.field_76415_H);
        }
        super.func_77849_c(stack, world, player);
    }

    public static final synchronized Water get() {
        if (INSTANCE == null) {
            ArrayList<VfpTransientVariant> variants = new ArrayList<VfpTransientVariant>(23);
            String typeName = VARIANT_SET.typeName();
            for (Ingredient ingredient : VARIANT_FLAVORS) {
                LikeFood like;
                LikeFood likeFood = like = ingredient.recipeitem() == _PLACEHOLDER ? LikeFood.water : LikeFood.flavored_water;
                if (ingredient.id() == 6) {
                    like = LikeFood.birch_sap;
                }
                variants.add(new VfpTransientVariant(ingredient.id(), typeName, like, ingredient, null, VARIANT_SET));
            }
            INSTANCE = VfpBuilder.newMultiItem(VfpOid.Water_Bottle, Water.class, VfpBuilder.User.INTERNAL);
            for (Ingredient ingredient : VARIANT_FLAVORS) {
                if (!ingredient.isEnabled()) continue;
                ItemStack a_water_drink = new ItemStack((Item)INSTANCE, 1, ingredient.id());
                OreDictionary.registerOre((String)"foodDrink", (ItemStack)a_water_drink);
            }
        }
        return INSTANCE;
    }

    public static final void registerAllUnder(String forgeid) {
        if (INSTANCE != null) {
            OreDictionary.registerOre((String)forgeid, (ItemStack)Water.plain(1));
            OreDictionary.registerOre((String)forgeid, (ItemStack)Water.fizzy(1));
        }
    }

    public static final synchronized void autorecipe() {
        if (TYPED_INSTANCES == null && Water.get() != null) {
            ArrayList<ItemStack> instances = new ArrayList<ItemStack>(23);
            ItemStack plain_water = new ItemStack((Item)INSTANCE, 1, 0);
            instances.add(plain_water.func_77946_l());
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)INSTANCE, 4, 0), new Object[]{"W ", "bb", "bb", Character.valueOf('W'), "portionWaterLarge", Character.valueOf('b'), VfpObj.Our_Empty_Bottle_obj}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)INSTANCE, 4, 0), new Object[]{"I ", "bb", "bb", Character.valueOf('I'), Blocks.field_150432_aD, Character.valueOf('b'), VfpObj.Our_Empty_Bottle_obj}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)INSTANCE, 4, 0), new Object[]{"Wp", "bb", "bb", Character.valueOf('W'), "portionWaterLarge", Character.valueOf('p'), "portionWaterSmall", Character.valueOf('b'), VfpObj.Empty_Bottle_obj}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)INSTANCE, 4, 0), new Object[]{"Ip", "bb", "bb", Character.valueOf('I'), Blocks.field_150432_aD, Character.valueOf('p'), "portionWaterSmall", Character.valueOf('b'), VfpObj.Empty_Bottle_obj}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)INSTANCE, 1, 0), new Object[]{"xxx", "xbx", "xxx", Character.valueOf('x'), "portionWaterSmall", Character.valueOf('b'), VfpObj.Our_Empty_Bottle_obj}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(VfpObj.Our_Empty_Bottle_obj, 6), new Object[]{"bbb", "bbb", "p  ", Character.valueOf('p'), "portionWaterSmall", Character.valueOf('b'), VfpObj.Empty_Bottle_obj}));
            instances.add(new ItemStack((Item)INSTANCE, 1, 1));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)INSTANCE, 4, 1), new Object[]{"Was", "bb ", "bb ", Character.valueOf('W'), "portionWaterLarge", Character.valueOf('a'), FoodPowders.get(FoodPowders.Type.APPLE, 1), Character.valueOf('s'), FoodPowders.get(FoodPowders.Type.SYRUP, 1), Character.valueOf('b'), "itemEmptyBottle"}));
            instances.add(new ItemStack((Item)INSTANCE, 1, 2));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)INSTANCE, 2, 2), new Object[]{"rr", "Wh", "bb", Character.valueOf('r'), VfpObj.Rose_plant_obj, Character.valueOf('W'), "portionWaterLarge", Character.valueOf('h'), "portionHeatSmall", Character.valueOf('b'), "itemEmptyBottle"}));
            instances.add(new ItemStack((Item)INSTANCE, 1, 3));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)INSTANCE, 1, 3), new Object[]{"ttt", "twt", "ttt", Character.valueOf('t'), "foodFlower", Character.valueOf('w'), new ItemStack((Item)INSTANCE, 1, 2)}));
            instances.add(new ItemStack((Item)INSTANCE, 1, 4));
            instances.add(new ItemStack((Item)INSTANCE, 1, 5));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)INSTANCE, 2, 5), new Object[]{"ll", "Wh", "bb", Character.valueOf('l'), Blocks.field_150392_bi, Character.valueOf('W'), "portionWaterLarge", Character.valueOf('h'), "portionHeatSmall", Character.valueOf('b'), "itemEmptyBottle"}));
            instances.add(new ItemStack((Item)INSTANCE, 1, 6));
            if (VfpUtils.ingredientDefined("itemBirchSapBucket")) {
                ItemStack bucket_sap = (ItemStack)OreDictionary.getOres((String)"itemBirchSapBucket").get(0);
                GameRegistry.addRecipe((IRecipe)VfpRewards.addRewardingCraftItem((IRecipe)new ShapedOreRecipe(new ItemStack((Item)INSTANCE, 2, 6), new Object[]{"B ", "bb", Character.valueOf('B'), "itemBirchSapBucket", Character.valueOf('b'), "itemEmptyBottle"}), LikeFood.birch_sap.craftExperience()));
            }
            for (int i = 7; i < VARIANT_FLAVORS.size(); ++i) {
                instances.add(new ItemStack((Item)INSTANCE, 1, VARIANT_FLAVORS.get(i).id()));
            }
            TYPED_INSTANCES = instances.toArray(new ItemStack[0]);
        }
    }

    public static final VfpVariantSet variants() {
        return VARIANT_SET;
    }

    public static final ItemStack plain(int amount) {
        return new ItemStack((Item)INSTANCE, amount, 0);
    }

    public static final ItemStack sweet(int amount) {
        return new ItemStack((Item)INSTANCE, amount, 1);
    }

    public static final ItemStack fizzy(int amount) {
        return new ItemStack((Item)INSTANCE, amount, 4);
    }

    public static final ItemStack swamp(int amount) {
        return new ItemStack((Item)INSTANCE, amount, 5);
    }

    public static final ItemStack birch(int amount) {
        return new ItemStack((Item)INSTANCE, amount, 6);
    }

    public static final ItemStack other(int id, int amount) {
        for (int i = 0; i < VARIANT_FLAVORS.size(); ++i) {
            Ingredient ingredient = VARIANT_FLAVORS.get(i);
            if (ingredient.id() != id) continue;
            return new ItemStack((Item)INSTANCE, amount, id);
        }
        return null;
    }

    static {
        Flavor plain_water = new Flavor(0, "plain", _PLACEHOLDER, -1);
        VARIANT_FLAVORS.add(plain_water);
        Flavor sweet_water = new Flavor(1, "sweet", "ingredientSweetener", 9411776);
        VARIANT_FLAVORS.add(sweet_water);
        Flavor rose_water = new Flavor(2, "rose", _PLACEHOLDER, 15059658);
        VARIANT_FLAVORS.add(rose_water);
        Flavor tulip_water = new Flavor(3, "tulip", "ingredientSweetener", 0xFFCACA);
        VARIANT_FLAVORS.add(tulip_water);
        Flavor fizzy_water = new Flavor(4, "fizzy", _PLACEHOLDER, 33731);
        VARIANT_FLAVORS.add(fizzy_water);
        Flavor swamp_water = new Flavor(5, "swamp", _PLACEHOLDER, 4354870);
        VARIANT_FLAVORS.add(swamp_water);
        Flavor birch_sap = new Flavor(6, "birch_sap", "itemBirchSapBucket", 12503149);
        VARIANT_FLAVORS.add(birch_sap);
        VARIANT_SET = new VfpLiquidMultiItem.VariantSet((VfpProfile)VfpOid.Water_Bottle, (Class)Water.class){

            @Override
            protected VfpVariant[] declaredVariants() {
                return this.values().toArray(VfpVariant.EMPTY_ARRAY);
            }
        };
    }

    public static final class Flavor
    extends Ingredient
    implements FoodColor {
        private final int _colorValue;

        public Flavor(int id, String name, ItemStack primary, int colorValue) {
            super(name, id, primary, 1);
            this._colorValue = colorValue >= 0 ? colorValue : 3694022;
        }

        public Flavor(int id, String name, String primary, int colorValue) {
            this(id, name, DictionaryNameItemAdaptor.newi(primary), colorValue);
        }

        @Override
        public int color(ItemStack stack) {
            return this._colorValue;
        }
    }
}

