/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.carton;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.vfp.carton.BaggedFoodDef;
import org.jwaresoftware.mcmods.vfp.common.PackagedFood;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryBag;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpTransientVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariantSet;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;

public final class BagsOf {
    static final List<BaggedFoodDef> BAG_TYPE_DEFINITIONS = new ArrayList<BaggedFoodDef>();
    static final VariantSet VARIANT_SET;
    static VfpPantryBag INSTANCE;
    static final Map<String, VfpVariant[]> TYPE_INSTANCES;

    public static final boolean register(BaggedFoodDef def) {
        boolean added = false;
        if (!BAG_TYPE_DEFINITIONS.contains(def)) {
            added = BAG_TYPE_DEFINITIONS.add(def);
        }
        return added;
    }

    static final VfpPantryBag get(VfpConfig config) {
        if (INSTANCE == null) {
            for (BaggedFoodDef def : BAG_TYPE_DEFINITIONS) {
                VfpVariant[] variants = PackagedFood.init(def.groupId(), VARIANT_SET, false, def.groupMetaoffset(), def.groupExclusions());
                Validate.validState((variants != null && variants.length > 0 ? 1 : 0) != 0, (String)"Unable to create the VFP's bagOf '%s' variant item", (Object[])new Object[]{def.groupId()});
                TYPE_INSTANCES.put(def.groupId(), variants);
            }
            ArrayList<VfpVariant> merged = new ArrayList<VfpVariant>();
            for (VfpVariant variant : VARIANT_SET.values()) {
                merged.add(variant);
            }
            Collections.sort(merged);
            BagsOf.VARIANT_SET._variant_array = merged.toArray(VfpVariant.EMPTY_ARRAY);
            INSTANCE = new VfpPantryBag((VfpProfile)VfpOid.Bag_of, VARIANT_SET.declaredVariants(), null).autoregister(VfpPantryBag.class);
        }
        return INSTANCE;
    }

    static final void autorecipe(VfpPantryBag instance) {
        Validate.validState((VfpObj.Empty_Paper_Bag_obj != null ? 1 : 0) != 0, (String)"Empty paper bag must be registered before filled bags!", (Object[])new Object[0]);
        for (VfpVariant variant : VARIANT_SET.declaredVariants()) {
            ItemStack bag_of_stuff = new ItemStack((Item)instance, 1, variant.metadata());
            ItemStack stuff = variant.food().sample();
            VfpBuilder.autorecipe("BagsOf", VfpCapacity.TRAY, (Object)stuff, bag_of_stuff, VfpObj.Empty_Paper_Bag_obj, stuff);
        }
    }

    static final VfpVariantSet variants() {
        Validate.validState((!VARIANT_SET.isEmpty() ? 1 : 0) != 0, (String)"BagsOf must be initialized before being used", (Object[])new Object[0]);
        return VARIANT_SET;
    }

    static final VfpVariant[] variantsFor(String typename) {
        Validate.validState((!TYPE_INSTANCES.isEmpty() ? 1 : 0) != 0, (String)"BagsOf must be initialized before being used", (Object[])new Object[0]);
        return TYPE_INSTANCES.get(typename);
    }

    public static final ItemStack sample(PackagedFood pf) {
        VfpVariant[] known;
        PackagedFood.Type type;
        ItemStack stack = null;
        if (pf != null && (type = PackagedFood.Type.from(pf.type())) != null && (known = BagsOf.variantsFor(pf.type())) != null) {
            for (VfpVariant v : known) {
                if (v.metadata() != type.shared_metaoffset() + pf.typemeta()) continue;
                stack = new ItemStack((Item)INSTANCE, 1, v.metadata());
                break;
            }
        }
        return stack;
    }

    public static final Map<ItemStack, ItemStack> autocraftables() {
        HashMap<ItemStack, ItemStack> map = new HashMap<ItemStack, ItemStack>();
        for (VfpVariant variant : VARIANT_SET.declaredVariants()) {
            ItemStack bag_of_stuff = new ItemStack((Item)INSTANCE, 1, variant.metadata());
            ItemStack stuff = variant.food().sample(8);
            map.put(bag_of_stuff, stuff);
        }
        return map;
    }

    static {
        BAG_TYPE_DEFINITIONS.add(BaggedFoodDef.forVegetables(PackagedFood.MUSHROOM, PackagedFood.RED_MUSHROOM));
        BAG_TYPE_DEFINITIONS.add(BaggedFoodDef.forBakery(PackagedFood.CAKE));
        BAG_TYPE_DEFINITIONS.add(BaggedFoodDef.forMeat(PackagedFood.HORSE, PackagedFood.WOLF));
        BAG_TYPE_DEFINITIONS.add(BaggedFoodDef.forCookedMeat(PackagedFood.COOKED_HORSE, PackagedFood.COOKED_WOLF, PackagedFood.COOKED_EGG));
        BAG_TYPE_DEFINITIONS.add(BaggedFoodDef.forFruit(new PackagedFood[0]));
        BAG_TYPE_DEFINITIONS.add(BaggedFoodDef.forMiscellaneous(new PackagedFood[0]));
        VARIANT_SET = new VariantSet();
        TYPE_INSTANCES = new HashMap<String, VfpVariant[]>();
    }

    static final class VariantSet
    extends VfpVariantSet.ByMap {
        VfpVariant[] _variant_array;
        private VfpOid _oid = VfpOid.Bag_of;

        VariantSet() {
            super("contents");
        }

        VariantSet(VfpOid oid, VfpVariant[] variants) {
            this();
            this._oid = oid;
            this._variant_array = variants;
        }

        @Override
        public String typeName() {
            return this._oid.fmlid();
        }

        @Override
        public Object markerObject() {
            return VariantSet.class;
        }

        @Override
        public boolean isOneOf(ItemStack stack, Object markerObject) {
            return markerObject == VariantSet.class || VfpPantryBag.class.isInstance(stack.func_77973_b());
        }

        @Override
        protected VfpVariant[] declaredVariants() {
            return this._variant_array == null ? this.values().toArray(VfpVariant.EMPTY_ARRAY) : this._variant_array;
        }

        @Override
        public Class func_177699_b() {
            return VfpTransientVariant.class;
        }
    }
}

