/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.carton;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.oredict.OreDictionary;
import org.jwaresoftware.mcmods.vfp.carton.BagsOf;
import org.jwaresoftware.mcmods.vfp.carton.BakeryCarton;
import org.jwaresoftware.mcmods.vfp.carton.FruitCarton;
import org.jwaresoftware.mcmods.vfp.carton.JarsCarton;
import org.jwaresoftware.mcmods.vfp.carton.MeatsCarton;
import org.jwaresoftware.mcmods.vfp.carton.VegetableCarton;
import org.jwaresoftware.mcmods.vfp.common.PackagedFood;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryBag;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;
import org.jwaresoftware.mcmods.vfp.core.VfpAchievements;
import org.jwaresoftware.mcmods.vfp.core.VfpBuildHelperSupport;
import org.jwaresoftware.mcmods.vfp.core.VfpBuilder;
import org.jwaresoftware.mcmods.vfp.core.VfpRewards;
import org.jwaresoftware.mcmods.vfp.core.VfpRuntime;
import org.jwaresoftware.mcmods.vfp.integrations.IntegrationsImpl;

public final class CartonsBuildHelper
extends VfpBuildHelperSupport {
    private List<ItemStack> _cartonTypeInstances = new ArrayList<ItemStack>();

    @Override
    protected String categoryName() {
        return "Containers";
    }

    @Override
    public void doBuildPrimaryObjects(FMLStateEvent event, VfpRuntime runtime) {
        VfpObj.Ink_Jar_obj = VfpBuilder.newStorageJar(VfpOid.Ink_Jar);
        VfpObj.Luminesce_Jar_obj = VfpBuilder.newStorageJar(VfpOid.Luminesce_Jar);
    }

    @Override
    public void doBuildSecondaryObjects(FMLStateEvent event, VfpRuntime runtime) {
        IntegrationsImpl.registerPackagedFoods(runtime.getConfig());
    }

    @Override
    public void doInitLikeFoods(VfpRuntime runtime) {
        VfpConfig config = runtime.getConfig();
        VfpObj.Bag_of_obj = BagsOf.get(config);
        VfpObj.Bakery_Carton_obj = BakeryCarton.get(config);
        VfpObj.Meat_Carton_obj = MeatsCarton.get(config);
        VfpObj.Vegetable_Carton_obj = VegetableCarton.get(config);
        VfpObj.Fruit_Carton_obj = FruitCarton.get(config);
        VfpObj.Jars_Carton_obj = JarsCarton.get(config);
    }

    @Override
    public void doBuildRecipes(VfpRuntime runtime) {
        BagsOf.autorecipe((VfpPantryBag)VfpObj.Bag_of_obj);
        this._cartonTypeInstances.addAll(Arrays.asList(BakeryCarton.autorecipe()));
        this._cartonTypeInstances.addAll(Arrays.asList(MeatsCarton.autorecipe()));
        this._cartonTypeInstances.addAll(Arrays.asList(VegetableCarton.autorecipe()));
        this._cartonTypeInstances.addAll(Arrays.asList(FruitCarton.autorecipe()));
        this._cartonTypeInstances.addAll(Arrays.asList(JarsCarton.autorecipe()));
        ItemStack xpworthy = new ItemStack(VfpObj.Ink_Jar_obj);
        VfpBuilder.autorecipe(this.categoryName(), VfpCapacity.TRAY, (Object)VfpObj.Ink_Sac_obj, xpworthy, VfpObj.Empty_Jar_obj, VfpObj.Ink_Sac_obj);
        VfpRewards.addRewardingCraftItem(xpworthy, VfpOid.Ink_Jar.craftingXp());
        if (VfpUtils.ingredientDefined("itemLuminesceSac")) {
            ItemStack luminesce = (ItemStack)OreDictionary.getOres((String)"itemLuminesceSac").get(0);
            xpworthy = new ItemStack(VfpObj.Luminesce_Jar_obj);
            VfpBuilder.autorecipe(this.categoryName(), VfpCapacity.TRAY, (Object)"itemLuminesceSac", xpworthy, VfpObj.Empty_Jar_obj, luminesce);
            VfpRewards.addRewardingCraftItem(xpworthy, VfpOid.Luminesce_Jar.craftingXp());
        }
    }

    @Override
    public void doBuildAchievementList(FMLStateEvent event, VfpRuntime runtime) {
        for (ItemStack carton : this._cartonTypeInstances) {
            VfpRewards.addRewardingCraftItem(carton, VfpAchievements.Id.AhHoardingWeShallGo);
        }
        this._cartonTypeInstances.clear();
        this._cartonTypeInstances = null;
        VfpRewards.addRewardingCraftItem(BakeryCarton.get(PackagedFood.CAKE), VfpAchievements.Id.LiesLiesLies);
    }

    @Override
    public void doInitRenderModels(FMLStateEvent event, VfpRuntime runtime) {
        if (runtime.hasUI()) {
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Ink_Jar, VfpObj.Ink_Jar_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Luminesce_Jar, VfpObj.Luminesce_Jar_obj);
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Bag_of, VfpObj.Bag_of_obj, BagsOf.variants());
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Bakery_Carton, VfpObj.Bakery_Carton_obj, BakeryCarton.variants());
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Meat_Carton, VfpObj.Meat_Carton_obj, MeatsCarton.variants());
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Vegetable_Carton, VfpObj.Vegetable_Carton_obj, VegetableCarton.variants());
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Fruit_Carton, VfpObj.Fruit_Carton_obj, FruitCarton.variants());
            runtime.doRenderSetupOrFail((VfpProfile)VfpOid.Jars_Carton, VfpObj.Jars_Carton_obj, JarsCarton.variants());
        }
    }

    public static boolean exclude(PackagedFood.Type type, PackagedFood bagof) {
        boolean done = false;
        switch (type) {
            case fruit: {
                done = FruitCarton.exclude(bagof);
                break;
            }
            case vegetable: {
                done = VegetableCarton.exclude(bagof);
                break;
            }
        }
        return done;
    }
}

